/* filename: PANLEFT.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <browse.h>
#include <brwsvars.h>

void PanLeft(DistanceType Distance)
{
  int n, width;

  if(Distance == OneField)
    n = 1;
  else {
    if(br_priv.FirstField != 1) {
      if(Distance == ScreensWorth) {
        n = br_priv.FirstField;
        width = 0;
        do {
          n--;
          width += br_priv.ColumnWidth[n-1] + 1;
        } while(!((width > br_priv.bScreenWidth) || (n == 1)));
        if(width > br_priv.bScreenWidth)
          n++;
        br_priv.LastField = br_priv.FirstField - 1;
        br_priv.FirstField = n;
        br_priv.CurrentField = br_priv.FirstField;
        PanPaintScreen();
      } else {
        n = 1;
        width = 0;

        do {
          n++;
          width += br_priv.ColumnWidth[n-1] + 1;
        } while ((width <= br_priv.bScreenWidth) || (n != br_priv.MaxFields));

        if(width > br_priv.bScreenWidth)
          n--;
        br_priv.LastField = n;
        br_priv.FirstField = 1;
        br_priv.CurrentField = 1;
        PanPaintScreen();
      }
    }
    return;
  }
  br_priv.CurrentField -= n;
  if(!br_priv.LockNum) {
    if(br_priv.CurrentField < 1)
      br_priv.CurrentField = 1;
    if(br_priv.CurrentField < br_priv.FirstField) {
      br_priv.FirstField -= n;
      PanPaintScreen();
    }
    return;
  }
  // we have locked fields. there are three circumstances:  unlock to unlocked,
  // unlocked to locked, and locked to locked
  if(br_priv.CurrentField > br_priv.LockNum) {  // unlocked to unlocked
    if(br_priv.CurrentField < br_priv.FirstField) {
      br_priv.FirstField -= n;
      br_priv.CurrentField = br_priv.FirstField;
      PanPaintScreen();
    }
    return;
  }
  if(br_priv.CurrentField == br_priv.LockNum) {   // unlocked to locked
    return;
  }
  if(br_priv.CurrentField < br_priv.LockNum) {    // locked to locked
    if(br_priv.CurrentField < 1)
      br_priv.CurrentField = 1;
    return;
  }
}
