/* filename: LOCATEST.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <string.h>
#include <utils.h>
#include <browse.h>
#include <brwsvars.h>

void LocateString(void)
{
  long RecNum;
  int fieldnumber = 0;
  int width, n, i;
  unsigned char PromptWidth;

  RecNum = WorkArea[Selected]->Handle.CurRecNo;
  if((unsigned int) (br_priv.bScreenWidth - 1) < (60 + strlen(Search_Prompt)))
    PromptWidth = (br_priv.bScreenWidth - 1) - strlen(Search_Prompt);
  else
    PromptWidth = 60;
  SaveVideoLine();
  PushMouse();
  SayGet(br_priv.ConversationRow, br_priv.FirstColumn, Search_Prompt, br_priv.SearchString, _S, PromptWidth, 0);
  ReadGets();
  PopMouse();
  strcpy(br_priv.SearchString, Trim(br_priv.SearchString));
  if(!*(br_priv.SearchString))
    goto bailout;
  At(br_priv.ConversationRow, br_priv.FirstColumn, Space(br_priv.bScreenWidth));
  At(br_priv.ConversationRow, br_priv.FirstColumn, Copy(fBuildStr("Searching for %s...", br_priv.SearchString), 0, br_priv.bScreenWidth - 1));

  do {
    Search(br_priv.SearchString, &fieldnumber, FALSE);
    n = -1;
    for(i = 0; i < br_priv.MaxFields; i++)
      if(br_priv.FMAP[i] == (unsigned char) fieldnumber)
        n = i;
  } while(!((n >= 0) || (fieldnumber == 0)));

  if(!fieldnumber) {
    At(br_priv.ConversationRow, br_priv.FirstColumn, Space(br_priv.bScreenWidth));
    At(br_priv.ConversationRow, br_priv.FirstColumn, fBuildStr("%s%s", Trim(br_priv.SearchString), NOT_found_Press_any_key));
    Wait("");
    Go(RecNum);
    goto bailout;
  } else  {
    br_priv.FirstField = n + 1;
    width = 0;

    do {
      width += br_priv.ColumnWidth[n++] + 1;
    } while(!((width > br_priv.bScreenWidth) || (n == br_priv.MaxFields)));

    if(width > br_priv.bScreenWidth)
      n -= 2;
    br_priv.LastField = n + 1;
    br_priv.CurrentField = br_priv.FirstField;
    br_priv.LRecNo = 0L;
    br_priv.FirstRecord = br_priv.LRecNo;
    br_priv.RecNoList[(int)(br_priv.LRecNo - br_priv.FirstRecord)] = WorkArea[Selected]->Handle.CurRecNo;
    RestoreVideoLine();
    PanPaintScreen();
  }

bailout:
  if(!fieldnumber)
    RestoreVideoLine();
}
