/* filename: GETNEWCL.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <string.h>
#include <browse.h>
#include <brwsvars.h>

void GetNewCommandLine(char *Command)
{
  int  UsersCoordinatesAreDBASE;
  int  tr, SaveEsc;
  char SaveWatchKeys[STRSIZ];

  if(!br_priv.Switch.Command) {
    SayNotPermitted(Altering_BROWSE_Command);
    return;
  }

  // pop up a command line window
  UsersCoordinatesAreDBASE = dBASEOrder;
  dBASEOrder = TRUE;
  strcpy(SaveWatchKeys, WatchKeys);
  *WatchKeys = 0;
  SaveEsc = EscapeEnabled;
  EscapeEnabled = TRUE;
  // position the top row of the command box a few lines after tr, unless
  // there is not enough room
  tr = br_priv.TopRow;
  if(tr + 5 > MaxAvailRows() - 1)
    tr = MaxAvailRows() - 1 - 5;

  PushWindow(1, (char) (tr + 1), 80, (char) (tr + 6));
  Box(tr, 0, tr + 5, 79, 1, "Browse Command");

  // prompt for the new command
  PushMouse();
  SayGet(tr+1, 0, "", Command, _S, STRSIZ-2, 1);
  ReadGets();
  PopMouse();
  PopWindow();

  if(EditResult < 1) {
    ParseCommand(Command);
    InitializeBrowse(Command);
  }

  dBASEOrder = UsersCoordinatesAreDBASE;
  strcpy(WatchKeys, SaveWatchKeys);
  EscapeEnabled = SaveEsc;
}
