/* filename: DISPHEAD.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <utils.h>
#include <browse.h>
#include <brwsvars.h>

static char _tzfar _str1_[] = "                         \xB3            \xB3               \xB3Rec:            \xB3";
static char _tzfar _str2_[] = "                                                      \xB3Rec:            \xB3";

void DisplayHeadings(void)
{
  int i;
  unsigned char FileWidth, StatusSingleLine;
  DirStr p;
  NameStr n;
  ExtStr e;
  PathStr IndexFileName;

  br_priv.MenuItemCount = 0;

  if(!br_priv.Switch.NoMenu) {
    if(!br_priv.Switch.NoModify) {
      AddMenuItem(b_MenuEdit, 1);
      if(!br_priv.Switch.NoAppend)
        AddMenuItem(b_MenuAppend, 2);
      if(!br_priv.Switch.NoDelete)
        AddMenuItem(b_MenuDelete, 3);
      if(!br_priv.Switch.NoPack)
        AddMenuItem(b_MenuPack, 4);
    }
    AddMenuItem(b_MenuGoTo, 5);
    if(br_priv.IndexIsOpen)
      AddMenuItem(b_MenuFind, 6);
    AddMenuItem(b_MenuGotoTop ,7);
    AddMenuItem(b_MenuGotoBottom, 8);
    AddMenuItem(b_MenuSearch, 9);
    if(br_priv.Switch.Command)
      AddMenuItem(b_MenuCommand, 10);
    AddMenuItem(b_MenuQuit, 13);
  }

  br_priv.LastField = br_priv.MaxFields;

  At(br_priv.FieldListRow + 1, br_priv.FirstColumn, Replicate('\xCD', br_priv.bScreenWidth));
  JoinLines((unsigned char) (br_priv.FieldListRow + 1), br_priv.BrowseBox.c1, DoubleLine, br_priv.BrowseBox.LineStyle, JLeft);
  JoinLines((unsigned char) (br_priv.FieldListRow + 1), br_priv.BrowseBox.c2, DoubleLine, br_priv.BrowseBox.LineStyle, JRight);

  if(!br_priv.Switch.NoStatus) {
    At(br_priv.StatusRow - 1, br_priv.FirstColumn, Replicate('\xCD', br_priv.bScreenWidth));
    JoinLines((unsigned char) (br_priv.StatusRow - 1), br_priv.BrowseBox.c1, DoubleLine, br_priv.BrowseBox.LineStyle, JLeft);
    JoinLines((unsigned char) (br_priv.StatusRow - 1), br_priv.BrowseBox.c2, DoubleLine, br_priv.BrowseBox.LineStyle, JRight);
  }

  SetColorTo(br_priv.Color.SF, br_priv.Color.SB, br_priv.Color.SF, br_priv.Color.SB);

  At(br_priv.FieldListRow, br_priv.FirstColumn, Space(br_priv.bScreenWidth)); // clear the field header area
  StatusSingleLine = SingleLine || (br_priv.BrowseBox.LineStyle & Raised) ||
                     (br_priv.BrowseBox.LineStyle & Recessed);
  // handle any locked fields first
  if(br_priv.LockNum)
    for(i = 0; i < br_priv.LockNum; i++)
      if(br_priv.Column[i] + br_priv.ColumnWidth[i] <= (unsigned int)br_priv.LastColumn) {
        At(br_priv.FieldListRow, br_priv.Column[i], _Field(i+1));
        if(i) {
          At(br_priv.FieldListRow, br_priv.Column[i] - 1, "\xB3");
          Paint(br_priv.FieldListRow, br_priv.Column[i] - 1, 1, br_priv.Color.F, br_priv.Color.B);
          JoinLines((unsigned char)(br_priv.FieldListRow + 1), (unsigned char)(br_priv.Column[i] - 1), DoubleLine, SingleLine, JBottom);
        }
      } else {
        br_priv.LastField = i;
        i = br_priv.MaxFields-1;
      }

  for(i = br_priv.FirstField; i <= br_priv.MaxFields; i++)
    if(br_priv.Column[i-1] - Offset() + br_priv.ColumnWidth[i-1] - 1 <= (unsigned int) br_priv.LastColumn) {
      At(br_priv.FieldListRow, br_priv.Column[i-1] - Offset(), _Field(i));
      if((i > 1) && (br_priv.Column[i-1] - Offset() - 1 > br_priv.BrowseBox.c1)) {
        At(br_priv.FieldListRow, br_priv.Column[i-1] - Offset() - 1, "\xB3");
        Paint(br_priv.FieldListRow, br_priv.Column[i-1] - Offset() - 1, 1, br_priv.Color.F, br_priv.Color.B);
        JoinLines((unsigned char)(br_priv.FieldListRow + 1), (unsigned char)(br_priv.Column[i-1] - Offset() - 1), DoubleLine, SingleLine, JBottom);
      }
    } else {
      br_priv.LastField = i - 1;
      i = br_priv.MaxFields;
    }

  if(br_priv.CurrentField > br_priv.LastField)
    br_priv.CurrentField = br_priv.LastField;

  SetColorTo(br_priv.Color.F, br_priv.Color.B, br_priv.Color.F, br_priv.Color.B);

  // display the bottom status line
  if(!br_priv.Switch.NoStatus) { // windowed screen:
    if(br_priv.IndexIsOpen) {
      FileWidth = 25;
      At(br_priv.StatusRow, br_priv.FirstColumn, Copy(_str1_, 0, br_priv.bScreenWidth));
      JoinLines((unsigned char) (br_priv.StatusRow - 1), (unsigned char) (br_priv.FirstColumn + 25), DoubleLine, SingleLine, JTop);
      JoinLines((unsigned char) (br_priv.StatusRow + 1), (unsigned char) (br_priv.FirstColumn + 25), br_priv.BrowseBox.LineStyle, SingleLine, JBottom);
      JoinLines((unsigned char) (br_priv.StatusRow - 1), (unsigned char) (br_priv.FirstColumn + 38), DoubleLine, SingleLine, JTop);
      JoinLines((unsigned char) (br_priv.StatusRow + 1), (unsigned char) (br_priv.FirstColumn + 38), br_priv.BrowseBox.LineStyle, SingleLine, JBottom);
      JoinLines((unsigned char) (br_priv.StatusRow - 1), (unsigned char) (br_priv.FirstColumn + 54), DoubleLine, SingleLine, JTop);
      JoinLines((unsigned char) (br_priv.StatusRow + 1), (unsigned char) (br_priv.FirstColumn + 54), br_priv.BrowseBox.LineStyle, SingleLine, JBottom);
      JoinLines((unsigned char) (br_priv.StatusRow - 1), (unsigned char) (br_priv.FirstColumn + 71), DoubleLine, SingleLine, JTop);

      if(!(MouseDriverPresent && TopazMouseEnabled && br_priv.BrowseBox.LineStyle))
        JoinLines((unsigned char) (br_priv.StatusRow + 1), (unsigned char) (br_priv.FirstColumn + 71), br_priv.BrowseBox.LineStyle, SingleLine, JBottom);
    } else {
      FileWidth = 54;
      At(br_priv.StatusRow, br_priv.FirstColumn, Copy(_str2_, 0, br_priv.bScreenWidth));
      JoinLines((unsigned char) (br_priv.StatusRow - 1), (unsigned char) (br_priv.FirstColumn + 54), DoubleLine, SingleLine, JTop);
      JoinLines((unsigned char) (br_priv.StatusRow + 1), (unsigned char) (br_priv.FirstColumn + 54), br_priv.BrowseBox.LineStyle, StatusSingleLine, JBottom);
      JoinLines((unsigned char) (br_priv.StatusRow - 1), (unsigned char) (br_priv.FirstColumn + 71), DoubleLine, SingleLine, JTop);

      if(!(MouseDriverPresent && TopazMouseEnabled && br_priv.BrowseBox.LineStyle))
        JoinLines((unsigned char) (br_priv.StatusRow + 1), (unsigned char) (br_priv.FirstColumn + 71), br_priv.BrowseBox.LineStyle, StatusSingleLine, JBottom);
    }
    if(br_priv.FirstColumn + 55 < br_priv.bScreenWidth - 16)
      Paint(br_priv.StatusRow, br_priv.FirstColumn + 55, 16, br_priv.Color.SF, br_priv.Color.SB);
    PushColors();
    SetColorTo(br_priv.Color.SF, br_priv.Color.SB, br_priv.Color.SF, br_priv.Color.SB);
    At(br_priv.StatusRow, br_priv.FirstColumn, Copy(Shorten(DBF(), FileWidth), 0, br_priv.bScreenWidth));
    // display the primary index, if an index is active, and its keylength,
    // maybe even the first few chars of the key
    if(br_priv.IndexIsOpen) {
      strcpy(IndexFileName, (*IndexRoutines.IndexNameProc)(0));
      FSplit(IndexFileName, p, n, e);
      if(br_priv.FirstColumn + 26 < br_priv.LastColumn - 12)
        At(br_priv.StatusRow, br_priv.FirstColumn + 26, Pad(fBuildStr("%s%s", n, e), 12));
    }
    PopColors();
    DisplayRecordNumber();
  }
  SetColorTo(br_priv.Color.F, br_priv.Color.B, br_priv.Color.HF, br_priv.Color.HB);
}
