/* filename: BROWSE.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <conio.h>
#include <string.h>
#include <stdlib.h>
#include <utils.h>
#include <browse.h>
#include <brwsvars.h>

extern int  MouseNewField;
extern long MouseNewRecord;
extern long MouseNewLRecno;

extern void HandleMousePlacement(void);

void Browse(char *Cmd)
{
  struct REGPACK cpu;
  int  SaveX, SaveY;
  long RecordNumber;
  int  ScrollStop;
  int  SaveMousePlacement;
  char Command[STRSIZ];

  if (!CheckRegisteredUnits("Browse",
      REGTZCOMMON+REGTZDBF+REGTZVIDPOP+REGTZSAYGET+REGTZBROWSE))
    return;

  if(!WorkArea[Selected] || !WorkArea[Selected]->Handle.NumRecs || dEOF())
    return;

  if(!WorkArea[Selected]->Handle.Fields && !WorkArea[Selected]->DataDef) {
    SetError(InvalidLLOperation, 3, No_structure_or_Data_Definition_for_VFile, DBF(), " [BROWSE]");
    return;
  }

  strcpy(Command, Cmd);
  PushColors();
  CurrentColors(&br_priv.Color.F, &br_priv.Color.B, &br_priv.Color.HF, &br_priv.Color.HB);
  br_priv.OldDbaseOrder = dBASEOrder;
  dBASEOrder = TRUE;
  br_priv.OldLeftDelimiter[0]  = LeftDelimiter;
  br_priv.OldRightDelimiter[0] = RightDelimiter;
  br_priv.OldEscape = EscapeEnabled;
  EscapeEnabled  = FALSE;
  ExitBrowse     = FALSE;
  LeftDelimiter  = 0;
  RightDelimiter = 0;

  memset(&cpu, 0, sizeof(cpu)); // get and save existing cursor shape
  cpu.r_ax = 0x0300;            // read cursor position/size
  cpu.r_bx = 0x0000;            // page 0
  intr(0x10, &cpu);
  br_priv.SavedCursor = cpu.r_cx;     // CH = starting line of cursor
  // CL = ending line of cursor
  if(VideoMode() == 7)          // mono
    if(br_priv.SavedCursor == 0x0607) // bug in BIOS returns color shape on mono systems
      br_priv.SavedCursor = 0x0C0D;   // proper mono shape
  SaveX = wherex();
  SaveY = wherey();
  br_priv.LockNum = 0;
  br_priv.RootAlias = NULL;
  br_priv.InitialRecord = WorkArea[Selected]->Handle.CurRecNo;

  SaveMousePlacement = AutoMousePlacement;
  AutoMousePlacement = FALSE;
  InitializeBrowse(Command); // mouse enabled in InitializeBrowse

  // new way
  if(ExitBrowse)
    goto CleanUp;

  // begin loop
  br_priv.Abort = FALSE;
  PaintCell();
  do {
    BrowseGetKey();
    UnPaintCell();
    if(!(br_priv.Key >> 8)) {
      switch((char) (br_priv.Key & 0xff)) {
        case bUpArrow:
          do {
            HandleUpArrow();
            PaintCell();
            DisplayRecordNumber();
            ScrollStop = WaitBTT(TRUE);
            UnPaintCell();
          } while(TopazMouseEnabled && MouseDriverPresent &&
                  IsLeftButtonDown() && ScrollStop);
          break;

        case bDnArrow:
          do {
            HandleDnArrow();
            PaintCell();
            ScrollStop = WaitBTT(FALSE);
            DisplayRecordNumber();
            UnPaintCell();
          } while(TopazMouseEnabled && MouseDriverPresent &&
                  IsLeftButtonDown() && ScrollStop);
          break;

        case bLtArrow:
          PanLeft(OneField);
          break;

        case bRtArrow:
          PanRight(OneField);
          break;

        case bCtrlLtArrow:
          PanLeft(ScreensWorth);
          break;

        case bCtrlRtArrow:
          PanRight(ScreensWorth);
          break;

        case bCtrlHome:
          PanLeft(SuperPan);
          break;

        case bCtrlEnd:
          PanRight(SuperPan);
          break;

        case bPgUp:
          RecordNumber = WorkArea[Selected]->Handle.CurRecNo;
          if(!WorkArea[Selected]->WhileFunc)
            Skip(-br_priv.LRecNo + br_priv.FirstRecord - br_priv.BrowseRows + 1);
          else {         // if there is a while function,we need to skip
            br_priv.iskip = 0; // records one at a time
            do {
              Skip(-1);
              br_priv.iskip++;
            } while((br_priv.iskip != br_priv.LRecNo - br_priv.FirstRecord + br_priv.BrowseRows - 1) && !dBOF());
          }
          if(WorkArea[Selected]->Handle.CurRecNo != RecordNumber) {
            // if we were at the top of the file, do nothing
            br_priv.LRecNo -= br_priv.BrowseRows - 1; // windowed screen
            // call user defined calc procedure
            if(dBOF())
              RedefineLRecNo();
            else
              DisplayRecordNumber();
            if(br_priv.AppendInProgress) {
              br_priv.EditDirection = br_priv.SaveEditDirection;
              br_priv.AppendInProgress = FALSE;
            }
            HandleScrollDown();
            br_priv.CellWasEdited = FALSE;
            LastKey = 0;
            DoUsersCalculations();
          }
          break;

        case bPgDn:
          RecordNumber = WorkArea[Selected]->Handle.CurRecNo;
          if(!WorkArea[Selected]->WhileFunc)
            Skip(br_priv.BrowseRows - (br_priv.LRecNo - br_priv.FirstRecord) - 1);
          else {
            br_priv.iskip = 0;
            do {
              Skip(1);
              br_priv.iskip++;
            } while((br_priv.iskip != br_priv.BrowseRows - (br_priv.LRecNo - br_priv.FirstRecord) - 1) && !dEOF());
          }
          if(dEOF())
            Go(RecordNumber);
          else {
            br_priv.LRecNo += br_priv.BrowseRows + 1; // windowed screen
            if(dEOF()) {
              Skip(-1);
              RedefineLRecNo();
            } else
              DisplayRecordNumber();
            if(br_priv.AppendInProgress) {
              br_priv.EditDirection = br_priv.SaveEditDirection;
              br_priv.AppendInProgress = FALSE;
            }
            HandleScrollUp();
            br_priv.CellWasEdited = FALSE;
            LastKey = 0;
            DoUsersCalculations();
          }
          break;

        case bHome:
          GoToTop();
          break;

        case b_End:
          GoToBottom();
          break;

        case bToggleDeleteKey:
          ToggleDelete();
          break;

        case F2:
        case bPseudoF2:
          EditCell();
          break;

        case F3:
          AppendRecord();
          break;

        case F4:
          PackDataBase();
          if(!RecCount())
            br_priv.Abort = TRUE;
          break;

        case F5:
          GoToRecord();
          break;

        case F6:
          FindRecord();
          break;

        case F7:
          GetNewCommandLine(Command);
          break;

        case F8:
          LocateString();
          break;

        case F10:
          if(br_priv.MenuItemCount)
            switch(DisplayBarMenu()) {
              case 1:
                EditCell();
                break;

              case 2:
                AppendRecord();
                break;

              case 3:
                ToggleDelete();
                break;

              case 4:
                PackDataBase();
                if(!RecCount())
                  br_priv.Abort = TRUE;
                break;

              case 5:
                GoToRecord();
                break;

              case 6:
                FindRecord();
                break;

              case 7:
                GoToTop();
                break;

              case 8:
                GoToBottom();
                break;

              case 9:
                LocateString();
                break;

              case 10:
                GetNewCommandLine(Command);
                break;

              default:
                break;
            }
          break;

        case bGotoCell:
          br_priv.CurrentField = MouseNewField;
          if(MouseNewRecord) {
            br_priv.LRecNo = MouseNewLRecno;
            HandleMousePlacement();
          }
          break;

        case bGotoCellThenEdit:
          EditCell();
          break;

        default:
          FlushKeyboard();
          break;
      } // {{ case }}
    } else
      FlushKeyboard();

    if(ExitBrowse) // new way
      br_priv.Abort = TRUE;

    DisplayRecordNumber();
    PaintCell();
  } while(!((strchr(BrowseExitKeys, (br_priv.Key >> 8)) && (br_priv.Key >> 8)) || br_priv.Abort));
  // default keys are [ESC, #13]

CleanUp:
  PopColors();
  AutoMousePlacement = SaveMousePlacement;
  if(MouseDriverPresent && TopazMouseEnabled && (br_priv.BrowseBox.LineStyle > 0))
    DisableMouse(); // draw the mouse buttons and define the mouse targets
  // restore the former window, coordinate system, SAYGET delimiters, and cursor
  window(br_priv.OldWinLeft, br_priv.OldWinTop, br_priv.OldWinRight, br_priv.OldWinBottom);
  gotoxy(SaveX,SaveY);
  dBASEOrder     = br_priv.OldDbaseOrder;
  LeftDelimiter  = br_priv.OldLeftDelimiter[0];
  RightDelimiter = br_priv.OldRightDelimiter[0];
  EscapeEnabled  = br_priv.OldEscape;
  memset(&cpu,0, sizeof(cpu));
  cpu.r_ax = 0x0100;
  cpu.r_cx = br_priv.SavedCursor;
  intr(0x10, &cpu);

  // Release any memory that may have been taken by the list of alias field names:
  ReleaseAliasMemory();
  free(br_priv.MenuList);
  br_priv.BrowseActive = (BrowseLevel(0) > 0);
}
