/* filename: BPUSHPOP.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <malloc.h>
#include <string.h>
#include <browse.h>
#include <brwsvars.h>

typedef struct {
  char  BrowseFieldSeparator[2];
  char  BrowseVerticalChar[2];
  unsigned char BrowseVerticalColor;
  char  BrowseExitKeys[40];
  int   ExitBrowse;
  void  *SavePublicVars;
  char  BrowseMenuKey;
} BrowsePublicVars;

static BrowsePublicVars _tzfar br_global = {{0}};
static unsigned  Size;
static void     *TempPtr;

void PushBrowse(void)
{
  int error;

  if(!br_priv.BrowseActive) {
    error = BrowseNotActive;
    goto ERROR;
  } else {
    Size = sizeof(struct BrowsePrivateVars);
    if ((TempPtr = malloc(Size)) == NULL) {
      error = 217;
      goto ERROR;
    }
    memcpy(TempPtr, &br_priv, Size);
    br_priv.SavePrivateVars = TempPtr;
    // do it again for the public vars
    Size = sizeof(BrowsePublicVars);
    strcpy(br_global.BrowseFieldSeparator, BrowseFieldSeparator);
    strcpy(br_global.BrowseVerticalChar,   BrowseVerticalChar);
    strcpy(br_global.BrowseExitKeys,       BrowseExitKeys);
    br_global.BrowseVerticalColor = BrowseVerticalColor;
    br_global.ExitBrowse          = ExitBrowse;
    br_global.SavePublicVars      = SavePublicVars;
    br_global.BrowseMenuKey       = BrowseMenuKey;

    if((TempPtr = malloc(Size)) == NULL) {
      error = 217;
      goto ERROR;
    }
    memcpy(TempPtr, &br_global, Size);
    SavePublicVars = TempPtr;
    BrowseLevel(1);
  }
  return;

ERROR:
  SetError(error, 1, " [PushBrowse]");
}

void PopBrowse(void)
{
  if(!br_priv.BrowseActive) {
    SetError(BrowseNotActive, 1, " [PopBrowse]");
    return;
  } else {
    Size = sizeof(BrowsePublicVars);
    TempPtr = SavePublicVars;
    memcpy(&br_global, TempPtr, Size);
    free(TempPtr);

    strcpy(BrowseFieldSeparator, br_global.BrowseFieldSeparator);
    strcpy(BrowseVerticalChar,   br_global.BrowseVerticalChar);
    strcpy(BrowseExitKeys,       br_global.BrowseExitKeys);
    BrowseVerticalColor = br_global.BrowseVerticalColor;
    ExitBrowse          = br_global.ExitBrowse;
    SavePublicVars      = br_global.SavePublicVars;
    BrowseMenuKey       = br_global.BrowseMenuKey;

    // repeat for the private vars
    Size = sizeof(struct BrowsePrivateVars);
    TempPtr = br_priv.SavePrivateVars;
    memcpy(&br_priv, TempPtr, Size);
    free(TempPtr);
    BrowseLevel(-1);
  }
}
