/* filename: VIDPOP.H

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef WINDOWS
#ifndef _TZVIDPOP
#define _TZVIDPOP
#define TZVIDPOP

#include <stdio.h>

#ifdef TOPAZINI
#error You should put init.h as the last header file in your MAIN file.
#endif

#ifndef _TZCOMMON
#include <common.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define LOWER256 1
#define UPPER256 0

#define AbsoluteMaxCols    80
#define AbsoluteMaxRows    66
#define FirstForeignChar   ''
#define LastForeignChar    ''
#define MaxScreenLibraries 10
#define escape          '\x1B'
#define blankline       '\x01'
#define carriage_return '\r'
#define ZERO            '\x0'
#define TicksAtMidnight 1573040L    //  roughly
#define ON TRUE
// Screen types
#define SubScreen 0
#define Full24    1
#define Full25    2
#define Full43    3
#define Full50    4
#define Full60    5
#define Full66    6

typedef char String8[9];

typedef struct WindowRec {
   char      c1, r1, c2, r2;
   char      * BufferPtr;
   unsigned  BufferSize;
   int       SaveBuffer;
} WindowRec;

typedef enum {  Manual, SemiAutomatic, Automatic } SwitchType;
typedef struct WindowStackRecord *WindowPtr;
//typedef char ColorMapArray[128];
typedef char string14[15];
typedef struct HiLo {
   char  Lo;
   char  Hi;
} HiLo;

typedef char ThreeByteInteger[3]; // 3 byte BCD number for compatibility
//    with Turbo version 3.x
typedef struct LibraryHeader {
  char SL[3];
  char Version;
  char DateAndTime[18];
  int NumberOfScreens;
  ThreeByteInteger SizeOfFile;
  char SizeOfHeader;
  int SizeOfDirectory;
  char Reserved[16];
} LibraryHeader;

typedef struct directory_record {
  char Name[8];
  ThreeByteInteger Pointer;
  int Size;
  int Reserved;
} directory_record;

typedef struct directory_record *DirectoryPointer;

typedef directory_record full_directory[100];

typedef DirectoryPointer directory_array[100];

typedef struct library_array_record {
  char   Filename[65];
  FILE * LibraryFile;
  LibraryHeader *Header;
  directory_array LibraryDirectory;
  int    LibraryOpen;
  int    KeepOpen;
} library_array_record;

typedef directory_array *library_directory_array_pointer;

typedef struct MenuRecord {
  char   MenuSeed;
  char   MenuChar;
  char   MenuKey;
  char   MenuChoice;
  char   MenuString[AbsoluteMaxCols+1];
  int    MenuEscapeEnable;
  void   (* MenuHelpProc)(void);
  void   (* MenuFKeyProc)(void);
  char   MenuBarAttr;
  char   FKeys[41];   //  should not be more than 40 Fkeys
  struct MenuRecord * PriorMenu;
} MenuRecord;
typedef struct MenuRecord *MenuPtr;

typedef struct WindowStackRecord {
  WindowRec w;
  WindowPtr PriorWindow;
} WindowStackRecord;
typedef struct WindowStackRecord *WindowPtr;

/*  NOTICE !!  Whenever you make a change to the GetRecord structure below,
      be sure to modify the LoadVersion3Gets procedure in Saywhat so that
      it properly initializes the new vars whenever a version 3 screen is
      loaded !!

ALSO, make the same changes in the V4_CVRT.PAS conversion routine
ALSO, make appropriate changes to the SCRNEDIT unit.  It builds
      an internal version of the GetRecord.  Prior to any GetMems it checks
      to see if there will be enough memory for the largest possible set of
      strings, so if any of the string sizes change, the memory check needs
      to be fixed.  */

typedef struct GetRecord {
  int  Column;
  int  Row;
  char DBFAlias[11];
  char FieldName[21];
  char PictureClause[51];
  char SayOrGet;   // Logical, TRUE = a GET, FALSE = a SAY  
  char Foreground;
  char BackGround;
  char FieldLength;
  char FieldType[3];
  char FieldDecimals;
  char NoEdit;          
  char BlankField;      
  char Required;        
  char RangeLower[11];
  char RangeUpper[11];
  char ValidClause[26];
  char WhenClause[26];
  char FutureUse[11];
} GetRecord;

//  The following types define the structures of a SQZ file header.
typedef struct HeaderIDType {
  char ID;   // S
  char Version; // 4
} HeaderIDType;

typedef struct CoordinatesType {
  char R1;
  char C1;
  char R2;
  char C2;
} CoordinatesType;

typedef struct V3HeaderType {
  HeaderIDType HeaderID;
  CoordinatesType ScreenCoord;
  char BorderColor;
  char MenuColor;
  char BrightEnable;
  char Spare1;
  char Spare2;
  char MovingBarMenu;
} V3HeaderType;

typedef struct SqzHeaderType {
  HeaderIDType HeaderID;
  unsigned SqzOffset; // Start of SQZ information
  unsigned SqzSize;
  unsigned GetOffset; // Start of GET information
  unsigned GetSize;
  unsigned SpareOffset1; // Reserved for future use
  unsigned SpareSize1;
  unsigned SpareOffset2; // Reserved for future use
  unsigned SpareSize2;
  unsigned PaletteOffset;// Start of Screen Palette
  char PaletteSize;
  char ScreenType;
  CoordinatesType ScreenCoord;
  char BorderColor;
  char  BrightEnable;
  CoordinatesType MenuCoord;
  char MovingBarMenu;   //  whether or not menu exists
  char MenuColor;   //  highlight color
  char ScreenSize;
  char Sparechar;
} SqzHeaderType;   //  identify when it gets used!

typedef enum {  Version3,Version4 } VersionNames;

extern int     ClearTopLine;
extern char _tzfar FKeyExit[41];
extern int     GetMenuResponse;
extern int     InhibitSnow;
extern void    (*MenuFKeyProc)(void);
extern void    (*MenuHelpProc)(void);
extern MenuPtr MenuStackPtr;
extern char    MenuTimeOutValue;
extern int     ResetBackground;
extern void    *ScreenAddress;   //  Base address of video memory
extern void    SetUserGetProcTo(void (* UserProcedure)(GetRecord * ptr));
extern int     SuppressDisplay;
extern int     TopStatusLine;
extern int     UseSnowInhibition;
extern unsigned  UsersCursor;
extern WindowPtr WindowStackPtr;
extern library_array_record *LibraryArray[MaxScreenLibraries];
extern SwitchType LineSwitchMode;
extern unsigned char OneLineLength;   //  One DISPLAY line length = MaxCols * 2
extern int AutoSaveMode;
extern int MenuEscapeEnable;
extern char _tzfar MenuString[STRSIZ];
extern int MenuChoice;
extern char MenuChar;
extern int MenuSeed;
extern char MenuKey;
extern int IgnoreNumLock;
extern int ExitMenu;   //  allows exiting menu via FKEY procedure
extern int EnableLeftRightMenuExit;
extern int EnableUpDownMenuExit;
extern int VgaBrightBackEnabled;

extern unsigned  BaseSeg;
extern unsigned  VidpopPageSize;
/*
Normal page sizes:
25 lines = 4000;  chars per screen CGA/MDA
43 lines = 6880;  EGA 43 line mode
50 lines = 8000;  VGA 50 line mode
*/

//  VideoCard constants:
#define MonoCard  0x0100 // standard monochrome cards
#define HercMono  0x0200 // Hercules monochrome cards
#define HGCPLUS   0x0201 // HGCPLUS  (monochrome)
#define InColor   0x0202 // Hercules InColor card (color or mono)
#define CGACard   0x0300 // standard Color Graphics Cards
#define EGAColor  0x0400 // EGA w/EGA color monitor
#define EGAMono   0x0401 // EGA w/Monochrome monitor
#define EGACGA    0x0403 // EGA w/CGA monitor
#define VGAColor  0x0500 // VGA w/VGA color monitor
#define VGAMono   0x0501 // VGA w/VGA monochrome monitor
#define MCGAColor 0x0600 // MCGA w/Color monitor
#define MCGAMono  0x0601 // MCGA w/Monochrome monitor

extern unsigned char NewRow;
extern unsigned char NewCol;
extern unsigned VideoOffset;
extern unsigned char MaxCols;
extern unsigned char MaxRows;

extern int  BW;
extern int  ScreenFound;
extern int  Shift;
extern int  AddShadow;
extern int  TopView;
extern char MenuBarAttr;
extern int  MovingBarMenu;
extern void (* ClockPtr)(void);
extern void (*UserGetProc)(GetRecord * ptr);
extern char *ColorMap;

char AbsWhereX(void);  //  returns cursor position regardless of windows
char AbsWhereY(void);
char CardCap(void);
void ClearWindowStack(void);  //  recover memory without display
void CloseLibrary(char which);
int _far CPUType(void);// Returns: 0 - i88, 1 - i86, 2 - i286, 3 - i386, 4 - i486
void CreateMenu(char startcol, char startrow, char stopcol,
     char stoprow, char Foreground, char Background);
void Decolor(char * b);
void pascal DecolorA(void far * memr, int Count);
void DisplayPage(void * PagePtr);
void DisplayWindow(WindowRec *w);
void FillPage(void * PagePtr);
void FillWindow(unsigned char x1, unsigned char y1, unsigned char x2, unsigned char y2, WindowRec *w);
BOOL GraphicsMode(void); // returns TRUE IF current mode is
                         // one of the various graphics modes
void HandleMovingBarMenu(char start_menu_x, char start_menu_y,
    char stop_menu_x, char stop_menu_y);
void HandleLineMode(char ScreenRows, char CreateMode);
int  HasEga(void);
BOOL IsColor(void);
unsigned char MaxAvailRows(void);
String8  *MemLibScreenName(LibraryHeader * Library, char Number);
String8  *LibScreenName(char which, char Number);
void OpenLibrary(char which, char * newfilename, BOOL stayopen);
void PopMenu(void);
void PopWindow(void);
void PopScreen(void * DataPointer);
void PopSqz(char * FileName);
void PopLib(char which, char * TargetScreen);
void PopLibMem(LibraryHeader * Library, char * TargetScreen);
void PushMenu(void);
void PushWindow(char x1, char y1, char x2, char y2);
void ReMap(char * b);
void SetBrightBackground(char Global_Byte);
void SetBwOn(void);
void SetBwOff(void);
void SetColorMapTo(void * mapdata);
void SetMenuFkeysTo(char * s, void (* userproc)(void));
void SetMenuHelpTo(void (* user_routine)(void));
void SetMenuHookTo(void (* p)(void));
void SetMenuTimeoutTo(char n);
void SetPositionTo(char col, char row);
void SetScreenShadowOn(void);
void SetScreenShadowOff(void);
void SetStatusTop(void);
void SetStatusBottom(void);
void SetSnowProtectionOn(void);
void SetSnowProtectionOff(void);
void Squeeze(char x1, char y1, char x2, char y2, const char * Filename);
void SwitchTo(char lines);
char SwitchTableResult(char ScreenRows, char CreateMode);
unsigned char VideoMode(void);  //  returns numeric display mode
unsigned pascal VideoCard(void);

// TZFONT functions
void  GetFont(void *FontPtr, unsigned StartingChar, unsigned Count);
int   LoadFont(const char *fontfilename, BOOL Primary);
int   LoadFontMem(void *FontID, BOOL Primary);
void  PushFont(BOOL Primary);
void  PopFont(void);

#ifdef __cplusplus
}
#endif

#endif // _TZVIDPOP
#endif // not WINDOWS

