/* filename: VFILES.H

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef _TZVFILES
#define _TZVFILES
#define TZVFILES

#include <dos.h>
#include <string.h>
#include <stdlib.h>
#include <malloc.h>

#ifdef TOPAZINI
#error You should put init.h as the last header file in your MAIN file.
#endif

#ifndef _TZCOMMON
#include <common.h>
#endif

#ifndef _TZDBF
#include <dbf.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifdef _MSC_VER
#define diskfree_t  _diskfree_t
#endif

#define EXTPAGESIZE     16384 // Size of each EXTended memory page. Comes out of
                              // the HEAP when a Virtual file is opened 'TO EXT'
#define EMSPAGESIZE     16384
#define MAXEMSPAGES     128   // works out to about 2 meg of EMS

#define EMSFREELISTSIZE (EMSPAGESIZE / 2)  // the free list fits in the 3
                                           // unused EMS page frame pages.
#define EXTFREELISTSIZE (EXTPAGESIZE / 7)  // the free list fits in 1 Ext Page
#define KBPEREXTPAGE    (EXTPAGESIZE / 1024)
#define PARASPEREXTPAGE (EXTPAGESIZE / 16)

#define MAXEXTPAGES     94 // works out to about 1.5 meg of EXT

#define SearchBackward  1
#define SearchBottom    2
#define SearchForward   3
#define SearchTop       4

#define HI(c)           (char)(((unsigned int)(c) & 0xFF00) >> 8)
#define LO(c)           (char)((unsigned int)(c) & 0xFF)

// General data types - EXT, EMS and HEAP
typedef struct {
  union { // Selector is DataStorageType
    struct { void *DataPtr;            } sHeap;  // Heap memory
    struct { int EmsHandle, EmsOffset; } sEms;   // Expanded memory
    struct { int ExtIndex, ExtOffset;  } sExt;   // Extended memory
  } v;
} DataPointerType;

typedef struct {
  unsigned int    DataSize;
  DataPointerType FreeDataLoc;
} FreeListElement;

typedef struct LLItem {
  struct LLItem *LastRecPtr;
  struct LLItem *NextRecPtr;
  unsigned int   RecordSize;
  void          *DataPtr;
} LLItem, *LLItemPtr;

typedef enum { FROMUSERTOMEMORY, FROMMEMORYTOUSER } TypeOfMove;

// EMS Types
typedef unsigned int ArrayOfEmsPages[MAXEMSPAGES];
typedef FreeListElement EmsFreeListBuffer[EMSFREELISTSIZE];

// EXT Types
typedef enum { NOTASSIGNED, UPPER, EXTENDED } HandleType;

typedef struct {
  HandleType   HandleLoc;
  unsigned int Handle;
} ExtHandleType;

typedef FreeListElement ExtFreeListBuffer[EXTFREELISTSIZE];
typedef ExtHandleType ArrayOfExtPages[MAXEXTPAGES+1];
// NOTE: element 0 of ExtPageArray is the FreeList array page

typedef struct {
  long         LengthOfBlock;
  unsigned int SourceHandle;  // if Handle = 0
  void far    *SourceOffset;  // then Offset =
  unsigned int DestHandle;    // a memory address
  void far    *DestOffset;
} ExtMoveParams;

extern int EmsInstalled; // Flag indicating if EMS is available
extern int ExtInstalled; // True if the EXT driver is available

void _far _cdecl CallXmsDriver(struct REGPACK far *regs, void far *driver, int cmpl);

// Global routines
void AddStru(FieldArray FieldList, unsigned char FieldCount);
long AvailableMemory(char *MemoryType);
void CopyStruFrom(unsigned char WhichArea);
char *CurrentMemory(void);
char *EvaluateBest(void);
char *EvaluateBiggest(void);
long FreeSpace(void);
void InsertRec(void);
void PopRec(void);
void PushRec(void);
long RequiredMemory(char *MemoryType, long RecordCount, long RecordSize);
void SetVFileKeyTo(char *(*UserKeyPointer)(void));
void SetVFileModeTo(LStatusType VFileMode);
void SnipRec(void);
void SortVFile(LStatusType SortMode);
void TZVFilesInit(void);

// Local routines
BOOL NotAVirtualFile(char *proc);
void ActionLL(dbfRecord *Handle);
void AddLL(dbfRecord *Handle);
void AddNewHead(dbfRecord *Handle);
void AddNewTail(dbfRecord *Handle);
void AddPackedNodesToExtFreeList(void);
void CallExtDriver(struct REGPACK *Regs);
void ClearEmsFreeList(void);
void ClearEmsFreeListSpace(int FreeListIndex);
void ClearExtFreeList(void);
void ClearExtFreeListSpace(int FreeListIndex);
void CloseLL(dbfRecord *Handle);
void CreateStru(FieldArray FieldList, unsigned char FieldCount);
void DeleteLL(dbfRecord *Handle);
void DetermineStorageType(void);
int  EmsFreeListSpaceAvailable(int NeededSize, int *FreeListIndex);
int  EmsPresent(void);
int  ExtFreeListSpaceAvailable(int NeededSize, FreeListElement *FreeListData);
int  ExtPresent(void);
void FreeStorage(DataPointerType *FreeDataPtr, unsigned int FreeDataSize);
unsigned int GetAvailEmsPages(void);
unsigned int GetAvailExtKbytes(void);
unsigned int GetEmsHandle(unsigned int PagesDesired);
void far *GetEmsPagePointer(unsigned char Page);
unsigned char GetEMSstatus(void);
void GetExtHandle(ExtHandleType *ExtHandle);
void GetLL(dbfRecord *Handle);
void GetStorage(DataPointerType *DataPtr, unsigned int DataSize);
void InsertNewRecord(dbfRecord *Handle);
void LocateInsertLink(LStatusType SortMode, char *NewKey, dbfRecord *Handle);
int  MapEmsPage(unsigned int Handle, unsigned int LogicalPage, unsigned int PhysicalPage);
void MemoryManagementExitProc(void);
void MoveData(TypeOfMove Direction, void *UserRecPtr, DataPointerType *DataRecPtr, unsigned int DataSize);
int  MoveExtData(void);
int  NotAVirtualFile(char *proc);
void OpenLL(dbfRecord *Handle);
void OpenStorage(void);
void PackLL(dbfRecord *Handle);
void PopLL(dbfRecord *Handle);
void PushLL(dbfRecord *Handle);
void PutLL(dbfRecord *Handle);
void ReadPage(unsigned int PageNumber);
void RecallLL(dbfRecord *Handle);
int  ReleaseEmsHandle(unsigned int Handle);
void ReleaseExtHandle(ExtHandleType *ExtHandle);
void SaveExtNodeData(void);
void SavePointers(dbfRecord *Handle);
int  SearchFrom(dbfRecord *Handle);
void SeekItem(dbfRecord *Handle);
void SetupEmsFreeList(void);
void SetupExtFreeList(void);
void SetupPointers(dbfRecord *Handle);
int  Smaller(int I, int J, long *Values);
int  Smallest(long One, long Two, long Three);
void SnipExtNodePointers(dbfRecord *Handle);
void SnipLL(dbfRecord *Handle);
char *UsersKeyMaker(void);
char *WhichMemoryType(unsigned char area);
void WritePage(unsigned int PageNumber);
void ZapAllEmsStorage(void);
void ZapAllExtStorage(void);
void ZapLL(dbfRecord *Handle);
void ZapThisExtStorage(void);
long _wm_getdiskfreespace(unsigned char driver);

#ifdef __cplusplus
}
#endif

#endif
