/* filename: UTILS.H

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef _TZUTILS
#define _TZUTILS
#define TZUTILS

#ifndef TZCOMMON
#include <common.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define Length(x)  strlen(x)

#ifdef TOPAZINI
#error You should put init.h as the last header file in your MAIN file.
#endif

#define Empty(s) (!Trim(s)[0])

typedef struct DateTime {
	unsigned Year;
  unsigned Month;
  unsigned Day;
  unsigned Hour;
  unsigned Min;
  unsigned Sec;
} DateTime;

char *After(char *SubStr, char *s);
char *AddChar(char *str, char c);
char *Before(char *SubStr, char *s);
char *Between(char *SubStr1, char *SubStr2, char *s);
char *BuildStr(char *s, ...);
char *Center(char *s, int w);
void  Continue(void);
char *Copy(char _far *s, int i, int j);
long  Count(char *FieldName, void *FieldValue);
int   CPos(char x, char *str);
char *Delete(char _far *s, int StartPos, int Length);
char *Dollars(double Amt);
char *fBuildStr(char *fmt, ...);
BOOL  FileAge(char *fname, DateTime * Age);
BOOL  FileInUse(char *filename);
char *FractString(double Value, int Divisor);
unsigned char Indent(char *s, int w);
BOOL  InMemo(char *s, char *Addr);

#ifndef WINDOWS
void  LoadColorMap( char * fn );
void  PrintFile(char *fn);
#endif

void  Locate(char *FieldName, void *FieldValue);
void  ParseFieldName(char *s);
char *Plural(long Count, char *RootWord);
int   Pos(char *c, char * s);
char *ProperCase(char *s);
void  ReplaceStr(char *OldStr, char *NewStr, char *s, int CaseSens, int WordOnly, int CloneCase, int MaxLen, int *count);
long  Round(double x);
double Sum(char *FieldName);
char *VolumeLabel(char Drive);
char *FileDate(const char *filename);

#ifdef __cplusplus
}
#endif

#endif
