/* filename: TZPRINT.H

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef _TZPRINT
#define _TZPRINT
#define TZPRINT

#ifdef TOPAZINI
#error You should put init.h as the last header file in your MAIN file.
#endif

#ifndef FILE
#include <stdio.h>
#endif

#ifndef _REG_DEFS
#include <dos.h>
#endif

#ifndef _TZCOMMON
#include <common.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifndef _TZSAYGET
union MYREGS {
   struct  REGPACK  x;
   struct  BYTEREGS  h;
};
#endif

typedef enum {  Vertical,Horizontal } DirectionType;

typedef enum {
  TLCorner,BHorizontal,THorizontal,TRCorner,
  VerticalLine,BLCorner,BRCorner,Cross,
  TDeadEnd,BDeadEnd,RDeadEnd,LDeadEnd
} BoxPart;

typedef struct PrinterCommandLink {
  int    Column;
  int    Row;
  struct PrinterCommandLink *NextPtr;
  char   Command[STRSIZ-1];
} PrinterCommandLink, *PCLPtr;

#define SetAlternateOff() (AlternateOn = FALSE)    //  default
#define MaxPageLines()   (PMaxRows)
#define SetPrintOn()     (PrintOn = TRUE)
#define SetPrintOff()    (PrintOn = FALSE) 		   // default
#define WhatsAtPrint( c, r )  GetChar(c,r)

void  AddCommand( int c, int r, const char * s);
void  AtPrint( int col, int row, char * s);
void  AtPrintControl(int col, int row, const char * printercontrol);
void  AtPrintGrid( int ULCol, int ULRow, int LRCol, int LRRow,
			  int LineStyle, int NHorizontal, int NVertical);
void  AtPrintLine(DirectionType direction,
			 int col, int row, int len, int linestyle);
int   CallInt17(int ch, unsigned int lptno);
void  CheckPrinterStatus(void);
void  ClearPage(void);
char  * CodeInColumn( int row, int col );
void  Eject(void);
void  FindCodeInRow( int row );
char  GetChar( int col, int row);
char  *GetCommand( int c, int r );
void  MakePageBuffer(void);
void  PrintPage(void); /* .. to printer and possibly to other devices,
					   no deallocation of buffer  */
void  PutChar( int col, int row, int c);
int   RPrinterStatus(int portnumber);
void  ReleaseCommands(void);
void  SendPage(void);  /* ..to alternate device,
					no deallocation of buffer  */
void  SetAlternateOn(void);
void  SetAlternateTo(const char * filename);
void  SetPrinterPortTo(int printerport);
void  SetPageSizeTo(unsigned int width, unsigned int height);
						//  default = 80,66
void     SortCommands(void);
char  *  PageLine(unsigned int r);
char  *  WhatsAtPrintControl( int c, int r );
int      WriteToAlt(char * control, ...);

extern unsigned PrintDevice;/* default print device, 0 = LPT1,
						must be a word!  */
extern char PrintFramingChar;/* used by AtPrint for printer control
				code frame byte  (\xFF default)  */
extern unsigned char PrinterError;
extern FILE *Alt; //  required to write to alternate device
extern PCLPtr PCLHead, CPtr;
extern int AlternateOn, AlternateOpen;
extern int ConsoleOn;
extern int MaxCommands;
extern int PMaxRows;
extern unsigned int  PageWidth;
extern unsigned int  PageHeight;
extern char *	     PageBuffer;
extern int 	     PrintOn;

// P r e d e f i n e d       p r i n t e r       c o d e s

   //  predefined IBM/Epson printer codes:
#define CompressedPrint '\x0F'
#define NormalPrint '\x12'

	//  predefined Laser Jet Series II codes:
#define LJPortrait "\x1B&l0O"
#define LJLandscape "\x1B&l1O"
#define LJLinePrinter "\x1B(s0T\x1B(10U\x1B(s0P\x1B(s16.6H\x1B(s8.5V"
#define LJCourier "\x1B(s3T\x1B(10U\x1B(s0P\x1B(s10H\x1B(s0B\x1B(s12V"
#define LJCourierBold "\x1B(s3T\x1B(10U\x1B(s0P\x1B(s10H\x1B(s3B\x1B(s12V"
#define LJHelvetica "\x1B(s4T\x1B(0U\x1B(s1P\x1B(s3B\x1B(s14.4V"
#define LJUnderLineOn "\x1B&dD"
#define LJUnderLineOff "\x1B&d@"
#define LJReset "\x1B\E"

	//  predefined Epson LX-800 codes:
#define EpsonPica "\x1B!\x00"
#define EpsonElite "\x1B!\x01"
#define EpsonCompressed "\x1B!\x04"
#define EpsonDoubleWidth "\x1B! "
#define EpsonBold "\x1B!\b"
#define EpsonItalics "\x1B!@"
#define EpsonUnderLine "\x1B!"
#define EpsonReset "\x1B@"

	//  predefined OkiData 190/2410 codes:
#define OkiDataPica "\x1B:"
#define OkiDataElite '\x12'
#define OkiDataCompressed '\x0F'
#define OkiDataDoubleWidthOn "\x1BW1"
#define OkiDataDoubleWidthOff "\x1BW0"
#define OkiDataBoldOn "\x1BG"
#define OkiDataBoldOff "\x1BH"
#define OkiDataUnderlineOn "\x1B-\x01"
#define OkiDataUnderLineOff "\x1B-\x00"
#define OkiDataReset '\x18'

	//  predefined IBM Pro Printer II codes:
#define ProPrinterPica '\x12'
#define ProPrinterNormal ""    //  Should this be #18 !! ?? !!
#define ProPrinterCompressed '\x0F'
#define ProPrinterDoubleWidth '\x0E'
#define ProPrinterBoldOn "\x1B\E"
#define ProPrinterBoldOff "\x1B\F"
#define ProPrinterReset "\x1B[K\x01\x00\x04"
#define ProPrinterDraftMode "\x1BI\x00"

	//  predefined Toshiba P351SX codes:
#define  ToshibaElite "\x1B\x1F\f"
#define  ToshibaPica "\x1B\x1F\n"
#define  ToshibaCompressedOn "\x1B["
#define  ToshibaCompressedOff "\x1B]"
#define  ToshibaDoubleWidth "\x1B!"
#define  ToshibaBoldOn "\x1BK"
#define  ToshibaBoldOff "\x1BM"
#define  ToshibaItalicsOn "\x1B\x12"
#define  ToshibaItalicsOff "\x1B\x14"
#define  ToshibaUnderLineOn "\x1BI"
#define  ToshibaUnderLineOff "\x1BJ"
#define  ToshibaReset "\x1B\rP"

	//  predefined Citizen 120-D codes:
#define  CitizenElite "\x1BM"
#define  CitizenPica "\x1BP"
#define  CitizenCompressed '\x0F'
#define  CitizenBoldOn "\x1BG"
#define  CitizenBoldOff "\x1BH"
#define  CitizenReverseOn "\x1B~1"
#define  CitizenReverseOff "\x1B~0"
#define  CitizenUnderlineOn "\x1B-\x01"
#define  CitizenUnderLineOff "\x1B-\x00"
#define  CitizenReset "\x1B@"

	//  predefined Panasonic KX-P1180 codes:
#define  PanasonicPica "\x1BP"
#define  PanasonicElite "\x1BM"
#define  PanasonicCompressedOn '\x0F'
#define  PanasonicCompressedOff '\x12'
#define  PanasonicBoldOn "\x1BG"
#define  PanasonicBoldOff "\x1BH"
#define  PanasonicDoubleWidthOn "\x1BW\x01"
#define  PanasonicDoubleWidthOff "\x1BW\x00"
#define  PanasonicUnderLineOn "\x1B-\x01"
#define  PanasonicUnderLineOff "\x1B-\x00"

#ifdef __cplusplus
}
#endif

#endif //_TZPRINT
