/* filename: TIMEDATE.H

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef _TZTMDATE
#define _TZTMDATE
#define TZTMDATE

#ifdef TOPAZINI
#error You should put init.h as the last header file in your MAIN file.
#endif

#ifndef _TZCOMMON
#include <common.h>
#endif

#define TZSAYGET

#ifdef __cplusplus
extern "C" {
#endif

typedef enum { Hours,Minutes,Seconds,Ticks } TimeUnits;
typedef struct Datetype {
  int Yr;
  int Mo;
  int Dy;
} Datetype;

// "Transition" is the first Julian date to be considered as
// belonging to the Gregorian calendar.  Usual values are:
// 2299161 = October 5/15, 1582 as in Rome, or
// 2361222 = September 3/14, 1752 as in the United Kingdom and the Colonies

#define Transition 2299161L //October 5/15, 1582 as in Rome
#define TicksPerSecond 18.20648193 // 1193180 (cycles per second) / 65536 (cycles per tick)

// Possible values of TimeError:
                         //   0 = operation successful
#define NoColon 239      // missing colon   e.g. '01:0203'
#define BadChar 240      // non numeric character e.g. '01:X2:03'
#define InvalidTime 241  // invalid time    e.g. '44:72:61'
#define NegativeTime 242 // Negative time   e.g. -600.1 hours
#define DifferenceNegative 243 // Time Difference is negative
#define OutOfRange 212   // Range Error

extern unsigned char (*UsersAttrProc)(char *);
void ZeroPad(char *s);

//  time routines
char *AM_PM(char *t);
double InHours(char *t);
double InMinutes(char *t);
double InSeconds(char *t);
double InTicks(char *t);
void  ParseTime(char *t);
char *SystemTime(void);
char *Time(double x, TimeUnits units);
char *TimeDiff(char *t2, char *t1);
char *TimePlus(char *t2, char *t1);

//  date routines
#define LeapYear(x) (((x)%400 == 0) || (((x)%4 == 0) && ((x)%100 != 0)))
#define DaysInYear(mdate)  (365 + IsLeapYear(mdate))

char *AnsiDate(const char *date);
char *CDOW(const char *mdate);
char *CDay(const char *mdate);
char *CMonth(const char *mdate);
char *CtoD(const char *mdate);
char *CYear(const char *mdate);
long  DateDiff(const char *date1, const char *date2);
char *DateFrom(int year, int month, int day);
char *DateFromJulian(long date);
char *DatePlus(const char *date, int n);
void  DateToYMD(char *date, Datetype *daterec);
void  DateTypeFromJulian(long J, Datetype *daterec);
int   Day(const char *mdate);
int   DayOfYear(const char *mdate);
int   DaysInMonth(const char *mdate);
int   DOW(const char *mdate);
char *DtoC(const char *mdate);
char *FullDate(const char *mdate);
BOOL  IsLeapYear(const char *mdate);
long  JulianFromDateType(Datetype *daterec);
long  JulianFromDate(const char *date);
char *LetterDate(const char *mdate);
int   Month(const char *mdate);
void  ParseClauses(char *x);
char *SystemDate(void);
BOOL  ValidDate(const char *mdate); // checks for bad dates
int   Year(const char *mdate);

#ifndef WINDOWS
//  calendar routines
void  DisplayCalendar(char *d);
void  DisplayCalendarData(char *d, int plain);
void  GetColors(void);
void  PaintFullDate(const char *d, int plain);
void  PaintDayOfYear(const char *d);
void  PaintDaysOfWeekLetters(void);
void  SetCalendarTo(int c, int r, unsigned char fg, unsigned char bg,
         int LineStyle, const char *heading);
char *SelectDate(const char *d); // d may contain the date and optional clauses
void  SetCalendarAttrTo(unsigned char (*)(char *));
void  SyncTime(void);
#endif

extern int  hour, minute, second;
extern int TimeError;
extern int PopDown, FreezeDay, FreezeWeek, FreezeMonth, FreezeYear;
extern unsigned      ScreenPos;
//  default calendar position
extern int  OrigX, OrigY;
//  default calendar colors
extern unsigned char CalendarHighlightFG, CalendarHighLightBG;
extern int  CalendarLineStyle;
extern char _tzfar CalendarHeading[31];

void  TZSayGetInit(void);

#ifdef __cplusplus
}
#endif

#endif // _TZTMDATE
