/* filename: SPOOLER.H

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef _TZSPOOLR
#define _TZSPOOLR
#define TZSPOOLR

#ifdef TOPAZINI
#error You should put init.h as the last header file in your MAIN file.
#endif

#ifndef TZCOMMON
#include <common.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define MaxBufferSize     0xFFF0
#define TimerInterrupt    0x1C
#define PrinterInterrupt  0x17
#define DefaultBufferSize 0x2000
#define MaxPorts          2

// this can be very small -- the spooler does the buffering
#define ComBufferSize     8

// offset from base of UART Registers for IBM PC
#define UART_THR  0x00
#define UART_RBR  0x00
#define UART_IER  0x01
#define UART_IIR  0x02
#define UART_LCR  0x03
#define UART_MCR  0x04
#define UART_LSR  0x05
#define UART_MSR  0x06

#define I8088_IMR 0x21 // port address of the Interrupt Mask Register

#define MaxBaud   8

void SetPrinterTo(char *Mode);
// sets the printer port to  LPT 1..3, or COM 1..2 using the DOS Mode command
// Syntax. Sets the SpoolError byte if the command is invalid or no device
// exists. Cancels spooler if active

char *SpoolErrorMsg(void); // returns text string message explaining error
void ListSpoolData(void); // display values of various configuration parameters

void SetPacketSizeTo(unsigned char Size);
// set the number of characters to send each timer tick. Defaults to 32 for
// parallel ports, but should be smaller for serial ports with baud rates
// less than 9600. E.g., 1200 baud requires a packet size of 6 or less
// Cancels spooler if active. Minimum size is 1

void SetSpoolerSize(unsigned int NewBufSize); // in bytes
// Maximum buffer size = 64k less 16 bytes (0xFFF0), default = 8k
// Clears spooler buffer if active

void StartSpooling(void); // turns the spooler on
void StopSpooling(void); // turns the spooler off - until the next call to StartSpooling
void CancelSpooling(void); // empties the spooler buffer

void SpoolArray(void *buffer, unsigned int Size);
// appends the spooler's buffer with 'size' number of chars starting at
// 'pointer' location. This is a fast way to put data into the spooler
// if you already have what you want in memory.
// Otherwise, using printf(prn,...) will append to the spooler.

unsigned int CharsInSpooler(void);
// Returns the number of characters left in the spool buffer.  Used by
// the exit procedure to wait until the spooler is finished before program
// exit.

unsigned char RealPrinterStatus(void);
// Returns the printer status byte, regardless of whether the spooler is
// installed or not

void SetSpoolerOn(void);
// Turns spooler on with the output set to the most recently specified
// printer as set with SetPrinterTo(). Default = LPT1

void SetSpoolerOff(void);
// Turns off spooler and throws away any data still in the spooler buffer.

BOOL SpoolerReady(void);
// Returns true if the spooler is installed and there is room in the spooler
// buffer for a full size string to be printed.

extern unsigned char SpoolError;

// SpoolError Values:
// 244 : Printer number not specified for spooler
// 245 : Printer/device number out of range
// 246 : Specified printer port does not exist
// 247 : Incorrect/insufficient parameters specified
// 248 : Specified baud rate not supported
// 249 : Invalid parity value specified for serial printer
// 250 : Invalid word length specified for serial printer
// 251 : Invalid stop-bits value specified for serial printer
// 252 : Unable to initialize COM port for print spooling
// 253 : Not enough memory for spooler buffer
// 254 : Spooler buffer overflow

typedef struct {
  int Enabled;
  char  *buffer;
  unsigned Tail;
} SpoolerRecord;

extern unsigned int SpoolerBufSize;
extern SpoolerRecord SpoolRec;
extern unsigned char SpoolerPacketSize;
extern char _tzfar BaudRate[5];
extern char Parity, WordLength, StopBits;
extern unsigned char DelayTime;
extern int ComBase; //  base for current open port
extern unsigned StatusPort;
extern unsigned char PortNumber;
extern int SpoolerInstalled, Parallel;

#ifdef __cplusplus
}
#endif

#endif
