/* filename: SAYGET.H

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef _TZSAYGET
#define _TZSAYGET
#define TZSAYGET

#ifdef TOPAZINI
#error You should put init.h as the last header file in your MAIN file.
#endif
#ifndef _TZCOMMON
#include <common.h>
#endif

#ifndef __IO_H
#include <io.h>
#endif
#ifndef _REG_DEFS // only for Borland C
#include <dos.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define MaxGets 128 //  Maximum number of "GETS" allowed per ReadGets

//  identifiers for date formats and country code
#define American 0
#define USA  0
#define Ansi 1
#define British 2
#define Britain 2
#define Italian 3
#define Italy 3
#define French 4
#define France 4
#define German 5
#define Germany 5
#define Spanish 6
#define Spain 6
#define FrenchCanadian 7
#define Quebec 7
#define Russia 8
#define Russian 8

//  global function key constants for use with Set_FKey()

//  F1..F10
#define F1   ';' // Ascii 59
#define F2   '<'
#define F3   '='
#define F4   '>'
#define F5   '?'
#define F6   '@'
#define F7   'A'
#define F8   'B'
#define F9   'C'
#define F10  'D'

//  Shift-F1..Shift-F10
#define SF1  'T'
#define SF2  'U'
#define SF3  'V'
#define SF4  'W'
#define SF5  'X'
#define SF6  'Y'
#define SF7  'Z'
#define SF8  '['
#define SF9  92
#define SF10 ']'

//  Ctrl-F1..Ctrl-F10
#define CF1  '^'
#define CF2  '_'
#define CF3  '`'
#define CF4  'a'
#define CF5  'b'
#define CF6  'c'
#define CF7  'd'
#define CF8  'e'
#define CF9  'f'
#define CF10 'g'

//  Alt-F1..Alt-F10
#define AF1  'h'
#define AF2  'i'
#define AF3  'j'
#define AF4  'k'
#define AF5  'l'
#define AF6  'm'
#define AF7  'n'
#define AF8  'o'
#define AF9  'p'
#define AF10 'q'  // Ascii 113

#define Control_A      '\x01'
#define Control_Rarrow '\x02'
#define Control_C      '\x03'
#define RightArrow     '\x04'
#define UpArrow        '\x05'
#define Control_F      '\x06'
#define Bell           '\x07'
#define Control_G      '\x07'
#define BackSpace      '\x08'
#define Control_I      '\x09'
#define LineFeed       '\x0A'
#define HomeKey        '\x0B'
#define Control_Home   '\x0C'
#define CarriageReturn '\x0D'
#define PgDn           '\x0E'
#define EndKey         '\x0F'
#define PgUp           '\x1D'
#define Control_P      '\x10'
#define Control_Q      '\x11'
#define Control_R      '\x12'
#define LeftArrow      '\x13'
#define Control_T      '\x14'
#define Control_U      '\x15'
#define Control_V      '\x16'
#define Control_End    '\x17'
#define Control_W      '\x17'
#define DownArrow      '\x18'
#define Control_Y      '\x19'
#define Control_Larrow '\x1A'
#define Control_PgUp   '\x1F' // ^_  (^underbar)
#define Control_PgDn   '\x1E' // ^^  (^caret)
#define EscapeCh       '\x1B'

//  line style constants for the Box() procedure

#define FuzzyDate 64
#define MaxNestingLevel 6
#define MaxNestingLevelPlus 7
#define ROW 1
#define COL 2
#define TEXT_ATTR 3

#ifndef TZPRINT
union MYREGS {
   struct  REGPACK  x;
   struct  BYTEREGS  h;
};
#endif

typedef enum { DBASE, TOPAZ } Language;
typedef enum { ALWAYS,NEVER,CONTEXT } ExplodeModeType;
typedef enum { _UNDEFINEDTYPE,
  _SC,_UC,_A,     // signed char, unsigned char,ASCIIZ
  _F,_DF,_LD,_SH, // float,double float, long double, short
  _I,_US,_UI,_LI,_UL,//int, unsigned short, unsigned int, long
  _L,_D,_T,_S,_M, // logical, date, time, string, memo
  _STATIC, _PASSWORD
} VarTypes;

#ifndef WINDOWS
typedef struct SGFieldRecord {  // edit-field definition record
  char *prompt, *PictureString;
  unsigned int  picsize; // this needs to be as large as 256
  char PictureFunction;
  unsigned char   say_color, get_color, row, column, LeftColumn;
  unsigned int  varofs, varseg, RightColumn; // some fields may wrap
  char decimals;
  char LeftSymbol, RightSymbol;
  int DisplayOnly, RequiredInput, RangeChecking, selfdestruct;
  char LowerLimit[15], UpperLimit[15];
  VarTypes vartype;
  void (*AutoHelpProc)(void);
  void (*ValidationProc)(void);
  int  Validated;
  unsigned char   FieldCode, Width; // the one defined by user in sayget statement
} SGFieldRecord;

typedef struct ColorsRecord {
  unsigned char Say;
  unsigned char Get;
  unsigned char HL; // highlight color
  unsigned char TurboColors;
  struct ColorsRecord * PriorColors;
} ColorsRecord;
typedef struct ColorsRecord *ColorsPtr;  // for PushColors/PopColors

typedef SGFieldRecord *GetTableType[MaxGets];

extern char *SGBuffer;  // points to current field buffer
extern unsigned char SGFieldCode;// contains code from current field
extern int SGFieldOK;  // used to indicate field contents are valid
extern int SGRepaint;  // if true after validation, autohelp,
					   // or Fkey calls then all the gets on the
					   //	screen will be repainted
extern unsigned char SGNextField;// allows user to specify which field is next
extern int ExitRead;   // AutoHelp, FKey, and Validation routines can
// instruct ReadGets to exit entire read
extern int ExitField;   // AutoHelp and FKEY procedures can set this
extern unsigned int BaseOfScreen;  //  Base address of video memory

//  hidden globals
extern unsigned char	TableSize[MaxNestingLevelPlus];
extern int  SGwhich; // 0..6
extern GetTableType _tzfar GetTable[MaxNestingLevelPlus];
extern void *SGBufSave[MaxNestingLevelPlus];
extern void		(*JumpTable[113-58])(void);  //	function key procedure pointers
extern unsigned int 	savedcursor, originalcursor;
extern int  DesqView;  // is DesqView present
#endif

//  default values

extern char _tzfar WatchKeys[STRSIZ];
extern char _tzfar UserSet[STRSIZ]; //  available for user definition
extern char UserSymbol;
extern int 	Confirm;   //  False = OFF
extern int 	AsciiOnly;

extern char *AlphaSet;
extern char *NumberSet;
extern char *PictureSet;
extern char *BooleanSet;
extern char *TrueSet;
extern char *FalseSet;
extern char UserChar;   //  char to access user set (can be any char)
extern char EditResult;   //  contains status of edit upon exit

#ifndef WINDOWS
extern unsigned char ExplodeRate;
extern ExplodeModeType ExplodeMode;
extern int ClearBoxes;
extern int SpreadSheetMode;  // if true then prevents use of arrow keys to exit fields
extern int InsertMode;
extern char LeftDelimiter;
extern char RightDelimiter;
extern unsigned char SGFieldIndex;
extern int ForceValidation;
extern int CursorOn;
extern unsigned int OverwriteCursor, InsertCursor;

// sayget constants

extern VarTypes _tzfar CurrentFieldType;
extern ColorsPtr     ColorStackPtr;   //  for Push/Pop colors
extern unsigned char SayColor;   //  lightgray on black (normal video)
extern unsigned char GetColor;   //  black on white (reverse video)
extern int		BellPitch;   //  Hertz
extern int		BellCount;   //  rings per call, default = 0
extern int		BellDuration;   //  milliseconds
extern int		Scoreboard;
extern unsigned TimeOut;
extern int		FieldChanged;

#endif
// SayGet external funcs

#define IIF(condition, iftrue, iffalse) ((condition)?(iftrue):(iffalse))
#define SBoolean(x) (BooleanSaySet[(int)(x)])
#define SetCenturyOff() (CenturyOn = FALSE)
#define SetCenturyOn()  (CenturyOn = TRUE)
#define SetConfirmOn() (Confirm = TRUE) //  requires carriage return to exit field
#define SetConfirmOff() (Confirm = FALSE)
#define SetAsciiOn() (AsciiOnly = TRUE) //  allows only chars between 32 and 127
#define SetAsciiOff() (AsciiOnly = FALSE) //  allows any ascii char in field
#define SetEscapeOn() (EscapeEnabled = TRUE) //  allows exit by pressing Esc
#define SetEscapeOff() (EscapeEnabled = FALSE)
#define SetRepaintOn() (Repaint = TRUE)
#define SetRepaintOff() (Repaint = FALSE)

#ifndef WINDOWS

#define Wrow(row) (row + GetWinfo(ROW))   //  corrects for turbo windows
#define Wcol(col) (col + GetWinfo(COL))   //  corrects for turbo windows
#define SetDelimitersTo(char1, char2) LeftDelimiter = (char1);RightDelimiter = (char2)
#define SetHighlightTo(fgd, bgd) (SelectedColor = (unsigned char)((fgd) + (16 * (bgd))))
#define SetScoreboardOn() (Scoreboard = TRUE)
#define SetScoreboardOff() (Scoreboard = FALSE)
#define SetTimeoutTo(SecondsToWait) (TimeOut = SecondsToWait)

void  At(int col, int row, const char * message);
void  BlankField(void);
void  Box(int c1, int r1, int c2, int r2, char linestyle, const char * header);
void  CheckForDesqView(void);
void  ClearEOL(int col, int row);
void  ClearGets(void);
void  Convert(int * col, int * row);
void  CurrentColors(unsigned char * sf, unsigned char * sb,
			unsigned char * gf, unsigned char * gb);
void *CurrentFKey(char key);
int   CursorVisible(void);
void  DecrementWhich(void);
int   GetWinfo(int flag);
void  IncrementWhich(void);
void  LowLevelBox(int c1, int r1, int c2, int r2,
				 char linestyle, const char * header);
void  NoEdit(void);
void  Paint(int col, int row, char width,
		   unsigned char fgd, unsigned char bgd);
void  PaintField(int field, int get, int selected);  //  internal use
void  Picture(const char * pic);
void  PopColors(void);
void  PushColors(void);
void  Range(char * lower, char * upper);
void  ReadGets(void);
void  Required(void);
void  RestoreCursor(unsigned int cursorvar);
void  RingBell(void);
void  SaveCursor(unsigned int * cursorvar);
void  SayGet(int x, int y, const char * say, void * get, VarTypes gettype,
			 unsigned char Len, signed char pDecimals);
void  SayGetExitProc(void);
unsigned char ScreenWidth(void);
void  SetAutoHelpTo(void (*help_procedure)(void));
void  SetBellTo(unsigned int freq, unsigned int count,
				 unsigned int duration);
void  SetCursorOff(void);  //  works with the EGA
void  SetCursorOn(void);
void  SetCursorSize(unsigned int normal, unsigned int insert);
void  SetColorTo(unsigned char sayfg, unsigned char saybg,
			unsigned char getfg, unsigned char getbg);
void  SetCoordinatesTo(Language);
void  OnDoubleClick(void (*UDF)(void));// former SetDoubleClickTo
void  SetFieldCodeTo(unsigned char code);
void  SetFKey(char Key, void(*proc)(void));
void  SetScoreboardTo(char row);
void  SetValidateTo(void(*ProcPointer)(void));
BOOL  SGFieldEdited(void);
VarTypes SGFieldType(void);
void  TellDesqViewAboutChange(void);
unsigned int  VideoSegment(void);
unsigned char VideoMode(void); // returns current video mode
void   Wait(const char * waitstring);
void   WaitTo(const char * waitstring, char * key);

#endif // Not Windows

char *Commas(void *, VarTypes, int, int);
void  Convert2American(char * date);
void  ConvertFromAmerican(char * date);
int   CountOf(const char * c, const char * s);
BOOL  IsAlpha(const char * s);
BOOL  IsUpper(const char * s);
BOOL  IsLower(const char * s);
int   IntegerVal(char * number_str);
long  LongVal(char * number_str);
int   Lowcase(int ch);  //  replaces standard function
char *Lower(const char * s); //  returns lowercase COPY of string //
void  LowerString(char * s);
char *LPad(const char *, int);
char *Pad(const char *, int);
int   PosOf(int n, const char * c, const char * s);
BOOL  PrinterReady(char lpt);
double RealVal(char * real_str);
char *Replicate(char character, int times);
void  SetCountryTo(char the_country);
void  SetDate(char dFormat);
char *SInteger(long i, unsigned char l);
char *Space(int      x);
char *SReal(long double r, unsigned char l, unsigned char d);
void  TZSayGetInit(void);
char *Upper(const char * s); //  returns uppercase COPY of string
int   UpCase(int ch);  //  replaces standard function
void  UpperCase(char * s);
void  UpperString(char * s);

#ifdef __cplusplus
}
#endif

#endif //_TZSAYGET
