/* filename: REPORT.H

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef _TZREPORT
#define _TZREPORT
#define TZREPORT
#define TZSAYGET

#ifdef TOPAZINI
#error You should put init.h as the last header file in your MAIN file.
#endif

#ifndef __SETJMP_H
#include <setjmp.h>
#endif

#ifndef TZCOMMON
#include <common.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

// Report form file structure types:
typedef struct FileHeaderType {
  char  Signature[16];
  long  FirstByteOfData;
  unsigned char NumberOfFields;
  char  DBFName[13]; // not implemented yet
  char  Spare[80];
} FileHeaderType;

typedef struct ReportColumnType {
  unsigned char N; // field number
  char  Name[11];
  char  Heading[133];
  char  PrePrinterCode[81];
  char  PostPrinterCode[81];
  unsigned char Width;
  unsigned char DecimalPlaces;
  char  Commas;
  char  BlankZeros;
  unsigned char Tab;
  int   StartingColumn;
  char  NameTail[78]; // this is the other half of Name in case if it begins
                      // with '@' this is added to support dBase expressions 
  char  TotalThisColumn;
} ReportColumnType;

typedef struct OverrideRPTTemplate {
  unsigned char PageWidth;
  unsigned char LeftMargin;
  unsigned char RightMargin;
  unsigned char TopMargin;
  unsigned char BottomMargin;
  unsigned char LinesPerPage;
  int   OverrideBooleans;
  char  DoubleSpace;
  char  EjectBefore;
  char  EjectAfter;
} OverrideRPTTemplate;

typedef struct ReportTemplateType {
  // global info
  char Title[STRSIZ];
  char PreTitlePrinterCode[STRSIZ];
  char PostTitlePrinterCode[STRSIZ];
  unsigned char PageWidth;
  unsigned char LeftMargin;
  unsigned char RightMargin;
  unsigned char TopMargin;
  unsigned char BottomMargin;
  unsigned char LinesPerPage;
  char  DoubleSpace;
  char  EjectBefore;
  char  EjectAfter;
  char  PlainPage;
  unsigned char RepMaxOrder;
  char  RevealCodes;
  char  UnderlineChar;
  char  Spare[19];
  // group info
  char GroupField[11];
  char GroupHeading[STRSIZ];
  char SummaryReportOnly;
  char PageEjectAfterGroup;
  char SubGroupField[11];
  char SubGroupHeading[STRSIZ];
  // column info
  ReportColumnType * FieldMap[255]; // [MaxFieldCount]
} ReportTemplateType;

void  ReportForm(const char * filename);
void  SetGroupTo(char *(*Func)(void));
void  SetPageHeadingTo(char *(*Func)(void));
void  SetReportColumnTo(char *(*Func)(void));
void  SetReportFormfeedTo(int (*Func)(void));
void  SetReportSeparatorTo(char *(*Func)(void));
void  SetSubgroupTo(char *(*Func)(void));

char *HeadingPart(const char * x, int width, int n);
char *PrinterCode(char * x );
void  ReportCheckPrinterStatus(void);
char *UserDivider(void);
int   UserEject(void);

extern char *(*GroupHeadingPtr)(void);
extern char *(*PageHeadingPtr)(void);
extern char *(*SubGroupHeadingPtr)(void);
extern char *(*UsersColumnFunc)(void);
extern char *(*UsersDividerFunc)(void);
extern int  (*UsersFormFeedFunc)(void);

extern int BlinkMessage;
extern int ConnectFlag;
extern int LineNumber;
extern int PrinterCodeFlag;
extern int ReportResult; // 0=normal, 1=user pressed escape

extern char *LM;
extern char *RepPCbuf;
extern char ReportColumnString[90]; // should be big enough for Name + NameTail
extern char *UserHeading;

extern unsigned int  PageNumber;
extern unsigned char WhereXMessage, WhereYMessage;
extern unsigned char ReportColumnWidth;

extern OverrideRPTTemplate _tzfar OverrideRPT;

#ifndef __cplusplus // MS C++ undefines jmp_buf
extern jmp_buf ReportJmp;
#endif
extern ReportTemplateType *RepTempl; // globals

#ifdef __cplusplus
}
#endif

#endif // _TZREPORT
