/* filename: RCCOMP.H

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef _RCCOMP_H
#define _RCCOMP_H

#define MAX_AVAIL_COLS  80  // you may use 132 columns
#define RETSIZ          33  // identificator length

typedef struct menuItemVars {
  BOOL  Selected;       // currently highlighted?
  BOOL  Enabled;        // is the item enabled, or grayed out?
  BOOL  Checked;        // put a check mark next to the item?
  int   HotKeyOfs;      // offset to the character in the name that is the
                        // trigger key..if no hotkey then HotKeyOfs = -1
  int   UserID;         // what the menu system returns when a choice is made
  int   AcceleratorKey; // what accelerator key is associated with this item
} menuItemVars;
// Next is Data area for all the strings:
// Name, Help, CustomString, IDString, etc.

// returrns key stroke or mouse event
// key strokes are bit-coded:
// <Functional><Shift><Ctrl><Alt> | key & 0xFF...

typedef struct {
  unsigned  key        : 8;
  unsigned  alt        : 1;
  unsigned  ctrl       : 1;
  unsigned  shift      : 1;
  unsigned  functional : 1;
  unsigned             : 4; // spare bits, unused
} bits;

typedef struct accelPage {
  union {
    int  e;
    bits b;
  } Event;
  int IDM;
  int Noinvert;
} accelPage;

typedef struct ItemPage {
  int  StrSize; // String size for Name+Help+CustomString+IDString, etc.
  int  HelpOffset;
  int  IDStringOffset;
  int  CustomStringOffset;
  int  NameOffset;
  char Hotkey;
  menuItemVars iv;
} ItemPage;

typedef enum { Eot, MenuBreak, Item, Group, Begin, End } PageTypeType;
typedef enum { NoneTable = 0, MenuTable, AcceleratorTable } TableType;

typedef struct PageType {
  PageTypeType type;
  int ID;  // for internal ID number
} PageType;

typedef struct Table {
  TableType Type;               // MENU or ACCELERATOR
  char      Name[RETSIZ];       // Table name
  int       ItemsNo;
  long      PrevTableOffset;
  long      ThisTableOffset;
  long      NextTableOffset;
} Table;

typedef struct {
  int  ID;
  char String[RETSIZ];
} IdLinkType;

#endif // _RCCOMP_H
