/* filename: MOUSE.H

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef WINDOWS

#ifndef _TZMOUSE
#define _TZMOUSE

#ifndef TZCOMMON
#include <common.h>
#endif

#define LeftButtonDown       2  // used to construct bit masks
#define LeftButtonReleased   4
#define RightButtonDown      8
#define RightButtonReleased  16
#define CenterButtonDown     32
#define CenterButtonReleased 64

#define ReservedID    -32767
#define ForceRepaint  -16383 // forces to repaint SayGet buffer

#ifdef __cplusplus
extern "C" {
#endif

typedef enum { Keyboard, Mouse } EventType;
typedef struct EventRec {
  EventType WhichEvent; // Selector
  union {
    struct {
      unsigned char ScanCode;
      char Key;
    } sKeyboard;
    struct {
      unsigned char X, Y;
      unsigned char WindX, WindY;
      unsigned char ButtonMask;
      int TargetID;
      int DoubleClick;
      unsigned char KeyStates;
    } sMouse;
  } v;
} EventRec;

extern EventRec Event;

typedef struct TargetListRecord {
  unsigned char x1, y1, x2;
  int y2;
  int IDCode; // negative values = sticky
  unsigned char ButtonMask;
  long int LastReleased;  // bios timer ticks
  struct TargetListRecord * NextPtr;  // size to here = one paragraph
} TargetListRecord;

typedef struct TargetListRecord *TargetListPtr;

typedef struct MouseState {
  int MouseEnabled;
  TargetListPtr TargetHead;
  void (_far * Handler)(void);
  void (_far * EventHook)(void);
  unsigned char Mask;
  struct MouseState * NextPtr;
  unsigned char  x, y;
} MouseState;

typedef struct MouseState * MouseStatePtr;
typedef enum { Arrow,Block,Character } PointerStyleType;
typedef enum { Normal,Reversed,Fixed } AttrStyleType;

// mouse variables
extern int  TopazMouseEnabled;
extern int  MouseDriverPresent;
extern int  MouseIsVisible;
extern int  AutoMousePlacement;
extern int  LeftHandedMouse;
extern int  DeltaX, DeltaY;
extern int  MouseEnabled;
extern void (*MouseUDFPtr)(void);
extern void (*MouseEventHook)(void);
extern int  LeftButtonWasDown;
extern int  RightButtonWasDown;
extern int  CenterButtonWasDown;

extern unsigned char SaveMouseX;
extern unsigned int  PreviousEventMask;
extern void (_far *  PreviousHandler)(void);
extern unsigned char SaveMouseY;
extern MouseStatePtr MouseStackPtr;
extern TargetListPtr MouseTargetList;
extern unsigned char MaxMouseButtons;
extern unsigned int  DoubleClickThreshold;

// mouse related functions
unsigned char GetMouseButtonStatus(void);
unsigned char MouseX(void);
unsigned char MouseY(void);
void _far     MouseCallBack(void);

void  AddTarget(int x1, int y1, int x2, int y2,
        int IDCode, unsigned char ButtonMask);
void  CallBackFollowUp( void );
void  DisableMouse(void);
void  EnableMouse(void);
void  GetMouseXY(unsigned char * x, unsigned char * y);
void  HideMouse(void);
BOOL  IsCenterButtonDown(void);
BOOL  IsLeftButtonDown(void);
BOOL  IsRightButtonDown(void);
BOOL  MouseMotion(void);
void  OnMouse(void (*Mouse)(void));
void  PushMouse(void);
void  PopMouse(void);
void  ResetMouse(void);
void  SetMouseHandlerTo(void (_far *p)(void));
void  SetMousePointerTo(int PtrStyle, unsigned char CharNo,
        int AttrStyle,unsigned char AttrFG, unsigned char AttrBG);
void  SetMouseWindowTo(int x1, int y1, int x2, int y2);
void  SetMouseXY(unsigned char x, unsigned char y);
void  ShiftMouseTargets(int xshift, int yshift);
void  ShowMouse(void);
void  ShowMousePointer( int on );
void  SwapButtons(unsigned int * bx);
void  TextMode(unsigned int m);

void  ClrScr(void);
int   EventPending(void); // in place of KeyPressed
void  GetEvent(EventRec * e); // in place of ReadKey

#ifdef __cplusplus
}
#endif

#endif // _TZMOUSE

#endif // Not WINDOWS
