#include "install.h"

char sourcedir[PATHLEN];
char destdir[PATHLEN];
int  useBCSU;
int  useBCMU;
int  useMSCSU;
int  useMSCMU;
int  RTL;
int  Util;
int  MakeCode;
int  Examples;
int  Doc;
////////////////////////////////////////
//            Descriptions
////////////////////////////////////////
char srcpathhlp[]  = "Enter the path to the directory containing the TOPAZ for C/C++ files.     ;;";
char srcdrivehlp[] = "Enter the drive from which you wish the INSTALL utility to copy files.;"
                     "Typically, this is the drive that contains the INSTALL disk.          ;";
char mmenuhlp1[]   = "Selecting this option will allow you to change directories where the  ;"
                     "TOPAZ for C/C++ files are to be copied. By default the files are      ;"
                     "copied to default directories.                                        ;";
char mmenuhlp2[]   = "This option allows you to choose the library for Microsoft C++ 7.0 or ;"
                     "Borland C++ 3.x, the appropriate path etc.                            ;";
char mmenuhlp3[]   = "Install option helps to choose the additional components of the Topaz ;"
                     "toolkit - the documentation, the examples, MAKECODE utility etc.      ;";
char mmenuhlp4[]   = "Selecting this option will start copying files to your hard drive into;"
                     "the directory specified above.                                        ;";
char lmenuhlp1[]   = "Choose <Yes>, if you want to install this library of the Topaz toolkit;";
char lmenuhlp2[]   = "If <Yes>, the Topaz source code is copied. It takes approximately 2 Mb;"
                     "of the hard disk space.                                               ;";
char omenuhlp[]    = "Choose <Yes> if you want to copy this component of the Topaz toolkit  ;";
char PathNotFound[]= "Check if the source path you typed in exists.                         ;;";
char PathExistHlp[]= "If you choose <Continue> some files in the existing directory could be;"
                     "overwritten during installation process, choose <Modify> option to    ;"
                     "change the destination path name                                      ";
char far bannermsg[]=";Welcome to the Topaz for C/C++ 4.5 installation program!;"
                     "This program will install Topaz for C/C++ 4.5 on your system. To;"
                     "install every available option you need approx. 7.5 Mb on your  ;"
                     "hard disk.  An additional 1 Mb of disk space is required        ;"
                     "during the installation process. If your hard disk's cluster    ;"
                     "size exceeds 4 K bytes the disk space required will increase    ;"
                     "accordingly.; CENTERTEXT";

char far donemsg[] = "Congratulations !;"
                     "Topaz for C/C++ 4.5 is now installed on your system.;"
                     "All the necessary files have been copied to your;"
                     "hard drive. You will need to have a minimum of;"
                     "20 file handles for TOPAZ applications. Make;"
                     "sure the line:                 ;;"
                     "FILES = 20;;"
                     "is in your CONFIG.SYS file. If you run out of;"
                     "file handles, please refer to the \"File Handle;"
                     "Limitations\" section of your TOPAZ manual.;"
                     "A quick way to create an instant application is to;"
                     "run the MAKECODE code generator. See the \"Getting;"
                     "Started Quickly\" section of the TOPAZ manual for;"
                     "details."
                     " CENTERTEXT";
////////////////////////////////////////
//               Menus
////////////////////////////////////////
static char *mmenu[] = {
   " Directory  [                              ] ",
   " Library                                    ",
   " Install options                            ",
   "",
   " Start installation                          "
};

static char *lmenu[] = {
   " Borland C++ 3.x SingleUser library        [   ] ",
   " Borland C++ 3.x MultiUser library         [   ] ",
   " Microsoft C/C++ 7.00 SingleUser library   [   ] ",
   " Microsoft C/C++ 7.00 MuliUser library     [   ] ",
   " Runtime library source code               [   ] "
};

static char *omenu[] = {
   " Utilities     [   ] ",
   " MakeCode      [   ] ",
   " Examples      [   ] ",
   " Documentation [   ] "
};
////////////////////////////////////////
static unsigned int screenseg;
static BOOL         error = FALSE;
static BOOL         atFirst;
static char         msg[STRSIZ];
static char       **helpptr;
static int          intrscrbuf[3 * 80];
static char        *err_msg[] = {
   "Write protected",   "Unknown unit",
   "Drive not ready",   "Unknown command",
   "Data error (CRC)",  "Bad request",
   "Seek error",        "Unknown media type",
   "Sector not found",  "Printer out of paper",
   "Write fault",       "Read fault",
   "General failure",   "Reserved",
   "Reserved",          "Invalid disk change"
};

static char *YesNo(int c)
{
   return c ? "YES" : "NO ";
}

void paintstatusline(char *msg, unsigned normal, unsigned bold)
{
   int i, n;
   int flag;
   char s[] = " ";

   PushColors();

   if(!normal)
      normal = NORMAL;

   if(!bold)
      bold = BOLD;

   color(normal);
   At(1, 25, Replicate(' ', 80));

   for(i = 0, n = 1, flag = 0; msg[i] && (n <= 80); i++) {
      if(msg[i] == '~') {
         flag ^= 1;
         if(flag)
            color(bold);
         else
            color(normal);
         continue;
      }
      s[0] = msg[i];
      At(n++, 25, s);
   }
   PopColors();
}

static void desktopclose(void)
{
   SetClocksOff();
   textattr(0x7);
   clrscr();
}

void fatalerror(char *fmt, ...)
{
   va_list argptr;

   va_start(argptr, fmt);
   vsprintf(msg, fmt, argptr);
   va_end(argptr);
   error = TRUE;
   exit(-1);
}

static void printerrormsg(void)
{
   if(error) {
      gotoxy(1, 1);
      printf("*Error* - %s\n", msg);
   }
}

static char *insert(char *str, char *substr, int start, int count)
{
   int i;

   for(i = 0; (i < count) && (str[start + i]) && (substr[i]); i++)
      str[start + i] = substr[i];

   return str;
}

/*
intrsavescreen(), intrrestorescreen() and error_win() are used in
the interrupt routines. This function CAN NOT be replaced with Topaz
Push/PopWindow() and DialogBox().
See description for _harderr function in Borland C or Microsoft C
programmers guide.
*/
static void intrsavescreen(int t, int l, int b, int r)
{
   int scroffset;
   int _far *ptr;
   unsigned h, w, i;

   h = b - t + 1;
   w = r - l + 1;

   for(scroffset = (t * 160) + (l << 1), ptr = intrscrbuf, i = 0; i < h; scroffset += 160, ptr += w, i++)
      movedata(screenseg, scroffset, FP_SEG(ptr), FP_OFF(ptr), w << 1);
}

static void intrrestorescreen(int t, int l, int b, int r)
{
   int scroffset;
   unsigned h, w, i;
   int _far *ptr = intrscrbuf;

   h = b - t + 1;
   w = r - l + 1;

   for(scroffset = (t * 160) + (l << 1), i = 0; i < h; scroffset += 160, ptr += w, i++)
      movedata(FP_SEG(ptr), FP_OFF(ptr), screenseg, scroffset, w << 1);
}

static int error_win(char *s, unsigned attr)
{
   unsigned char sf, sb, gf, gb;
   int           c, res;
   int           len = strlen(s) + 4;
   int           col = ((80 - len) >> 1) + 1;
   int           cv = CursorVisible();

   CurrentColors(&sf, &sb, &gf, &gb);
   if(cv)
      SetCursorOff();

   intrsavescreen(11, col - 1, 14, col + len); // From ZERO coord.
   color(attr);
   Box(col, 12, col + len - 1, 14, DoubleLine | Shadow, " Hardware Error ");
   At(col + 2, 13, s);

   while(TRUE) {
      c = toupper(bdos(7, 0, 0) & 0xff);
      switch(c) {
         case 'A':
            res =  _HARDERR_ABORT;
            goto end;

         case 'R':
            res = _HARDERR_RETRY;
            goto end;

         case 'I':
            res = _HARDERR_IGNORE;
            goto end;

         case 'F':
            res = _HARDERR_FAIL;
            goto end;
      }
   }

   end:
   if(cv)
      SetCursorOn();
   intrrestorescreen(11, col - 1, 14, col + len); // From ZERO coord.
   SetColorTo(sf, sb, gf, gb);
   return res;
}

#pragma argsused
static void far handler(unsigned deverr, unsigned errval, unsigned far *devhdr)
{
   static char msg[80];
   int drive;
   int errorno;

   if(deverr & 0x8000) {
      error_win("Device error", ERROR);
      _hardretn(5);
   }
   drive = deverr & 0x00FF;
   errorno = errval & 0x00FF;

   sprintf(msg, "%c: %s!  A)bort, R)etry, I)gnore, F)ail",
   'A' + drive, err_msg[errorno]);

   _hardresume(error_win(msg, ERROR));
}

void desktop(void)
{
   int row;
   char *p;
   char *s = "TOPAZ for C/C++ 4.5 installation program";

   screenseg = VideoSegment();

   SetCursorOff();
   SetConfirmOn();
   SetEscapeOn();
   SpreadSheetMode = TRUE;
   AutoMousePlacement = FALSE;

   _harderr(handler);

   color(DESKTOP);
   p = Replicate('', 80);
   for(row = 1; row < 26; row++)
      At(1, row, p);

   paintstatusline("", 0, 0);

   color(DIALOG);
   At(1, 1, Replicate(' ', 80));
   At(((80 - strlen(s)) >> 1) + 1, 1, s);

   SetClockTo(74, 1);
   SetClockColorTo(BLACK, LIGHTGRAY);
   SetClockFormatTo("HH:MM");
   SetClocksOn();

   atexit(printerrormsg);
   atexit(desktopclose);
}

BOOL getline(int col, int row, unsigned int attr, int bufsize, char *buf, char *pict)
{
   PushColors();
   color(attr);

   SayGet(col, row, "", buf, _S, bufsize, 0);
   Required();

   if(pict != NULL)
      Picture(pict);

   PushMouse();
   ReadGets();
   PopMouse();

   PopColors();

   strcpy(buf, Trim(buf));

   if(LastKey == ESC)
      return FALSE;
   else
      return TRUE;
}

void OpenHelp(char *s)
{
   dialogcolor(HELP);
   SetDialogWindowTo(4, HELPROW, SingleLine | Shadow, " Description ");
   DialogBox(s, StayOn);
}

void CloseHelp(void)
{
   RemoveDialogBox();
}

static BOOL srcdrive(char *path, unsigned int attr)
{
   int key;

   PushColors();
   PushWindow(23, 12, 60, 15);
   savestatusline();
   color(attr);

   *path = (*path) ? *path : 'A';
   *(path + 1) = 0;

   paintstatusline(" ~Esc~ Exit  ~Enter~ Accept source drive letter", 0, 0);
   Box(23, 12, 58, 14, SingleLine | Shadow | Raised, "");
   At(24, 13, " Enter the source drive to use:");
   OpenHelp(srcdrivehlp);

   key = getline(56, 13, attr, 1, path, "@A");

   CloseHelp();
   restorestatusline();
   PopWindow();
   PopColors();

   return key;
}

static BOOL srcpath(char *path, unsigned int attr)
{
   int res = 1;

   *(path + 1) = 0;
   strcat(path, ":\\");
   if((*path != 'A') && (*path != 'B')) {
      PushColors();
      PushWindow(8, 12, 75, 15);
      savestatusline();
      OpenHelp(srcpathhlp);

      paintstatusline(" ~Esc~ Exit  ~Enter~ Accept source path", 0, 0);
      color(attr);

      if(getcurdir(*path - 64, path + 3) == 0) {
         Box(8, 12, 73, 14, SingleLine | Shadow | Raised, " Enter source pathname ");
         res = getline(10, 13, DIALOG, PATHLEN - 3, path + 2, "@!");
      } else
         res = 0;

      CloseHelp();
      restorestatusline();
      PopWindow();
      PopColors();
   }
   addlastBSL(path);

   return res;
}

static BOOL getsourcepath(char *path, unsigned attr)
{
   int res = FALSE, stt = TRUE;

   while(!res) {
      res = srcdrive(path, attr);
      if(!res)
         return FALSE;
      else
         do {
            stt = TRUE;
            if(!(res = srcpath(path, attr)))
               break;

            if((*path != 'A') && (*path != 'B') && (!(stt = exist(path, _DIR_)))) {
               OpenHelp(PathNotFound);
               dialogcolor(ERROR);
               SetDialogWindowTo(255, 255, SingleLine | Shadow, " Error ");
               DialogBox(";  Path not found  ;", ScrollPressAnyKey);
               CloseHelp();
            }
         } while(!stt);
   }
   return TRUE;
}

static int menu(int col, int row, int width, char *mnu[], int menuitems,
                int startitem, unsigned mattr, unsigned sattr, void (*hlpproc)(void))
{
   int i;

   PushColors();

   color(mattr);
   Box(col, row, col + width + 1, row + menuitems + 1, SingleLine | Shadow, "");

   for(i = 0; i < menuitems; i++)
      At(col + 1, row + i + 1, mnu[i]);

   PopColors();

   if(hlpproc)
      SetMenuHelpTo(hlpproc);

   MenuSeed = startitem;

   atFirst = TRUE;

   PushMouse();
   CreateMenu(col + 1, row + 1, col + width, row + menuitems, FORE(sattr), BACK(sattr));
   PopMouse();

   if(hlpproc) {
      SetMenuHelpTo(NULL);
      CloseHelp();
   }

   return MenuChoice;
}

static void menuhelp(void)
{
   if(!atFirst)
      CloseHelp();
   else
      atFirst = FALSE;

   OpenHelp(helpptr[MenuChoice - 1]);
}

static int mainmenu(int topic)
{
   int res;
   char *hlp[] = { mmenuhlp1, mmenuhlp2, mmenuhlp3, mmenuhlp4 };

   helpptr = hlp;

   insert(mmenu[0], destdir, 13, 30);

   res = menu(17, 5, strlen(mmenu[0]), mmenu, 5, topic, DIALOG, SELECT, menuhelp);

   return res;
}

#pragma argsused
static void libmenu(unsigned attr)
{
   int res = 1;
   char *hlp[] = {
      lmenuhlp1, lmenuhlp1, lmenuhlp1, lmenuhlp1, lmenuhlp2
   };

   helpptr = hlp;

   insert(lmenu[0], YesNo(useBCSU),  44, 3);
   insert(lmenu[1], YesNo(useBCMU),  44, 3);
   insert(lmenu[2], YesNo(useMSCSU), 44, 3);
   insert(lmenu[3], YesNo(useMSCMU), 44, 3);
   insert(lmenu[4], YesNo(RTL),      44, 3);

   PushWindow(15, 8, 72, 15);

   while(res) {
      res = menu(15, 8, strlen(lmenu[0]), lmenu, 5, res, DIALOG, SELECT, menuhelp);

      switch(res) {
         case 0:
            break;

         case 1:
            useBCSU ^= YES;
            insert(lmenu[0], YesNo(useBCSU), 44, 3);
            break;

         case 2:
            useBCMU ^= YES;
            insert(lmenu[1], YesNo(useBCMU), 44, 3);
            break;

         case 3:
            useMSCSU ^= YES;
            insert(lmenu[2], YesNo(useMSCSU), 44, 3);
            break;

         case 4:
            useMSCMU ^= YES;
            insert(lmenu[3], YesNo(useMSCMU), 44, 3);
            break;

         case 5:
            RTL ^= YES;
            insert(lmenu[4], YesNo(RTL), 44,  3);
            break;
      }
      if((useBCSU && useMSCSU) || (useBCMU && useMSCMU)) {
         res = -1;
         ErrorMsg("You can not select libraries for both;"
         "Borland and Microsoft as both libraries would be;"
         "installed in the same directory with the same name.;;"
         "After the installation of one library is complete,;"
         "you can then manually rename or copy this library;"
         "and install another one. CENTERTEXT");
      }
   }
   PopWindow();
}

#pragma argsused
static void optmenu(unsigned attr)
{
   int res = 1;
   char *hlp[] = { omenuhlp, omenuhlp, omenuhlp, omenuhlp };

   helpptr = hlp;

   PushWindow(29, 9, 53, 15);

   insert(omenu[0], YesNo(Util),     16, 3);
   insert(omenu[1], YesNo(MakeCode), 16, 3);
   insert(omenu[2], YesNo(Examples),   16, 3);
   insert(omenu[3], YesNo(Doc),      16, 3);

   while(res) {
      res = menu(29, 9, strlen(omenu[0]), omenu, 4, res, DIALOG, SELECT, menuhelp);

      switch(res) {
         case 0:
            break;

         case 1:
            Util ^= YES;
            insert(omenu[0], YesNo(Util), 16, 3);
            break;

         case 2:
            MakeCode ^= YES;
            insert(omenu[1], YesNo(MakeCode), 16, 3);
            break;

         case 3:
            Examples ^= YES;
            insert(omenu[2], YesNo(Examples), 16, 3);
            break;

         case 4:
            Doc ^= YES;
            insert(omenu[3], YesNo(Doc), 16, 3);
            break;
      }
   }
   PopWindow();
}

int setinstalloptions(char drv, unsigned attr)
{
   int res, answer;
   int res1;
   int scrsaved = FALSE;

   PushColors();

   PushWindow(1, HELPROW, 80, HELPROW + 5);
   color(HELP);
   Box(4, HELPROW, 77, HELPROW + 4, SingleLine | Shadow, " Description ");

   savestatusline();
   color(attr);
   paintstatusline(" ~Enter~ Select  ~Esc~ Previous", 0, 0);

   do {
      *sourcedir = drv;
      *(sourcedir + 1) = 0;
      strcpy(destdir, "C:\\TOPAZ");
      useBCSU   = YES;
      useBCMU   = YES;
      useMSCSU  = NO;
      useMSCMU  = NO;
      RTL       = NO;
      Util      = YES;
      MakeCode  = YES;
      Examples  = YES;
      Doc       = YES;
      res1      = 0;

      if(scrsaved)
         PopWindow();

      PushWindow(17, 5, 65, 12);
      scrsaved = TRUE;

      if(*sourcedir > 'B')
         res = getsourcepath(sourcedir, attr);
      else {
         strcat(sourcedir, ":\\");
         res = TRUE;
      }

      if(res) {
         res1 = 1;
         while((res1 != 0) && (res1 != 4)) {
            res1 = mainmenu(res1);
            switch(res1) {
               case 1:
                  OpenHelp(mmenuhlp1);
                  PushWindow(8, 7, 75, 10);

                  Box(8, 7, 73, 9, SingleLine | Shadow | Raised, "");
                  getline(10, 8, attr, PATHLEN - 1, destdir, "@!");
                  strnset(mmenu[0] + 13, ' ', 30);
                  if((strlen(destdir) > 3) && exist(destdir, _DIR_)) {
                     dialogcolor(WARNING);
                     SetDialogWindowTo(255, 255, SingleLine | Shadow, " Warning ");
                     DialogBox(";  Path already exists...;", ScrollPressAnyKey);
                  }
                  PopWindow();
                  CloseHelp();
                  break;

               case 2:
                  libmenu(attr);
                  break;

               case 3:
                  optmenu(attr);
                  break;

               case 4:
                  if(!(useBCSU || useBCMU || useMSCSU || useMSCMU ||
                       RTL || Util || MakeCode || Examples || Doc)) {
                     dialogcolor(WARNING);
                     SetDialogWindowTo(255, 255, SingleLine | Shadow, " Information ");
                     DialogBox("; Sorry, no options chosen to install ! ;CENTERTEXT",
                               "Buttons=Ok");
                     res1 = 1;
                     continue;
                  }
                  if((strlen(destdir) > 3) && exist(destdir, _DIR_)) {
                     OpenHelp(PathExistHlp);
                     dialogcolor(WARNING);
                     SetDialogWindowTo(255, 255, SingleLine | Shadow, " Warning ");

                     StayOnUntilRemoved = TRUE;
                     answer = DialogBox(";  Destination path already exists;  CENTERTEXT",
                                        "BUTTONS=Continue Modify");
                     StayOnUntilRemoved = TRUE;
                     CloseHelp();

                     if(answer == 'C') {
                        PopWindow();
                        scrsaved = FALSE;
                        res      = FALSE;
                     } else
                        res1 = 1;
                  } else {
                     PopWindow();
                     scrsaved = FALSE;
                     res      = FALSE;
                  }
                  break;
            }
         }
      }
   } while(res);

   if(scrsaved)
      PopWindow();

   restorestatusline();
   PopWindow();
   PopColors();

   return res1;
}

int Banner(void)
{
   int res;

   PushColors();
   savestatusline();
   paintstatusline(" ~Enter~ to Continue  ~Esc~ Quit", 0, 0);
   dialogcolor(WARNING);
   SetDialogWindowTo(255, 255, DoubleLine | Shadow | Raised, " Welcome to Topaz for C/C++ ");
   res = DialogBox(bannermsg, "BUTTONS=Continue");
   restorestatusline();
   PopColors();

   return (res != 0x1B);
}

void Done(void)
{
   dialogcolor(WARNING);
   SetDialogWindowTo(255, 255, SingleLine | Shadow, "");
   DialogBox(donemsg, "BUTTONS=Goodbye");
   ChangeDir(destdir);
}
