#include "install.h"

#define LRTrimUpr(S)    (Ltrim(Trim(strupr((S)))))
#define isSection(S)    (strcmp((S), LRTrimUpr(db._SECTION)) == 0)

char BCpathHlp[]   = "Type correct path to your Borland C/C++ compiler                      ;;";

static SectionInfo   *si = NULL;
static SectionInfo    tmp;
static InstDBFrecord  db;

static char  s[STRSIZ * 8];
static char  cdir[STRSIZ];
static char  archive[PATHLEN];
static char  oldname[_MAX_PATH];
static char  newname[_MAX_PATH];
static long  size;
static int   No;
static char  PathForInclude[STRSIZ];
static char  PathForBCLibs[STRSIZ];
static char  PathForMSCLibs[STRSIZ];
static char  PathForUtils[STRSIZ];
static char  PathForSource[STRSIZ];
static char  Path4Makecode[_MAX_PATH];
static char  Path4Template[_MAX_PATH];

char *addlastBSL(char *path)
{
   if(*path && (path[strlen(path) - 1] != '\\'))
      strcat(path, "\\");

   return path;
}

char *dellastBSL(char *path)
{
   if(*path && (path[strlen(path) - 1] == '\\'))
      path[strlen(path) - 1] = 0;

   return path;
}

BOOL exist(char *path, int what)
{
   struct stat st;

   if(stat(path, &st) == -1)
      return FALSE;

   switch(what) {
      case _DIR_:
         return st.st_mode & S_IFDIR;

      case _FILE_:
         return !(st.st_mode & S_IFDIR);

      default:
         return FALSE;
   }
}

void ErrorMsg(char *fmt, ...)
{
   va_list argptr;

   va_start(argptr, fmt);
   vsprintf(s, fmt, argptr);
   va_end(argptr);

   PushColors();
   dialogcolor(ERROR);
   SetDialogWindowTo(255, 255, SingleLine | Shadow, " Error ");
   DialogBox(s, "BUTTONS=Ok");
   PopColors();
}

static char *fullsrcname(char *fname)
{
   static char path[PATHLEN + 16];

   if(!*sourcedir)
      fatalerror("Bad source path\n");

   strcpy(path, addlastBSL(sourcedir));

   return strcat(path, fname);
}

static char *fulldstname(char *pname, char *fname)
{
   static char path[STRSIZ];

   strcpy(path, addlastBSL(destdir));
   strcat(path, addlastBSL(pname));
   return strcat(path, fname);
}

static void ParseLine(SectionInfo *si)
{
   strcpy(si->DirName, LRTrimUpr(db._SUBDIR));
   strcpy(si->ArcName, LRTrimUpr(db._ARCNAME));
   si->Size   = db._SIZE;
   si->DiskNo = (int)db._DISKNO;

   if(!si->DirName[0])
      fatalerror("Illegal directory in line \"%s\"!\n", s);

   if(si->DirName[0] == '.')
      si->DirName[0] = 0;

   if(si->Size < 0L)
      fatalerror("Illegal directory size in line \"%s\"!\n", s);

   if(si->DiskNo <= 0)
      fatalerror("Illegal disk number in line \"%s\"!\n", s);

   if(!(*si->ArcName))
      fatalerror("Illegal archive name in line \"%s\"!\n", s);
}

static BOOL findsection(char *sname)
{
   int SearchField = 1;

   Search(sname, &SearchField, TRUE);

   if(!SearchField) {
      ErrorMsg("; Unrecoverable run-time error ! ;;"
               " Section '%s' not found in file %s ;;"
               " Installation procces can't be continued ! CENTERTEXT",
               sname, fullsrcname(DBFNAME));
      exit(0);
   }

   return SearchField;
}

static void LookFor(char *section, int usage, SectionInfo *si)
{
   if(usage && findsection(section)) {
      while(!dEOF()) {
         if(isSection(section)) {
            ParseLine(si);
            size += si->Size;
            No++;
         }
         Skip(1);
      }
   }
}

static void NumItems(void)
{
   size = 0L;
   No   = 0;

   LookFor(LIBRARY_BS,   useBCSU,  &tmp);
   LookFor(LIBRARY_BM,   useBCMU,  &tmp);
   LookFor(LIBRARY_MS,   useMSCSU, &tmp);
   LookFor(LIBRARY_MM,   useMSCMU, &tmp);
   LookFor(SOURCE,       RTL,      &tmp);
   LookFor(UTILITIES,    Util,     &tmp);
   LookFor(MAKECODE,     MakeCode, &tmp);
   LookFor(MAKECODE_EXE, MakeCode, &tmp);
   LookFor(EXAMPLES,     Examples, &tmp);
   LookFor(DOCUMENT,     Doc,      &tmp);
   LookFor(ALWAYS, RTL || useBCSU || useBCMU || useMSCSU || useMSCMU, &tmp);
}

static void LoadStructOf(char *section, int usage, int *line)
{
   if(usage && findsection(section)) {
      while(!dEOF()) {
         if(isSection(section))
            ParseLine(&si[(*line)++]);
         Skip(1);
      }
   }
}

static void LoadStruct(void)
{
   int i = 0;

   LoadStructOf(LIBRARY_BS,   useBCSU,  &i);
   LoadStructOf(LIBRARY_BM,   useBCMU,  &i);
   LoadStructOf(LIBRARY_MS,   useMSCSU, &i);
   LoadStructOf(LIBRARY_MM,   useMSCMU, &i);
   LoadStructOf(SOURCE,       RTL,      &i);
   LoadStructOf(UTILITIES,    Util,     &i);
   LoadStructOf(MAKECODE,     MakeCode, &i);
   LoadStructOf(MAKECODE_EXE, MakeCode, &i);
   LoadStructOf(EXAMPLES,     Examples, &i);
   LoadStructOf(DOCUMENT,     Doc,      &i);
   LoadStructOf(ALWAYS, RTL || useBCSU || useBCMU || useMSCSU || useMSCMU, &i);
}

static int compare(const void *a, const void *b)
{
   return ((SectionInfo *)a)->DiskNo - ((SectionInfo *)b)->DiskNo;
}

static long diskfree(char drv)
{
   struct diskfree_t free;

   if(_dos_getdiskfree(drv - '@', &free) != 0)
      return 0L;

   return (long) free.avail_clusters   *
          (long) free.bytes_per_sector *
          (long) free.sectors_per_cluster;
}

static BOOL TestDiskNo(int diskNo)
{
   char fname[12];

   sprintf(fname, "DISK%d.", diskNo);

   return exist(fullsrcname(fname), _FILE_);
}

static BOOL ReadCFG(void)
{
   long freespace, free_mem, needed_mem;

   if(!exist(fullsrcname(DBFNAME), _FILE_)) {
      ErrorMsg("; File not found ; %s ; CENTERTEXT", fullsrcname(DBFNAME));
      return FALSE;
   }

   sprintf(s, "%s EXCLUSIVE", fullsrcname(DBFNAME));
   Use(s, &db, sizeof(InstDBFrecord));

   NumItems();

   if(!No)
      return FALSE;

   size += 1048576L;    // Plus 1 Mb additional space

   freespace = diskfree(*destdir);

   if(size >= freespace) {
      ErrorMsg(";Not enough space on the destination drive!;"
               "There are %ld.%03ld Kbytes left on your hard drive,;"
               " and you need at least %ld.%03ld Kbytes of free space;"
               " to install TOPAZ.; CENTERTEXT", freespace >> 20,
               (freespace - ((freespace >> 20) << 20)) >> 10,
               size >> 20, (size - ((size >> 20) << 20)) >> 10);
      return FALSE;
   }

   free_mem = coreleft();
   needed_mem = (int) No * sizeof(SectionInfo);

   if((si = (SectionInfo *) malloc((int) needed_mem)) == NULL) {
      ErrorMsg("; Not enough RAM memory available ;"
               " to install TOPAZ! There are;"
               "%ld bytes of available RAM, and;"
               "%ld bytes are required.; "
               " You should remove TSRs or load;"
               "them high.; CENTERTEXT", free_mem, needed_mem);
      return FALSE;
   }

   LoadStruct();

   qsort((void *) si, No, sizeof(SectionInfo), compare);

   if(findsection(ARC_DRV)) {
      strcpy(archive, Ltrim(Trim(db._SUBDIR)));
      if(!*archive) {
         ErrorMsg(";  Bad archive driver name; CENTERTEXT");
         return FALSE;
      }
   }

   return TRUE;
}

static BOOL NextDisk(int diskNo)
{
   int res;

   while(!TestDiskNo(diskNo)) {
      clrscr();
      dialogcolor(NEXTDISK);
      SetDialogWindowTo(255, 255, SingleLine | Shadow, " Pause ");
      if ((*sourcedir == 'A') || (*sourcedir == 'B')) {
         sprintf(s, ";  Please insert disk  ;#%d;into drive %c:; CENTERTEXT",
                    diskNo, *sourcedir);
         res = DialogBox(s, "BUTTONS=Continue Quit");
         if(res == ESC || res == 'Q')
            return FALSE;
      } else { // we are on the hard drive ...
         ErrorMsg("; All files from the distribution disks must be;"
                  "present on the hard drive. At least one file is;"
                  "missing! Please copy all files from all TOPAZ;"
                  "distribution disks to the hard drive, and run;"
                  "INSTALL.EXE again.; CENTERTEXT");
         return FALSE;
      }
   }
   return TRUE;
}

static BOOL copyFile(char *srcfile, char *subdir)
{
   if(!exist(fullsrcname(srcfile), _FILE_)) {
      ErrorMsg(";  File not found  ;%s; CENTERTEXT", fullsrcname(srcfile));
      return FALSE;
   }

   sprintf(s, "COPY %s ", fullsrcname(srcfile));
   if(*subdir) {
      strcat(s, addlastBSL(destdir));
      strcat(s, dellastBSL(subdir));
   } else
      strcat(s, dellastBSL(destdir));

   printf("\n%s\n", s);

   return !system(s);
}

static BOOL createDir(char *pathname)
{
   char Tmp[STRSIZ], buf[STRSIZ], Path[STRSIZ], Drv[3], *p;

   *Tmp = 0;
   *Drv = 0;
   strcpy(Path, pathname);

   if(*(Path + 1) == ':') {
      strncpy(Drv, Path, 2);
      *(Drv + 2) = 0;
      strcpy(Path, Path + 2);
   }

   if(*Path == '\\')
      strcpy(Path, Path + 1);

   do {
      p = strchr(Path, '\\');
      if(p != NULL) {
         if(*Tmp)
            strcat(Tmp, "\\");
         *p = 0;
         strcat(Tmp, Path);
         strcpy(Path, p + 1);
      } else {
         if(*Tmp)
            strcat(Tmp, "\\");
         strcat(Tmp, Path);
      }

      if(*Drv) {
         sprintf(buf, "%s\\%s", Drv, Tmp);
         if(!exist(buf, _DIR_))
            if(mkdir(buf) != 0)
               return FALSE;
      } else
         if(!exist(Tmp, _DIR_))
            if(mkdir(Tmp))
               return FALSE;

   } while(p);

   return TRUE;
}

static BOOL createDirs(void)
{
   int i;

   strcpy(s, dellastBSL(destdir));
   if(!createDir(s)) {
      ErrorMsg(";  Can't create destination directory;%s; CENTERTEXT", s);
      return FALSE;
   }

   for(i = 0; i < No; i++) {
      if(*((si + i)->DirName)) {
         strcpy(s, addlastBSL(destdir));
         strcat(s, dellastBSL((si + i)->DirName));
      } else
         strcpy(s, dellastBSL(destdir));

      if(!createDir(s)) {
         ErrorMsg(";  Can't create destination directory;%s; CENTERTEXT", s);
         return FALSE;
      }
   }
   return TRUE;
}

void ChangeDir(char *dir)
{
   getcwd(cdir, STRSIZ);
   if(*dir != *cdir)
      setdisk(*dir - 'A');
   chdir(dir);
}

static void RestoreDir(void)
{
   if(*cdir != getdisk() + 'A')
      setdisk(*cdir - 'A');
   chdir(cdir);
}

static BOOL UnpackFile(char *srcfile, char *subdir)
{
   if(!copyFile(srcfile, subdir))
      return FALSE;

   if(*subdir) {
      strcpy(s, addlastBSL(destdir));
      strcat(s, dellastBSL(subdir));
   } else
      strcpy(s, dellastBSL(destdir));

   ChangeDir(s);

   strcpy(s, getenv("COMSPEC"));
   if(!*s) {
      ErrorMsg(";Can't find COMMAND.COM; CENTERTEXT");
      return FALSE;
   }

   printf("\n%s %s\n", fulldstname("", archive), srcfile);

   sprintf(s, "%s /C %s %s", getenv("COMSPEC"), fulldstname("", archive),
   srcfile);

   if(system(s)) {
      ErrorMsg(";Can't unpack file!; CENTERTEXT");
      RestoreDir();
      return FALSE;
   }

   remove(srcfile);
   RestoreDir();
   return TRUE;
}

static char *PathForSection(char *Section)
{
   static char path[41];

   *path = 0;
   if(findsection(Section))
      strcpy(path, Trim(db._SUBDIR));

   return path;
}

static void MakeAdditionalPathes(void)
{
   char path2makecode[14];

   *PathForInclude = 0;
   *PathForBCLibs  = 0;
   *PathForMSCLibs = 0;
   *PathForUtils   = 0;

   strcpy(PathForInclude, destdir);
   strcat(addlastBSL(PathForInclude), PathForSection(ALWAYS));

   if(useBCSU) {
      strcat(PathForBCLibs, destdir);
      strcat(addlastBSL(PathForBCLibs), PathForSection(LIBRARY_BS));
   }

   if(useBCMU) {
      if(useBCSU)
         strcat(PathForBCLibs, ";");
      strcat(PathForBCLibs, destdir);
      strcat(addlastBSL(PathForBCLibs), PathForSection(LIBRARY_BM));
   }

   if(useMSCSU) {
      strcat(PathForMSCLibs, destdir);
      strcat(addlastBSL(PathForMSCLibs), PathForSection(LIBRARY_MS));
   }

   if(useMSCMU) {
      if(useMSCSU)
         strcat(PathForMSCLibs, ";");
      strcat(PathForMSCLibs, destdir);
      strcat(addlastBSL(PathForMSCLibs), PathForSection(LIBRARY_MM));
   }

   if(Util) {
      strcat(PathForUtils, destdir);
      strcat(addlastBSL(PathForUtils), PathForSection(UTILITIES));
   }

   if(MakeCode) {
      strcpy(path2makecode, PathForSection(MAKECODE_EXE));
      if(Util) {
         if(strcmp(path2makecode, PathForSection(UTILITIES))) {
            strcat(PathForUtils, ";");
            strcat(PathForUtils, destdir);
            strcat(addlastBSL(PathForUtils), path2makecode);
         }
      } else {
         strcat(PathForUtils, destdir);
         strcat(addlastBSL(PathForUtils), path2makecode);
      }

      strcpy(Path4Makecode, destdir);
      strcat(addlastBSL(Path4Makecode), PathForSection(MAKECODE_EXE));
      strcat(addlastBSL(Path4Makecode), "MAKECODE.CFG");

      strcpy(Path4Template, destdir);
      strcat(addlastBSL(Path4Template), PathForSection(MAKECODE));
   }

   strcpy(PathForSource, PathForSection(SOURCE));
}

BOOL installNow(void)
{
   int i, res = FALSE;
   char arc[13];
   char *p;

   SetCursorOff();

   dialogcolor(WARNING);
   SetDialogWindowTo(255, 255, SingleLine | Shadow, " Information ");
   DialogBox("; Now the installation program is reading configuration file.  ;"
             "Please wait.; CENTERTEXT", StayOn);

   if(!ReadCFG()) {
      RemoveDialogBox();
      return res;
   }

   MakeAdditionalPathes();

   if(!createDirs()) {
      free(si);
      RemoveDialogBox();
      return res;
   }

   if((p = strchr(archive, ' ')) != NULL) {
      *p = 0;
      strcpy(arc, archive);
      *p = ' ';
   }

   RemoveDialogBox();
   PushColors();
   PushWindow(1, 1, 80, 25);
   paintstatusline(" Press ~Esc~ to interrupt instalation process", 0, 0);
   color(HELP);
   Box(1, 2, 80, 24, SingleLine, " DOS Window ");
   OpenDOSWindow(2, 3, 79, 23, HELP);

   if(!copyFile(arc, ""))
      goto err;

   for(i = 0; i < No; i++) {
      if(!NextDisk((si + i)->DiskNo))
         goto err;

      if(kbhit())
         if(getch() == ESC) {
            while(kbhit())
               getch();
            dialogcolor(ERROR);
            SetDialogWindowTo(255, 255, SingleLine | Shadow, " Pause ");
            if(DialogBox(";  Would you like to interrupt the installation process?  ; CENTERTEXT",
                         "BUTTONS=Continue Interrupt") == 'I')
               goto err;
         }

      if(!UnpackFile((si + i)->ArcName, (si + i)->DirName))
         goto err;
   }

   remove(fulldstname("", arc));
   res = TRUE;

err:
   CloseDOSWindow();
   PopWindow();
   PopColors();
   SetClocksOn();
   return res;
}

static void Modify_TURBOC_CFG(char *path, BOOL overwrite)
{
   FILE *fold, *fnew;
   char str[STRSIZ];

   if(!(useBCSU || useBCMU))
      return;

   strcpy(oldname, path);
   strcat(addlastBSL(oldname), "BIN");
   strcat(addlastBSL(oldname), "TURBOC.CFG");

   if(!exist(oldname, _FILE_))
      overwrite = FALSE;

   if(overwrite) {
      strcpy(newname, path);
      strcat(addlastBSL(newname), "BIN");
   } else
      strcpy(newname, destdir);

   strcat(addlastBSL(newname), "TURBOC.NEW");

   if(!exist(oldname, _FILE_)) {
      PushColors();
      dialogcolor(WARNING);
      sprintf(s, "; File not found ; %s "
                 "; All changes will be saved in ; %s ; CENTERTEXT",
                 oldname, newname);
      SetDialogWindowTo(255, 255, SingleLine | Shadow, " Information ");
      DialogBox(s, "BUTTONS=Ok");
      PopColors();
   }

   if((fnew = fopen(newname, "wt")) == NULL) {
      ErrorMsg("; Can't create file ; %s ; CENTERTEXT", newname);
      return;
   }

   fprintf(fnew, "-I%s\n", PathForInclude);

   if(*PathForBCLibs)
      fprintf(fnew, "-L%s\n", PathForBCLibs);

   if(!exist(oldname, _FILE_)) {
      fclose(fnew);
      return;
   }

   if((fold = fopen(oldname, "rt")) == NULL) {
      ErrorMsg(";  Can't open file  ;%s; CENTERTEXT", oldname);
      return;
   }

   while(fgets(str, STRSIZ, fold))
      fprintf(fnew, "%s", str);

   fclose(fold);
   fclose(fnew);

   if(overwrite) {
      *strrchr(newname, '.') = 0;
      strcat(newname, ".OLD");
      unlink(newname);
      rename(oldname, newname);
      *strrchr(newname, '.') = 0;
      strcat(newname, ".CFG");
      *strrchr(oldname, '.') = 0;
      strcat(oldname, ".NEW");
      rename(oldname, newname);

   }
}

static void Modify_AUTOEXEC_BAT(char *path, BOOL overwrite)
{
   char  str[STRSIZ], *p;
   FILE *fold, *fnew;
   int   update = 0;
   int   MSC;

   if(!(useMSCSU || useMSCMU || MakeCode || Util))
      return;

   MSC = useMSCSU || useMSCMU;

   strcpy(oldname, path);
   strcat(addlastBSL(oldname), "AUTOEXEC.BAT");

   if(!exist(oldname, _FILE_))
      overwrite = FALSE;

   if(overwrite)
      strcpy(newname, path);
   else
      strcpy(newname, destdir);

   strcat(addlastBSL(newname), "AUTOEXEC.NEW");

   if(!exist(oldname, _FILE_)) {
      PushColors();
      dialogcolor(WARNING);
      sprintf(s, "; File not found ; %s "
      "; All changes will be saved in ; %s ; CENTERTEXT",
      oldname, newname);
      SetDialogWindowTo(255, 255, SingleLine | Shadow, " Information ");
      DialogBox(s, "BUTTONS=Ok");
      PopColors();
   }

   if((fnew = fopen(newname, "w+t")) == NULL) {
      ErrorMsg(";  Can't create file  ;%s; CENTERTEXT", newname);
      return;
   }

   if(!exist(oldname, _FILE_)) {
      if(MSC) {
         fprintf(fnew, "SET INCLUDE=%s\n", PathForInclude);
         fprintf(fnew, "SET LIB=%s\n", PathForMSCLibs);
      }
      if(*PathForUtils)
         fprintf(fnew, "SET PATH=%s\n", PathForUtils);
      fclose(fnew);
      return;
   }

   if((fold = fopen(oldname, "rt")) == NULL) {
      ErrorMsg(";  Can't open file  ;%s; CENTERTEXT", oldname);
      return;
   }

   while(fgets(str, STRSIZ, fold)) {
      if((p = strstr(Upper(str), "SET")) != NULL) {
         p += 3;
         while(*p < '!' && *p)
            p++;
         if(MSC && !strnicmp(p, "INCLUDE", 7)) {
            p = strchr(str, '=');
            if(p)
               fprintf(fnew, "SET INCLUDE=%s;%s", PathForInclude, ++p);
            else
               fprintf(fnew, "SET INCLUDE=%s\n", PathForInclude);
            update |= 0x1;
            continue;
         } else
            if(MSC && !strnicmp(p, "LIB", 3)) {
               p = strchr(str, '=');
               if(p)
                  fprintf(fnew, "SET LIB=%s;%s", PathForMSCLibs, ++p);
               else
                  fprintf(fnew, "SET LIB=%s\n", PathForMSCLibs);
               update |= 0x10;
               continue;
            } else
               if(*PathForUtils && !strnicmp(p, "PATH", 4)) {
                  p = strchr(str, '=');
                  if(p)
                     fprintf(fnew, "SET PATH=%s;%s", PathForUtils, ++p);
                  else
                     fprintf(fnew, "SET PATH=%s\n", PathForUtils);
                  update |= 0x100;
                  continue;
               } else
                  fputs(str, fnew);
      } else {
         p = str;
         while(*p < '!' && *p)
             p++;
         // Maybe PATH ...
         if(*PathForUtils && !strnicmp(p, "PATH", 4)) {
            p += 4;
            while(*p < '!' && *p)
                p++;
            if(p)
               fprintf(fnew, "PATH %s;%s", PathForUtils, p);
            else
               fprintf(fnew, "PATH %s\n", PathForUtils);
            update |= 0x100;
            continue;
         } else
            fputs(str, fnew);
      }
   }

   if(MSC && !(update & 0x1))
      fprintf(fnew, "SET INCLUDE=%s\n", PathForInclude);

   if(MSC && !(update & 0x10))
      fprintf(fnew, "SET LIB=%s\n", PathForMSCLibs);

   if(*PathForUtils && !(update & 0x100))
      fprintf(fnew, "SET PATH=%s\n", PathForUtils);

   fclose(fold);
   fclose(fnew);

   if(overwrite) {
      *strrchr(newname, '.') = 0;
      strcat(newname, ".OLD");
      unlink(newname);
      rename(oldname, newname);
      *strrchr(newname, '.') = 0;
      strcat(newname, ".BAT");
      *strrchr(oldname, '.') = 0;
      strcat(oldname, ".NEW");
      rename(oldname, newname);
   }
}

static void Modify_MAKEOBJ_BAT(char *includepath)
{
   char  str[STRSIZ];
   char  *p;
   FILE *fold, *fnew;

   if(!((useBCSU || useBCMU) && RTL))
      return;

   strcpy(oldname, destdir);
   strcat(addlastBSL(oldname), PathForSource);
   strcat(addlastBSL(oldname), "MAKEOBJ");
   strcpy(newname, oldname);
   strcat(oldname, ".BAT");
   strcat(newname, ".NEW");

   if(!exist(oldname, _FILE_))
      return;

   dellastBSL(includepath);

   if((fold = fopen(oldname, "rt")) == NULL) {
      ErrorMsg(";  Can't open file  ;%s; CENTERTEXT", oldname);
      return;
   }

   if((fnew = fopen(newname, "wt")) == NULL) {
      ErrorMsg(";  Can't create file  ;%s; CENTERTEXT", newname);
      fclose(fold);
      return;
   }

   while(fgets(str, STRSIZ, fold)) {
      if((p = strstr(Upper(str), "INCLUDEPATH=")) != NULL) {
         p = strchr(str, ';') + 1;
         fprintf(fnew, "make INCLUDEPATH=%s;%s", includepath, p);
      } else
         fputs(str, fnew);
   }

   fclose(fold);
   fclose(fnew);

   unlink(oldname);
   rename(newname, oldname);
}

static void CreateMakecodeConfig(void)
{
   FILE *f;

   if(!MakeCode)
      return;

   if((f = fopen(Path4Makecode, "wt")) == NULL) {
      ErrorMsg(";  Can't open file  ;%s; CENTERTEXT", Path4Makecode);
      return;
   }

   fprintf(f, "%s\n", Path4Template);

   fclose(f);
}


// This function modifies the system files such as AUTOEXEC.BAT,
//              TURBOC.CFG and MAKEOBJ.BAT
void ModifySystemFiles(void)
{
   BOOL overwrite;
   char BCpath[69];

   if(!(useBCSU || useBCMU || useMSCSU || useMSCMU || Util || MakeCode))
      return;

   CreateMakecodeConfig();

   PushColors();

   SetEscapeOff();

   dialogcolor(WARNING);
   SetDialogWindowTo(255, 255, SingleLine | Shadow, " Information ");
   sprintf(s,"; Would you like to modify your AUTOEXEC.BAT%s ? "
             "; If <Yes> file%s will be modified now, otherwise the necessary "
             "; changes will be saved in AUTOEXEC.NEW%s in directory "
             "; %s CENTERTEXT",
             (useBCSU || useBCMU) ? " and TURBOC.CFG" : "",
             (useBCSU || useBCMU) ? "s"               : "",
             (useBCSU || useBCMU) ? " and TURBOC.NEW" : "",
             dellastBSL(destdir));

   overwrite = (DialogBox(s, "BUTTONS=Yes No") == 'Y');

   if(useBCSU || useBCMU) {
      strcpy(BCpath, "C:\\BORLANDC");
      PushWindow(1, 1, 80, 25);
      OpenHelp(BCpathHlp);
      Box(4, 11, 76, 13, SingleLine | Shadow | Raised, "");
      getline(6, 12, DIALOG, 68, BCpath, "@R");
      CloseHelp();
      PopWindow();
      strupr(BCpath);
   } else
      *BCpath = 0;

   SetEscapeOn();

   Modify_TURBOC_CFG(dellastBSL(BCpath), overwrite);
   Modify_AUTOEXEC_BAT("C:", overwrite);
   strcat(addlastBSL(BCpath), "INCLUDE");
   Modify_MAKEOBJ_BAT(BCpath);

   PopColors();
}
