@echo off

if not (%1)==() goto SPLIT

REM Modify the next three lines to customize the environment settings to
REM reflect your own relative paths from this directory to your single user
REM TOPAZ library directory, multi-user TOPAZ library directory, and the
REM name of the TOPAZ library you are going to split.

SET SULIB=..\SULIB
SET MULIB=..\MULIB
SET TOPAZLIB=TOPAZDOS.LIB
SET ENVTEST=TRUE

if %ENVTEST%==TRUE goto $1
echo.
echo *Error* - Out of environment space.
echo.
goto _exit

:$1
if exist mod\*.mod goto _start
echo.
echo *Error* - Abnormal termination.
echo           Can't find module description files (MOD\*.MOD)
echo.
goto _exit

:_start
cls
echo.
echo ͻ
echo                  TOPAZ for C/C++ version 4.5                 
echo         (c) Copyright 1988, 94 Software Science Inc.         
echo                 All Rights Reserved Worldwide.               
echo Ķ
echo    Splits TOPAZ library for Borland C/C++ into two parts -   
echo      static and dynamic for building overlayed programs      
echo ͼ
echo.
echo                            Warning
echo.                           
echo  This operation requires approximate 5 Mb of free space on your
echo  hard drive for both libraries (single-user and multi-user).
echo  If you would like to start the process press any key, otherwise
echo  press Control+C or Control+Break to exit
echo 
pause > NUL

if exist result del result

if not exist %SULIB%\%TOPAZLIB% goto $2
call tzsplit.bat %SULIB% %TOPAZLIB% Single
cd %SULIB%
tlib topazo.lib /C /0 *-sg4ini.obj *-tzmemini.obj *-tzedinit.obj *-vdpopini.obj
tlib topazs.lib /C /0 +sg4ini.obj +tzmemini.obj +tzedinit.obj +vdpopini.obj
erase sg4ini.obj
erase tzmemini.obj
erase tzedinit.obj
erase vdpopini.obj
erase topazo.bak
erase topazs.bak
cd ..\tzsplit
goto _next

:$2
echo *Warning* - Library %SULIB%\%TOPAZLIB% not found.
echo             Operation canceled.
echo.

:_next
if not exist %MULIB%\%TOPAZLIB% goto $3
call tzsplit.bat %MULIB% %TOPAZLIB% Multi
cd %MULIB%

tlib topazo.lib /C /0 *-sg4ini.obj *-tzmemini.obj *-tzedinit.obj *-vdpopini.obj
tlib topazs.lib /C /0 +sg4ini.obj +tzmemini.obj +tzedinit.obj +vdpopini.obj
erase sg4ini.obj
erase tzmemini.obj
erase tzedinit.obj
erase vdpopini.obj
erase topazo.bak
erase topazs.bak
cd ..\tzsplit
goto _exit

:$3
echo *Warning* - Library %MULIB%\%TOPAZLIB% not found.
echo             Operation canceled.
echo.
goto _exit;

:SPLIT
echo.
echo  *** Spliting %3-User library %1\%2 ***
echo.

echo. >> result
echo Spliting %3 user library %1\%2 >> result
echo. >> result

if exist %1\topazs.lib del %1\topazs.lib
if exist %1\topazo.lib del %1\topazo.lib

echo ### Preparing overlay library >> result
echo. >> result

rem  Ŀ
rem         Static part         
rem  

echo  Extracting modules from library...

md temp
cd temp

echo ### Extracting modules from library... >> ..\result
for %%f in (CLOCK COMMON DBF INDEX TZMENU) do TLIB ..\%1\%2 /C/0 @..\MOD\%%f.MOD >> ..\result
for %%f in (SAVER SPOOLER VFILES BROWSE) do TLIB ..\%1\%2 /C/0 @..\MOD\%%f.MOD >> ..\result

echo  Creating static library %1\TOPAZS.LIB...

if exist lib.rsp del lib.rsp
for %%f in (*.OBJ) do echo + %%f & >> lib.rsp
echo + >> lib.rsp

echo. >> ..\result
echo ### Creating static library %1\TOPAZS.LIB... >> ..\result
TLIB ..\%1\topazs.lib /C/0 @lib.rsp >> ..\result

del *.rsp
del *.obj

echo  Static Processing Done.

rem  Ŀ
rem         Overlay part        
rem  

echo.
echo  Extracting modules from library...

echo. >> ..\result
echo ### Extracting modules from library... >> ..\result

for %%f in (CALC DBFEDIT DIALOG) do TLIB ..\%1\%2 /C/0 @..\MOD\%%f.MOD >> ..\result
for %%f in (EDIT HELP MEMO MEM PICK) do TLIB ..\%1\%2 /C/0 @..\MOD\%%f.MOD >> ..\result
for %%f in (PRINTCOM REPORT SAYGET SCRNEDIT) do TLIB ..\%1\%2 /C/0 @..\MOD\%%f.MOD >> ..\result
for %%f in (TIMEDATE TZPRINT UTILS VIDPOP) do TLIB ..\%1\%2 /C/0 @..\MOD\%%f.MOD >> ..\result

echo  Creating overlay library %1\TOPAZO.LIB...

if exist lib.rsp del lib.rsp
for %%f in (*.OBJ) do echo + %%f & >> lib.rsp
echo + >> lib.rsp

echo. >> ..\result
echo ### Creating overlay library %1\TOPAZO.LIB... >> ..\result
TLIB ..\%1\topazo.lib /C/0 @lib.rsp >> ..\result

del *.rsp
del *.obj
cd ..
rd temp

echo  Overlay Processing Done.

:_exit

if not ((%1)==(%MULIB%)) goto __exit

SET SULIB=
SET MULIB=
SET TOPAZLIB=
SET ENVTEST=

:__exit
