*.............................................................................
*
*   Program Name: SKIPHAND.PRG        Copyright: Borland International
*   Date Created: 22 Mar 94            Language: dBASE 5.0
*   Time Created: 20:12:01               Author: Borland dBASE R&D
*   /brief/library.src
*.............................................................................

*..........................................................................
* Procedure Name:   SkipHand
* Parameters:       None
* Ext Memvars:      None
* Description:      Skips forward one record in the current table, if any.
*                   Default ONCLICK handler for "Next" button in forms
*                   designer.
*..........................................................................
PROCEDURE SkipHand
#include "talkoff.hdb"

    PRIVATE lVoid, lAddRec, oF, oC, cKey

    IF TYPE( "Form.CurrMast" ) = "C" .OR. TYPE( "Form.FormView" ) = "C"

        IF TYPE( "Form.CurrMast" ) = "C"
            SELECT ( Form.CurrMast )
        ENDIF
        IF .NOT. EOF()
            IF Form.Modified()
                lVoid = Form.Submit()
            ENDIF

            IF TYPE( "Form.CurrMast" ) = "C"
                SELECT ( Form.CurrMast )
            ENDIF

            SKIP
            IF EOF() .AND. TYPE( "Form.CurrMast" ) = "C"
                IF TYPE( "Form.AddingRec" ) = "L" .AND. Form.AddingRec
                    *------------------------------------------------
                    *-- Skip over add message since they answered yes
                    *-- already.
                    *------------------------------------------------
                ELSE
                    #include "errmsg.hdb"
                    dB5___EMsg.Message = [Add new records?]
                    dB5___EMsg.BoxTitle = [Information]
                    dB5___EMsg.OkText = [~Y~es]
                    dB5___EMsg.CancelBtn = .T.
                    dB5___EMsg.CancelText = [~N~o]
                    DO ErrMsg WITH dB5___EMsg
                    lAddRec = dB5___EMsg.OkChosen
                    lVoid = dB5___EMsg.Release()
                    RELEASE dB5___EMsg
                    IF .NOT. lAddRec
                        GO BOTTOM
                        Form.AddingRec = .F.
                    ELSE
                        Form.AddingRec = .T.
                    ENDIF
                ENDIF
            ELSE
                *--------------------------------------------------
                *-- Don't go to the end of file position for a view
                *--------------------------------------------------
                IF EOF() .AND. TYPE( "Form.FormView" ) = "C"
                    GO BOTTOM
                ENDIF

                Form.AddingRec = .F.
            ENDIF

            *---------------------------------------
            *-- Check for need to scan lookup fields
            *---------------------------------------
            IF TYPE( "Form.Scan4Look" ) = "N" .AND. Form.Scan4Look > 0

                *-----------------------------------------------------------
                *-- For Each field that has a lookup, call LookRef to update
                *-- the value of the look fields.
                *-----------------------------------------------------------
                oF = Form.First
                oC = m->oF
                DO WHILE .T.
                    IF oC.ClassName = "ENTRYFIELD"
                        IF TYPE( "oC.LookTag" ) = "C"
                            SELECT (oC.LookAlias)
                            SEEK EVAL( oc.DataLink )
                        ENDIF
                    ENDIF
                    oC = oC.After
                    IF oC = m->oF
                        EXIT
                    ENDIF
                ENDDO

            ENDIF

            IF TYPE( "Form.CurrMast" ) = "C"
                SELECT ( Form.CurrMast )
            ENDIF

            *-----------------------------------------------------------
            *-- Placement of the following Refresh() call is important.
            *-- At this point, the Master file and all the lookup files
            *-- are pointing to the correct records.  The Refresh() call
            *-- updates the DataLinks with the new record values here.
            *-----------------------------------------------------------
            lVoid = Form.Refresh()

            *---------------------------------------------------
            *-- If adding a new record, check for default values
            *---------------------------------------------------
            IF Form.AddingRec .AND. ;
               TYPE( "Form.HasDefVal" ) = "L" .AND. Form.HasDefVal

                DO DefValue

            ENDIF

            *------------------------------------------
            *-- Check for need to update Detail regions
            *------------------------------------------
            IF TYPE( "Form.DetExist" ) = "L" .AND. Form.DetExist
                DO UpDetail WITH m->Form
            ENDIF
            
        ELSE
            IF TYPE( "Form.CurrMast" ) = "C"
                *----------------------------------------
                *-- This is a newly appended record to be
                *----------------------------------------
                IF Form.Modified()
                    *-----------------------------------------
                    *-- Write the form values to the datalinks
                    *-----------------------------------------
                    IF TYPE( "Form.CurrMast" ) = "C"
                        SELECT ( Form.CurrMast )
                    ENDIF
                    lVoid = Form.Submit()
                ENDIF

                *----------------------------------------------
                *-- Go to the EOF ready for the next new record
                *----------------------------------------------
                SELECT ( Form.CurrMast )
                GO BOTTOM
                IF .NOT. EOF()
                    SKIP
                ENDIF
                Form.AddingRec = .T.

                *---------------------------------------
                *-- Check for need to scan lookup fields
                *---------------------------------------
                IF TYPE( "Form.Scan4Look" ) = "N" .AND. Form.Scan4Look > 0

                    *-----------------------------------------------------------
                    *-- For Each field that has a lookup, call LookRef to update
                    *-- the value of the look fields.
                    *-----------------------------------------------------------
                    oF = Form.First
                    oC = m->oF
                    DO WHILE .T.
                        IF oC.ClassName = "ENTRYFIELD"
                            IF TYPE( "oC.LookTag" ) = "C"
                                SELECT (oC.LookAlias)
                                SEEK EVAL( oc.DataLink )
                            ENDIF
                        ENDIF
                        oC = oC.After
                        IF oC = m->oF
                            EXIT
                        ENDIF
                    ENDDO

                ENDIF

                *-------------------------------
                *-- Display the new blank values
                *-------------------------------
                SELECT ( Form.CurrMast )
                lVoid = Form.Refresh()

                *----------------------------------------------
                *-- Set the default values if the form has them
                *----------------------------------------------
                IF Form.AddingRec .AND. ;
                   TYPE( "Form.HasDefVal" ) = "L" .AND. Form.HasDefVal

                    DO DefValue

                ENDIF


                SELECT ( Form.CurrMast )

                *------------------------------------------
                *-- Check for need to update Detail regions
                *------------------------------------------
                IF TYPE( "Form.DetExist" ) = "L" .AND. Form.DetExist
                    DO UpDetail WITH m->Form
                ENDIF
            ENDIF
        ENDIF
        IF TYPE( "Form.CurrMast" ) = "C"
            SELECT ( Form.CurrMast )
        ENDIF

        *-----------------------------------------------------------------
        *-- If adding new records, make sure focus goes to the first field
        *-----------------------------------------------------------------
        IF TYPE( "Form.AddingRec" ) = "L" .AND. Form.AddingRec
            oF = Form.First
            oC = m->oF
            DO WHILE .T.
                IF .NOT. ( oC.ClassName $ "RECTANGLE,TEXT,PAGEBREAK" )
                    lVoid = oC.SetFocus()
                    EXIT
                ENDIF
                oC = oC.After
                IF oC = m->oF
                    EXIT
                ENDIF
            ENDDO
        ENDIF

    ENDIF        

#include "talkon.hdb"
RETURN

