*****************************************************************
* FILE: refresh.prg
* Shows how to use OnGotFocus to refresh the data-linked fields
* in a form with the current data in a database. Accompanies
* Chapter 22 in the "Programmer's Guide."
*****************************************************************

*---------------------------------------------
* Define a form that shows three fields of 
* the Goods database (GOODS.DBF in SAMPLES).
* The OnGotFocus procedure RGRefresh refreshes
* the form every time the user gives it focus.
*---------------------------------------------
DEFINE FORM ReadGoods FROM 10,12 TO 18,60 ;
   PROPERTY ;
      Text "Number of parts on hand", ;
      OnGotFocus RGRefresh, ;
      OnOpen RGOpen, ;
      OnClose RGClose

DEFINE TEXT t1 OF ReadGoods AT 1,1 ;
   PROPERTY Text "Part Name:", Label .F.
DEFINE ENTRYFIELD PartName OF ReadGoods AT 1,14 ;
   PROPERTY DataLink "Part_Name", Width 32

DEFINE TEXT t2 OF ReadGoods AT 3,1 ;
   PROPERTY Text "Description:", Label .F.
DEFINE ENTRYFIELD Descr OF ReadGoods AT 3,14 ;
   PROPERTY DataLink "Descript", Width 32

DEFINE TEXT t3 OF ReadGoods AT 5,1 ;
   PROPERTY Text "On hand:", Label .F.
DEFINE ENTRYFIELD OnHand OF ReadGoods AT 5,14 ;
   PROPERTY DataLink "Qty_Onhand", Width 6

* Code that defines rest of form--allows user to select a part

lvoid = ReadGoods.Open()        && Open the form window.

PROCEDURE RGOpen                && OnOpen event handler for ReadGoods.
   USE Goods IN 1 NOUPDATE ORDER Part_id
RETURN

PROCEDURE RGRefresh             && OnGotFocus event handler for ReadGoods.
   lVoid = this.Refresh()       && Refresh form so data is current.
RETURN

PROCEDURE RGClose               && OnClose event handler for ReadGoods.
   USE IN 1                     && Close Goods database.
   lVoid = ReadGoods.Release()  && Release form window and its now
   RELEASE ReadGoods            && null object reference variable. 
RETURN
* EOP REFRESH.PRG
