***************************************************************
* FILE MSGBOX.PRG
* Sample program that goes with Chapter 21 of the "Programmer's
* Guide." Displays a message box by using a custom object as a 
* parameter to the procedure that creates the message box. 
***************************************************************
*
*-------------------------------------------------------------
* Define a custom object to contain a set of memory variables.
*-------------------------------------------------------------
DEFINE OBJECT MsgStruc ;
   CUSTOM ;
      Message     ""        , ; 
      BoxTitle    [Message] , ; 
      DrawBox     .T.       

*-------------------------------------------------------------
* Set some of the object's properties, then call the procedure 
* that displays the message box. When DispMsg returns, release
* the custom object and then release its obj. ref. variable.
*-------------------------------------------------------------
MsgStruc.Message = "You've really done it now!"
MsgStruc.BoxTitle = [My Message]
DO DispMsg WITH MsgStruc
lVoid = MsgStruc.Release()
RELEASE MsgStruc

*----------------------------------------------------
* DispMsg
* Displays a message using variables set in MsgStruc.
*----------------------------------------------------
PROCEDURE DispMsg
PARAMETER poMsgStruc
   *---------------------------------------------------
   *-- Trim extra spaces on right of message and center 
   *-- it if it's less than 55 characters wide. Use
   *-- #define statements to avoid using variable slots.
   *---------------------------------------------------
#define MaxSpace 55
#define FormWidth 63
   cMsgText = TRIM(poMsgStruc.Message)
   nMsgLen = LEN( cMsgText )
   nMsgLeft = INT( (FormWidth - nMsgLen) / 2 )
   IF nMsgLeft < 1
      nMsgLeft = 1
   ENDIF
   *------------------------------------------
   *-- Define the objects for the message box.
   *------------------------------------------
   DEFINE FORM MsgBox ;
      PROPERTY  Top 5, Left 8, Height 9, Width FormWidth, ;
                Text poMsgStruc.BoxTitle
   *--------------------------------------------------------------
   *-- If the user did not cancel drawing the box around the text,
   *-- draw the rectangle first so the text will show on top of 
   *-- it. Size the rectangle to fit the length of the message. 
   *--------------------------------------------------------------
   IF poMsgStruc.DrawBox
      IF nMsgLen > MaxSpace
         DEFINE RECTANGLE r OF MsgBox FROM 0,1 TO 2, nMsgLen + 4
      ELSE
         DEFINE RECTANGLE r OF MsgBox FROM 0,1 TO 2, MaxSpace + 4
      ENDIF
   ENDIF

   *---------------------------------------------------
   *-- Add the message indicated in the procedure call.
   *---------------------------------------------------
   DEFINE TEXT Msg OF MsgBox ;
      PROPERTY  Top 1, Left nMsgLeft, Text cMsgText, Border .F.

   *--------------------------------------------
   *-- Add an OK pushbutton, then give it focus.
   *--------------------------------------------
   DEFINE PUSHBUTTON pbOk OF MsgBox ;
      PROPERTY  Top 5, Left 26, Width 8, Text "OK",;
      OnClick OKHand

      lVoid = MsgBox.pbOk.SetFocus()
   
   *--------------------------------------
   *-- Open message box as a modal window.
   *--------------------------------------
   lVoid = MsgBox.ReadModal()

   *---------------------------------------------------------
   *-- Release message box and its object reference variable
   *-- after its pushbutton's OnClick handler returns.
   *---------------------------------------------------------
   lVoid = MsgBox.Release()
   RELEASE MsgBox
RETURN

PROCEDURE OKHand
*------------------
*  Closes the form.
*------------------
   lVoid = Form.Close()
RETURN
*--End of program msgbox
