*.............................................................................
*
*   Program Name: MDORDER.PRG         Copyright: Borland International
*   Date Created: 10 Apr 94            Language: dBASE 5.0
*   Time Created: 18:28:23               Author: Borland dBASE R&D
*   /brief/library.src
*.............................................................................

#define ALLTRIM(kStr)  LTRIM(RTRIM(kStr))

*..........................................................................
* Procedure Name:   MDOrder
* Parameters:       None
* Ext Memvars:      None
* Description:      Display a list of index tags for the user to pick from
*                   and changes the current order to that tag.
*..........................................................................
PROCEDURE MDOrder
    PRIVATE lVoid, cStr, nCnt, i, oForm
    
    DECLARE aTag[1], aKey[1]
    
    oForm = This.Form

    nCnt = TAGCOUNT()
    
    IF .NOT. ISBLANK(ALIAS())
        aTag[1] = [<Natural>]
        aKey[1] = [Put table in natural order (no active index)]

        IF nCnt > 0
            FOR i = 1 TO nCnt
                lVoid = AGROW(aTag,1)
                lVoid = AGROW(aKey,1)
                aTag[i+1] = UPPER(TAG(i))
                aKey[i+1] = KEY(i)
            ENDFOR
        ENDIF
        
        #include "MDORDER.DFM"
        
        lVoid = MDOrder.TagList.SetFocus()
        lVoid = MDOrder.ReadModal()
        
        IF MDOrder.Action
            nSel = MDOrder.TagList.CurSel
            IF nSel = 1
                SET ORDER TO
            ELSE
                SET ORDER TO TAG(nSel - 1)
            ENDIF
            
        ENDIF
        
        lVoid = MDOrder.Release()
    ENDIF
RETURN                
*...................................................................
* Procedure Name:   SayKey
* Parameters:       None
* Ext Memvars:      None
* Description:      Displays a status message showing the index key
*                   for the selected tag
*...................................................................
PROCEDURE SayKey
    This.StatusMessage = aKey[This.CurSel]
RETURN    

