FUNCTION LookVal
PARAMETERS pThis, pForm
*----------------------------------------------------------------------------
* NAME
*   LookVal() - Generic Lookup validation routine.  
* DESCRIPTION
*   Search the lookup table using the value in the trigger field.
*   If it matches, then update any DataLinks that are connected to
*   the lookup table.
*   If it doesn't match, display a browse table if Help and Fill is 
*   active.  Otherwise, trigger an error.
*
*----------------------------------------------------------------------------
#include "talkoff.hdb"

    PRIVATE lReturn, lVoid, cLookErr, cBrowStat, lExact, lNear, ;
            searchFor

    searchFor = pThis.Value

    lExact = SET( "EXACT" ) = "ON"
    lNear = SET( "NEAR" ) = "ON"

    *----------------------------------------------
    *-- International, Translate these strings only
    *----------------------------------------------
    cLookErr  = [Lookup value not found in: ]
    cBrowStat = [Select the desired value and press Enter to choose it] 
    *--------------------------
    *-- End translation section
    *--------------------------

    lReturn = .F.
    SELECT (pThis.LookAlias)

    *------------------------------------------------
    *-- Does the value match one in the lookup table?
    *------------------------------------------------
    IF SEEK( m->searchFor )

        *------------------------------------------------------
        *-- Update and of the lookup table fields that might be
        *-- on the form.
        *------------------------------------------------------
        DO LookRef WITH ALIAS(), m->pThis

        *-------------------------------------------------
        *-- If "Copy corresponding fields" is active, then
        *-------------------------------------------------
        IF TYPE( "pThis.LookAll" ) = "L" .AND. pThis.LookAll

            *--------------------------------------------
            *-- Post the lookup table field values to the
            *-- corresponding fields in the main file
            *--------------------------------------------
            DO LookCopy WITH m->pThis

        ENDIF
        lReturn = .T.
    ELSE
        *-----------------------------------------------------------------
        *-- If "Look no help" is active, display the lookup failed message
        *-----------------------------------------------------------------
        IF TYPE( "pThis.LookNoHelp" ) = "L" .AND. pThis.LookNoHelp

            *-----------------------------------
            *-- Set up the error display message
            *-----------------------------------
            pThis.ValidErrorMsg = cLookErr + pThis.LookAlias

        ELSE
            *------------------------------------------------------
            *-- "Help no fill" is active, so build the Browse table
            *------------------------------------------------------
            DEFINE BROWSE LookUp
            Lookup.Top           =  pThis.Top + 2
            Lookup.Left          =  10
            Lookup.Key           =  "LookKey"
            Lookup.OnMouseDblClk =  "LookKey"
            Lookup.Sizeable      =  .T.
            Lookup.Moveable      =  .T.
            Lookup.MDI           =  .F.
            Lookup.Width         =  67
            Lookup.Alias         =  ALIAS()
            Lookup.StatusMessage =  m->cBrowStat
            Lookup.ProcFile      =  "LookKey.prg," + HOME() + "FormRun.dbo"
            Lookup.Action        = .F.

            *------------------------------------------------------
            *-- Re-seek with NEAR active and EXACT off to get close
            *------------------------------------------------------
            SET NEAR ON
            SET EXACT OFF
            SEEK ( m->searchFor )
            SET NEAR OFF
            SET EXACT ON

            *--------------------------------------------------------
            *-- Open the Browse as Modal so the user can pick a value
            *--------------------------------------------------------
            lVoid = LookUp.ReadModal()

            *--------------------------------------------
            *-- Did the use pick a value from the Browse?
            *--------------------------------------------
            IF LookUp.Action

                *-------------------------------------------------
                *-- Get the value from the lookup table and put it
                *-- in the trigger entryfield value.
                *-------------------------------------------------
                pThis.Value = EVAL( pThis.LookAlias + "->" + pThis.LookField )

                *------------------------------------------------------
                *-- Update and of the lookup table fields that might be
                *-- on the form.
                *------------------------------------------------------
                DO LookRef WITH ALIAS(), m->pThis

                *-------------------------------------------------
                *-- If "Copy corresponding fields" is active, then
                *-------------------------------------------------
                IF TYPE( "pThis.LookAll" ) = "L" .AND. pThis.LookAll

                    *--------------------------------------------
                    *-- Post the lookup table field values to the
                    *-- corresponding fields in the main file
                    *--------------------------------------------
                    DO LookCopy WITH m->pThis

                ENDIF
                lReturn = .T.
            ELSE

                *-----------------------------------
                *-- Set up the error display message
                *-----------------------------------
                pThis.ValidErrorMsg = cLookErr + pThis.LookAlias

            ENDIF
        ENDIF
    ENDIF

    *----------------------------
    *-- Reset NEAR and EXACT back
    *----------------------------
    IF m->lNear
        SET NEAR ON
    ELSE
        SET NEAR OFF
    ENDIF

    IF m->lExact
        SET EXACT ON
    ELSE
        SET EXACT OFF
    ENDIF

    SELECT ( pForm.CurrMast )

#include "talkon.hdb"
RETURN lReturn
*-- EOF: LookVal(  )




