
*.............................................................................
*
*   Program Name: FLDLEN.PRG          Copyright: Borland International
*   Date Created: 02/17/94             Language: dBASE 5.0
*   Time Created: 19:50:33               Author: Borland dBASE R&D
*   /brief/library.src
*.............................................................................


*................................................................
* Function Name:    FldLen
* Parameters:       cFldName, field name
* Ext Memvars:      None
* Return Value:     Numeric, length of field
* Description:      Calculates and returns the length of a field
*................................................................
FUNCTION FldLen
PARAMETERS cFldName
    PRIVATE cType, nFldLen

    cType = TYPE(cFldName)
    
    nFldLen = 0

    DO CASE
        CASE cType = "C"
            nFldLen = LEN(EVALUATE(cFldName))
        CASE cType = "N" .OR. cType = "F"
            nFldLen = LEN(TRANSFORM(&cFldName., "@L"))
        CASE cType = "D"
            nFldLen = IIF(SET("CENTURY") = "ON", 10, 8)
        CASE cType = "M"   
            nFldLen = 4
        CASE cType = "L"    
            nFldLen = 1
    ENDCASE
RETURN nFldLen







