FUNCTION FileType
PARAMETER pc_fname
*--------------------------------------------------------------------
* NAME
*   FileType - Returns extension of a file name or spec.
*
* SYNOPSIS
*   FileType( pc_fname )
*
* DESCRIPTION
*   FileType() returns the extension of the file name
*   specified by pc_fname.  It may be up to three
*   characters long.
*
*   The file name may be preceded by a DOS file path.
*
*   The current implementation will return all upper-
*   case letters.
*
* PARAMETER
*   pc_fname - A character file name or DOS file spec.
*
* EXAMPLE
*   lc_ext = FileType( "C:\TEST\FOO.PRG" )
*     ( lc_ext will equal "PRG" )
*
*   lc_ext = FileType( "MYFILE.XX" )
*     ( lc_ext will equal "XX" )
*
* SEE ALSO
*   _FILEDRV(), _FILEPATH(), _FILEROOT()
*
*--------------------------------------------------------------------
    PRIVATE ln_dotpos, ln_lensrc, cResult

    ln_lensrc = LEN( m->pc_fname )
    ln_dotpos = RAT( ".", m->pc_fname )
    lc_slash = "\"
    nLastSlash = RAT( "\", m->pc_fName )

    DO CASE
        CASE m->ln_dotpos = 0              && No extension
            cResult = ""
        CASE m->nLastSlash > m->ln_dotpos     && The dot is part of the path
            cResult = ""
        OTHERWISE
            cResult = UPPER( SUBSTR(  m->pc_fname, m->ln_dotpos + 1 ) )
            IF LEN( m->cResult ) > 3 .AND. m->lc_slash = "\"
                cResult = LEFT( m->cResult, 3 )
            ENDIF
    ENDCASE

RETURN m->cResult
*-- EOF: FileType( pc_fname )

