mFormOpen=.F.
DEFINE FORM mTemp PROPERTY VISIBLE .F.
lVoid = mTemp.OPEN()
mDesk = mTemp.PARENT
lVoid = mTemp.CLOSE()

mFormName=SPACE(8)
mActive=mDesk.ActiveControl()
IF TYPE("mActive.ClassName")="C"
    mClass=mActive.ClassName
    IF mClass="FORM"
        mFormName=mActive.Name
        mFormOpen=.T.
    ENDIF
ENDIF


PUBLIC NewRecord
#include "employee.dfm"

NewRecord = .F.       && Initialize Global Variable
    emp.Action = .F.
    lVoid = Emp.Open()


RETURN
*****************
PROCEDURE OpenEmp
    PRIVATE lOpen

    lOpen = .T.     &&   is .DBF already open (assume .T.)?

    IF SUBSTR(DBF(),3)<>"EMPLOYEE.DBF"
        SELECT SELECT()
        USE Employee ORDER LASTNAME ALIAS Employee
        lOpen = .F.     &&   .DBF was NOT already open
    ELSE
        SET ORDER TO LASTNAME
    ENDIF
    GO TOP

    This.lOpen = lOpen   &&   save lOpen to form

    lVoid = This.Refresh()
    Lvoid = This.Last.SetFocus()

    IF .NOT. mFormOpen
        Main.F1.CloseAll.Enabled=.F.
        Main.S.Srch.Enabled=.T.
        Main.S.Tp.Enabled=.T.
        Main.S.Btm.Enabled=.T.
        Main.S.Pck.Enabled=.F.
        Main.S.Indx.Enabled=.F.
        Main.E.Undo.Enabled=.T.
        Main.E.Save.Enabled=.T.
        Main.V.Frm.Enabled=.F.
        Main.F1.Bac.Enabled=.F.
        Main.App.Inv.Enabled=.F.
    ENDIF
    Main.App.Emp.Enabled=.F.

RETURN
******************
PROCEDURE CloseEmp
    IF This.Action
        lVoid = This.Submit()
    ELSE
           IF This.Modified()
            DO ErrorMsg WITH "Exit Employee Form ..."
           ENDIF
    ENDIF

    IF .NOT. This.lOpen     &&   If file wasn't already open on startup
        USE IN EMPLOYEE     &&   shut it down
    ENDIF


    lVoid = Emp.Release()

    mFormOpen=.F.
    DEFINE FORM mTemp PROPERTY VISIBLE .F.
    lVoid = mTemp.OPEN()
    mDesk = mTemp.PARENT
    lVoid = mTemp.CLOSE()

    mFormName=SPACE(8)
    mActive=mDesk.ActiveControl()
    IF TYPE("mActive.ClassName")="C"
        mClass=mActive.ClassName
        IF mClass="FORM"
            mFormName=mActive.Name
            mFormOpen=.T.
        ENDIF
    ENDIF
    IF .NOT. mFormOpen
        Main.F1.CloseAll.Enabled=.T.
        Main.S.Srch.Enabled=.F.
        Main.S.Tp.Enabled=.F.
        Main.S.Btm.Enabled=.F.
        Main.S.Pck.Enabled=.T.
        Main.S.Indx.Enabled=.T.
        Main.E.Undo.Enabled=.F.
        Main.E.Save.Enabled=.F.
        Main.V.Frm.Enabled=.T.
        Main.F1.Bac.Enabled=.T.
        Main.App.Inv.Enabled=.T.
    ENDIF
    Main.App.Emp.Enabled=.T.


    RELEASE Emp
RETURN
******************
FUNCTION DupCheck
    If NewRecord

        SEEK(This.Value)
        IF FOUND()
            DO ErrorMsg WITH "Duplicate Found, Try Again..."+trim(SearchFor)
            RETURN .F.
        ELSE
            Newrecord = .f.
        ENDIF
    Endif
RETURN .T.
******************
FUNCTION FindLast

    * Generate a form that will can be used by other procedures
    DO GenForm

    * Set focus to the entryfield
    lVoid = Search.sValue.SetFocus()

    * Modal form, forcing user to answer before moving on
    lVoid = Search.ReadModal()


RETURN .T.
**********************
PROCEDURE GenForm
    * Define a search form
    DEFINE FORM Search FROM 5,10 TO 11,45 ;
        PROPERTY ;
            Text "Search"

    DEFINE TEXT sVal OF Search AT 1,5 ;
        PROPERTY ;
            Text "Last :"
    DEFINE ENTRYFIELD Svalue OF Search AT 1,12 ;
        PROPERTY ;
            Width 15
    DEFINE PUSHBUTTON sOk OF Search AT 3,12 ;
        PROPERTY ;
            Text "OK",;
            Width 10  ,;
				Default .T. ,;
            OnClick "CloseMe"
RETURN
*******************
PROCEDURE CloseMe

    * Get value user entered before closing form
    SearchFor = Search.Svalue.value
    SearchWidth = Search.Width  && See if size is Less than 50

    lVoid = Search.Close()

    * remove from memory
    lVoid = Search.Release()

    *Now Search for value given - Exact match
    IF LEN(SearchFor) > 0         && verify not blank
        SEEK(TRIM(SearchFor))

        IF FOUND()
            Emp.StatusMessage = "Found Last name = "+trim(SearchFor)
            * repaint the form with the current record
            lVoid = Emp.Refresh()
        ELSE
            DO Errormsg WITH "Employee Last Name Not Found ..."+trim(SearchFor)
        ENDIF

    ENDIF
RETURN

******************
PROCEDURE PrevHand

    * Check to see that the record pointer is not at Beginning of File
    IF .NOT. BOF()
        IF Form.Modified()
            lVoid = Form.Submit()
        ENDIF
        SKIP -1

        DO RadioUpd   && see if the form has radiobuttons and update

        IF DELETED()
           Form.cStatus.Text = "DELETED"
        ELSE
           Form.cStatus.Text = ""
        Endif
        lVoid = Form.Refresh()
    ELSE
        DO ErrorMsg WITH "Top of file!"
    ENDIF
    Form.Action = .F.
RETURN

*******************
PROCEDURE SkipHand

    * Check to see that the record pointer is not end of file
    IF .NOT. EOF()
        IF Form.Modified()
            lVoid = Form.Submit()
        ENDIF
        SKIP

        DO RadioUpd    && update radiobuttons

        * Show user if the record is marked for deletion
        IF DELETED()
           Form.cStatus.Text = "DELETED"
        ELSE
           Form.cStatus.Text = ""
        Endif
        lVoid = Form.Refresh()
    ELSE
        * Record pointer is at the end of file, tell user
        DO ErrorMsg WITH "End of file encountered!"
    ENDIF
    Form.Action = .F.

RETURN
*********************
PROCEDURE RadioUpd
        DO CASE
            CASE Department = "SALES"
                Form.Sales.value = .T.
            CASE Department = "EXECUTIVE"
                Form.Exec.value = .T.
        OTHERWISE
            Form.Sales.value = .F.
            Form.Exec.value = .F.
        ENDCASE
        DO CASE
            CASE Specialty = "ADMIN"
                Form.admin.value = .T.
            CASE Specialty = "COMMERCIAL"
                Form.commer.value = .T.
                CASE Specialty = "RESIDENTIAL"
                Form.Resid.value = .T.
        OTHERWISE
            Form.admin.value = .F.
            Form.commer.value = .F.
            Form.Resid.value = .F.
        ENDCASE

        * set focus back into the Last Name field
        lVoid = Form.Next1.SetFocus()

RETURN

******************
PROCEDURE Add_new
    NewRecord = .T.

    *Write data to disk
    lvoid = Form.submit()

    * Append a record
    *APPEND BLANK
    GO BOTT
    SKIP

    *Refresh Screen Data
    lvoid = Form.refresh()
RETURN
******************
PROCEDURE DelIt && Marks record for deletion
    IF DELETED()
      Form.cStatus.Text = ""
      RECALL
    ELSE
      Form.cStatus.Text = "DELETED"
      DELETE
    ENDIF

RETURN
*****************
PROCEDURE CanHand
    Form.Action = .F.
    lVoid = Form.Close()
RETURN
*****************
PROCEDURE RePaint
    SELE Employee
    lVoid = Emp.Refresh()
RETURN
******************
PROCEDURE PrintForm

DEFINE FORM Prt FROM 5,25 TO 16,50 ;
    PROPERTY ;
        TEXT "Print Form"

DEFINE TEXT t1 OF Prt AT 1,1 ;
    PROPERTY ;
        Text "Type :",;
        COLORNORMAL "R/W"

DEFINE RADIOBUTTON Rep OF Prt AT 2,1 ;
    PROPERTY ;
        Text "Report",;
        Group .T.,;
        COLORNORMAL "N/W",;
        WIDTH 15

DEFINE RADIOBUTTON Lab OF Prt AT 3,1 ;
    PROPERTY ;
        Text "Labels",;
        Group .F.,;
        COLORNORMAL "N/W",;
        WIDTH 15

DEFINE TEXT T3 OF Prt AT 9,5 ;
    PROPERTY ;
        TEXT "PRINTING ..." ,;
        VISIBLE .F.,;
        WIDTH 15

DEFINE PUSHBUTTON P1 OF Prt AT 8,12 ;
    PROPERTY ;
        TEXT "&Ok",;
        ONCLICK "RunRep",;
        Width 10

DEFINE PUSHBUTTON P2 OF Prt AT 8,2 ;
    PROPERTY ;
        TEXT "&Cancel",;
        ONCLICK "CanHand",;
        Width 10

lVoid = Prt.Open()

******************
PROCEDURE Runrep

* Check for Labels or Reports
    DO CASE
        CASE Form.Rep.Value
             * display to user something is happening
             Form.T3.Visible = .t.
             REPORT FORM Employee TO PRINTER
        CASE Form.Lab.Value
             * display to user something is happening
             Form.T3.Visible = .t.
             LABEL FORM Employee TO PRINTER

    ENDCASE
    lVoid = Form.Close()
    lVoid = Form.Release()
RETURN


