PROCEDURE MRowCol
*--------------------------------------------------------------------
* DESCRIPTION
*   MRowCol displays how to use MROW() and MCOL() for determining
*   the location of the mouse cursor.  MRowCol will display the
*   coordinates for any mouse clicks.  To exit, click on the colored
*   Quit button or press Q.
*--------------------------------------------------------------------

  SET TALK OFF
  SET ESCAPE OFF
  SET TRAP OFF

  IF ISMOUSE()
    *-- Set up the display window
    SET COLOR TO w+/b
    CLEAR
    @ 3, 26 TO 8, 54 DOUBLE
    @ 4, 29 SAY "Last mouse click at:"
    @ 5, 30 SAY "MRow(): "
    @ 6, 30 SAY "MCol(): "
    @ 10, 36 SAY "  Quit  " COLOR w+/g
    lQuit = .F.
    DO WHILE .NOT. lQuit
      SET CONSOLE OFF
      SET CURSOR OFF
      WAIT                              && Wait for a mouse click
      SET CURSOR ON
      SET CONSOLE ON
      nMRow = MRow()                    && Capture the mouse row and
      nMCol = MCol()                    && column as soon as possible
      nLKey = LASTKEY()
      IF nLKey = 81 .OR. nLKey = 113    && If 'Q' or 'q'
        lQuit = .T.
      ELSE
        *-- Check for a click on the Quit button
        IF nMRow = 10 .AND. nMCol >= 36 .AND. nMCol <= 43
          lQuit = .T.                   && If so, signal an exit
        ENDIF
      ENDIF
      *-- Display the row and column of the click
      @ 5, 38 SAY STR( nMRow, 2 )
      @ 6, 38 SAY STR( nMCol, 2 )
    ENDDO
  ENDIF
  SET TALK ON
  SET ESCAPE ON
  SET TRAP ON
  CLEAR

RETURN
*-- EOP: MRowCol

