PROCEDURE MoveWin
*--------------------------------------------------------------------
* DESCRIPTION
*   MoveWin demonstrates a technique that you can use to move
*   a window around the screen using the mouse.
*--------------------------------------------------------------------

  SET TRAP OFF
  SET ESCAPE OFF
  SET TALK OFF
  SET CURSOR OFF
  SET COLOR TO W+/B
  SET STATUS OFF
  nRow = 5                              && Top row for window
  nCol = 10                             && Left column for window
  nWidth = 40                           && Width of window
  nHigh = 10                            && Height of window
  DEFINE WINDOW Foo FROM nRow, nCol TO nRow + nHigh, nCol + nWidth NONE COLOR n/w
  ACTIVATE WINDOW Foo
  @ 0,0 TO nHigh,nWidth  DOUBLE COLOR w+/w

  *------------------------
  *-- Close Icon for window
  *------------------------
  @ 0, 2 SAY "[ ]" COLOR w+/w
  @ 0, 3 SAY CHR( 254 ) COLOR g+/w

  *--------------------------------
  *-- Display the usage information
  *--------------------------------
  @ 1,1 SAY " Click on top border to start move,"
  @ 2,1 SAY " then click to anchor the window."
  @ 3,1 SAY " Click on close icon or press"
  @ 4,1 SAY " Esc when done."

  nMess = 0
  DO WHILE nMess <> 27                  && Loop until Esc or click on Icon

    DO MSDummy                          && Remove when LASTKEY() = -100
                                        && is fully implimented
    SET CONSOLE OFF
    WAIT                                && Wait for a mouse click,
    SET CONSOLE ON
    nMess = LASTKEY()                   && Get the last key or mouse click
    nMRow = MROW()                      && Capture the mouse row and column
    nMCol = MCOL()
    IF nMess <= -100                    && If a mouse click occured
      IF nMRow = nRow                   && Check to see if its on the top row
        IF nMCol >= nCol + 2 .AND. nMCol <= nCol + 4
          nMess = 27                    && Click was on the Close Icon
        ELSE                            && so, signal loop to exit
          IF nMCol >= nCol .AND. nMCol <= nCol + nWidth
            *-- Start the move window action
            @ 0,0 TO nHigh,nWidth DOUBLE COLOR w+/w*
            nDelX = nMRow
            nDelY = nMCol
            SET CONSOLE OFF
            WAIT                        && Wait for the "Drop" click
            SET CONSOLE ON
            nMRow = MROW()              && Capture the Mouse row and
            nMCol = MCOL()              && column for the new location
            nDelX = nMRow - nDelX       && Determine the difference in the
            nDelY = nMCol - nDelY       && cursor position for the move
            lMoveOk = .T.               && Error flag for Move Window command
            ON ERROR lMoveOk = .F.      && If an error occurs, set error flag
            MOVE WINDOW Foo BY nDelX, nDelY
            IF lMoveOk                  && If the move was Ok, update
              nRow = nRow + nDelX       && the new top row and left
              nCol = nCol + nDelY       && column coordinates for the window
            ENDIF
            *-- Redraw the natural border
            @ 0,0 TO nHigh, nWidth DOUBLE COLOR w+/w
            *-- Redisplay the Close Icon for window
            @ 0, 2 SAY "[ ]" COLOR w+/w
            @ 0, 3 SAY CHR( 254 ) COLOR g+/w
          ENDIF
        ENDIF
      ENDIF
    ENDIF
  ENDDO

  RELEASE WINDOW FOO
  SET CURSOR ON
  SET TRAP ON
  SET ESCAPE ON
  SET TALK ON

RETURN
*-- EOP: MoveWin


PROCEDURE MSDummy
*--------------------------------------------------------------------
* DESCRIPTION
*   Remove this procedure when LASTKEY() = -100 after a mouse click
*   is implimented in dBASE.
*--------------------------------------------------------------------
  SET CONSOLE OFF
  KEYBOARD "{Alt-1}"
  WAIT
  SET CONSOLE ON
RETURN
*-- MSDummy

