******************************************************************************
* PROGRAM NAME: HELPER.PRG
*               PROCEDURES TO DISPLAY MENU HELP FOR BUSINESS PROGRAMS
*               SAMPLE BUSINESS APPLICATION PROGRAM
* LAST CHANGED: 09/25/89 09:26AM
* WRITTEN BY:   Borland International Inc.
******************************************************************************

* Main procedure 
PROCEDURE Helper

    * Define help screen colors
    IF ISCOLOR()
    c_help = "B/BG,GR+/G"
    ELSE
    c_help = "W+/N,W/N"
    ENDIF

    * Define the help window
    DEFINE WINDOW Helpscr FROM 0,0 TO 24,79 PANEL COLOR &c_help.
    ACTIVATE WINDOW Helpscr
    CLEAR
    * The current popup menu determines which help screen is displayed
    DO CASE
    CASE POPUP() = "MAINMENU"        && Help for the Business Menu
        DO Help_main
    CASE POPUP() = "RPT_MNU"         && Help for the Report Menu
        DO Help_rept
    CASE POPUP() = "DEST_MNU"        && Help for the Destination Menu
        DO Help_dest
    CASE POPUP() = "MAIN_MNU"        && Help for the Option Menu
        DO Help_opti
    CASE POPUP() = "BACKMENU"        && Help for the Back up/Restore Menu
        DO Help_back
    ENDCASE
    WAIT SPACE(24) + "Press any key to return to menu."
    CLEAR
    DEACTIVATE WINDOW Helpscr
    RELEASE WINDOW Helpscr
RETURN
*========================== end of main procedure ============================

PROCEDURE Help_main
* Display help screen for the Business Main Menu
TEXT
    HELP FOR THE MAIN MENU 
   
    Selection             Purpose
      
    EMPLOYEES             Employee subapplication
    CUSTOMERS             Customer subapplication
    VENDORS               Vendors subapplication
    INVENTORY             Inventory subapplication
    ORDERS                Orders subapplication
    ACCOUNTS RECEIVABLE   Accounts Receivable subapplication
    AREA CODES            Area Codes subapplication

                                  Utilities 

    PRINT INVOICES        Print invoices from orders
    BACK UP/RESTORE DATA  Back up or restore business data files
    RETURN TO dBASE       Quit application and return to dot prompt
                             or Control Center
    QUIT TO DOS           Quit application and return to operating system
   

ENDTEXT
RETURN

PROCEDURE Help_opti
* Display help screen for the Option Menu
TEXT
    HELP FOR THE OPTION MENU 
   
    Selection          Purpose
        
    Add  record        Add new record to database
    Edit record        Edit the current record
    Delete record      Delete current record from the database
    Next record        skip to Next record
    Previous record    skip to Previous record
    Top record         go to Top of database
    Bottom record      go to Bottom of database
    Skip records       Skip fwd or backwards by an entered # of records
    Find record        Find a record using key field search
    List records       List data to screen beginning with current record
    Output reports     Print or display reports and labels
    Group records      Specify filter condition to view selective records
    Count records      Count number of records in database
    Index database     create/rebuild Indexes
    Quit               Quit from subapplication screen to MAIN MENU
   

ENDTEXT
RETURN

PROCEDURE Help_rept
* Display help screen for the Reports Menu
TEXT


      HELP FOR THE REPORTS MENU 
     

      Selection               Purpose
           
      Database Report         Report data from database file

      Mailing List            Print mailing labels

      Customed programmed     Execute a custom report program
      report                  (not available for some subapplications)

      Exit to OPTION MENU     Return to the OPTION MENU without printing

     




ENDTEXT
RETURN

PROCEDURE Help_dest
* Display help screen for the Option Menu
TEXT



      HELP FOR THE DESTINATION MENU 
     

      Selection              Purpose
          
      Printer                List to the current printer

      File                   Output to a file for later printing

      Screen                 List report on the screen

      Exit to OPTION MENU    Return to the OPTION MENU without printing

     




ENDTEXT
RETURN

PROCEDURE Help_back
* Display help screen for the Back up/Restore Menu
TEXT



       HELP FOR THE BACK UP/RESTORE MENU 
      
                                                                    
       Selection                  Purpose
               
       Back up your data          Save database files and indexes on 
       to floppy disks            floppy disks

       Restore your data          Copy database files and indexes from
       from floppy disks          floppy disks on to your hard disk

       Exit to the Main Menu      Return to the MAIN MENU

      




ENDTEXT
RETURN
**************************** END OF HELPER.PRG *******************************
