******************************************************************************
* PROGRAM NAME: GOODS.PRG
*               INVENTORY DATABASE SCREEN
*               SAMPLE BUSINESS APPLICATION PROGRAM
* LAST CHANGED: 09/25/89 09:26AM
* WRITTEN BY:   Borland International Inc.
******************************************************************************
*
*       FILES USED:
*       Database file      =  Goods.dbf  (Inventory file)
*       Index file         =  Goods.mdx
*           TAG: Part_id   =  part_id   <= Master index
*           TAG: Vendor_id =  vendor_id
*       External procedure file = Library.prg
******************************************************************************

* Main procedure
PROCEDURE Goods

   * Link to external procedure file of "tool" procedures
   SET PROCEDURE TO Library

   * Set up database environment
   DO Set_env

   SET COLOR TO &c_standard.

   * Declare variables used:
   * Database memory variables
   STORE ""  TO part_id, part_name, descript, vendor_id, comments
   STORE 0   TO price, cost, qty_onhand, qty_2order, lead_time
   discontinu = .F.

   * Miscellaneous variables - used to pass parameters to Library
   dbf      = "GOODS"                    && Standard report is available
   mlist    = "NOT AVAILABLE"            && No mailing list available
   cust_rpt = "N/A"                      && No custom reports available
   STORE "m->part_id" TO key, key1
   STORE "NONE" TO key2, key3
   keyname1 = "Part ID:"
   STORE "" TO keyname2, keyname3, mvendorid
   list_flds = "PART_ID, PART_NAME, QTY_ONHAND"

   * Open database files and choose active index files
   SELECT 1
   USE Goods ORDER Part_id
   GO TOP
   * Used for vendor data lookup
   USE Vendors ORDER Vendor_id IN 2

   record_num = RECNO()
   DO Load_fld

   * Show data screen
   CLEAR
   DO Dstatus
   DO Backgrnd
   DO Show_data

   * Define popup menus
   DO Bar_def

   * Activate main popup menu - execute user choices
   SET COLOR TO &c_popup.
   ACTIVATE POPUP main_mnu
   DO Sub_ret
   *
RETURN
*======================== end of main procedure ==============================

*  UTILITY PROCEDURES (Proprietary to Goods.prg)

PROCEDURE Filter
   * Filter (group) data into subset
   * Select subset to set up filter condition (Y=turn on, N=abort selection,
   * T=turn off). If filter is already on, set default choice to T, show 
   * window. If filter is not on, set default choice to Y, show window.
   choice = IIF(filters_on,"T","Y")
   DO Filt_ans
   IF choice = "Y"
      * Start process of choosing filter condition
      mvendorid  = SPACE(4)
      ACTIVATE WINDOW alert
         * Get user's filter condition selection(s)
         @  0, 0 SAY "-------- ENTER FILTER CONDITION --------"
         @  2, 0 SAY "VENDOR ID:" GET mvendorid FUNCTION "9"
         READ
      DEACTIVATE WINDOW alert
      *
      * Check whether data entered into subset string
      IF "" = TRIM(mvendorid)
         filters_on = .F.
         DO Warnbell
      ELSE
         * Filter on entered filter string condition
         SET FILTER TO vendor_id = TRIM(mvendorid)
         * Activate filter by moving record pointer
         GO TOP
         * Check whether filter condition matches any records (no match=EOF)
         filters_on = .NOT. EOF()   && Filter is turned on if .T.
         IF .NOT. filters_on
            * Turn off filter if no matching records found
            DO Warnbell
            DO Show_msg WITH "No Goods (inventory) records match the " + ;
                             "filter condition"
            SET FILTER TO
            GO record_num
         ENDIF
      ENDIF
   ELSE
      IF choice = "T"
         * If user selects "T", turn off filter
         SET FILTER TO
         filters_on = .F.
      ENDIF
   ENDIF
RETURN

PROCEDURE Indexer
   * Create/rebuild indexes
   INDEX ON vendor_id TAG Vendor_id
   INDEX ON part_id   TAG Part_id
   GO TOP
RETURN

PROCEDURE Init_fld
   * Initialize memory variable values for data entry
   part_id   = SPACE(10)
   STORE SPACE(30) TO part_name, descript, comments
   STORE 0 TO qty_onhand, cost, price, qty_2order, lead_time
   vendor_id = SPACE(4)
RETURN

PROCEDURE Load_fld
   * Load field values from Goods database record into memory variables
   part_id    = part_id
   part_name  = part_name
   descript   = descript
   qty_onhand = qty_onhand
   cost       = cost
   price      = price
   qty_2order = qty_2order
   vendor_id  = vendor_id
   lead_time  = lead_time
   comments   = comments
RETURN

PROCEDURE Repl_fld
   * Replace database fields with values of current memory variables
   REPLACE part_id WITH m->part_id, part_name WITH m->part_name, ;
           descript WITH m->descript, qty_onhand WITH m->qty_onhand, ;
           cost WITH m->cost, price WITH m->price, ;
           qty_2order WITH m->qty_2order, vendor_id WITH m->vendor_id, ;
           lead_time WITH m->lead_time, comments WITH m->comments
RETURN

PROCEDURE Backgrnd
   * Show background screen
   * Draw and fill in boxes
   @  1,17 TO  3,46 DOUBLE COLOR &c_blue.
   @  5, 2 TO  7,30 DOUBLE COLOR &c_red.
   @  2,18 FILL TO  2,45   COLOR &c_blue.
   @  6, 3 FILL TO  6,29   COLOR &c_red.
   @  9, 3 FILL TO 18,54   COLOR &c_red.
   @ 13, 3 TO 13,54        COLOR &c_red.
   @  8, 2 TO 19,55        COLOR &c_red.
   SET COLOR TO &c_data.
   @  2,19 SAY "GOODS (INVENTORY) DATABASE"
   @  6, 4 SAY "PART NO.:"
   @  9, 4 SAY "NAME:"
   @ 10, 4 SAY "DESCRIPTION:"
   @ 11, 4 SAY "SALES PRICE:"
   @ 12, 4 SAY "QUANTITY ON HAND:"
   @ 12,32 SAY "DISCONTINUED:"
   @ 14, 4 SAY "VENDOR NUMBER:"
   @ 15, 4 SAY "COST:     $"
   @ 16, 4 SAY "QUANTITY TO ORDER:"
   @ 16,29 SAY "(minimum/batch)"
   @ 17, 4 SAY "LEAD TIME:"
   @ 17,20 SAY "(in days)"
   @ 18, 4 SAY "COMMENTS:"
   SET COLOR TO &c_standard.
RETURN

PROCEDURE Show_data
   * Show screen for data entry
   SET COLOR TO &c_fields.
   @  6,15 SAY part_id
   @  9,17 SAY part_name
   @ 10,17 SAY descript
   @ 11,17 SAY price      PICTURE  "99,999.99"
   @ 12,22 SAY qty_onhand PICTURE  "9,999"
   @ 12,46 SAY discontinu PICTURE  "Y"
   @ 14,19 SAY vendor_id
   @ 15,16 SAY cost       PICTURE  "99,999.99"
   @ 16,23 SAY qty_2order PICTURE  "9,999"
   @ 17,16 SAY lead_time  PICTURE  "999"
   @ 18,16 SAY comments
   SET COLOR TO &c_standard.
RETURN

PROCEDURE Get_data
   * Show screen for data entry
   SET COLOR TO &c_data.
   @  6,15 GET m->part_id    FUNCTION "!" ;
           VALID Duplicat(&key.) ;
           ERROR "Duplicate part ID number, please re-enter" ;
           MESSAGE "Enter a part ID number, or Esc to quit"
   @  9,17 GET m->part_name  FUNCTION "!" ;
           MESSAGE "Enter the name of the part"
   @ 10,17 GET m->descript   FUNCTION "!" ;
           MESSAGE "Enter a description of the part"
   @ 11,17 GET m->price      PICTURE  "99,999.99" ;
           MESSAGE "Enter the selling price of this part"
   @ 12,22 GET m->qty_onhand PICTURE  "9,999" ;
           MESSAGE "Enter how many of these parts are in current inventory"
   @ 12,46 GET m->discontinu PICTURE  "Y" ;
           MESSAGE "Is the part now discontinued (Y/N)"
   @ 14,19 GET m->vendor_id  FUNCTION "9" ;
           VALID Lookupid((m->vendor_id),"Vendors", "Vendor",1) ;
           ERROR "Invalid vendor ID number, please re-enter" ;
           MESSAGE "Enter a vendor ID number, or Esc to quit"
   @ 15,16 GET m->cost       PICTURE  "99,999.99" ;
           MESSAGE "Enter the cost of the part"
   @ 16,23 GET m->qty_2order PICTURE  "9,999" ;
           MESSAGE "Enter the minimum quantity which can be ordered"
   @ 17,16 GET m->lead_time  PICTURE  "999" ;
           MESSAGE "Enter the lead time before vendor " + ;
                   "typically ships the parts"
   @ 18,16 GET m->comments   FUNCTION "!" ;
           MESSAGE "Enter any comments on this part"
   SET COLOR TO &c_standard.
   ON KEY LABEL F9 DO Findvend WITH m->vendor_id
RETURN

*********************************** END OF GOODS.PRG *************************

