*****************************************************************************
* PROGRAM NAME: EMP_REPT.PRG
*               SAMPLE CUSTOM REPORT - EMPLOYEES
*               SAMPLE BUSINESS APPLICATION PROGRAM
* LAST CHANGED: 01/05/89 03:36PM
* WRITTEN BY:   Borland International Inc.
*****************************************************************************
*            FILES USED:
*            Database = Employee.dbf
*            Indexed  = Employee.mdx
*              Tag used: Dept  (department+lastname+firstname+initial)
*****************************************************************************
ll_print = SET( "PRINTER" ) = "ON"

SET ORDER TO Dept
GO TOP

ON ESCAPE print_flag = .F.   && If user presses Esc during printing, exit

* Set up environment
SET CENTURY ON

* Initialize variables
rpt_level   =  1               && Current report level being processed
print_flag  = .T.              && Continue printing flag
on_pg_line  =  0               && Line at which ON PAGE works
STORE 0 TO pageno, salary_sum, salary_gt, number_emp, yrsexp_sum, yrsexp_avg
group_brk = ""
p_title = "Human Resources Report"

* Store line number to break page on
on_pg_line = _plength - 5      && Page height minus footer and bottom margin

* Store current environment settings
mplength  = _plength
mploffset = _ploffset
mlmargin  = _lmargin
mrmargin  = _rmargin
mwrap     = _wrap
mpeject   = _peject

_pageno   = 1                  && Force internal page number to 1

IF ll_print
   mppitch   = _ppitch
ENDIF

* Set report characteristics
*_plength  = 66
_ploffset = 0
_lmargin  = 0
_rmargin  = 80
_plineno  =  1
_wrap     = .F.
_peject   = "AFTER"
IF ll_print
   _ppitch   = "PICA"
ENDIF

* Set up line number where page break procedure executes
ON PAGE AT LINE on_pg_line DO Pg_break

*================================ Begin Print Job ===========================
PRINTJOB
   * Print page heading
   DO Title
   DO Pg_head
   DO Brk_head
   GO TOP
   *============ File loop - process records in index order to end of file ==
   *                    or until user presses Esc (print_flag = .F.)
   SCAN WHILE print_flag
      IF group_brk <> department
         * Department changed, print break info
         rpt_level = 1
         DO Brk_data
         DO Reinit
         DO Brk_head
      ELSE
         * Department did not change
         rpt_level = 0
      ENDIF
      * Print detail lines
      DO Detail
      * Perform break summary calculations
      DO Det_calc
   ENDSCAN
   *
   IF print_flag
      DO Brk_data     && End of file, user did not press Esc to stop printing
   ENDIF
   * Finish report
   DO Rpt_end
   ON PAGE AT LINE on_pg_line DO Pg_foot
   EJECT PAGE
ENDPRINTJOB
*================================ End of Print Job ==========================

* Reset environment
_wrap     = mwrap
_peject   = mpeject
_plength  = mplength
_ploffset = mploffset
_lmargin  = mlmargin
_rmargin  = mrmargin
IF ll_print
   _ppitch   = mppitch
ENDIF

ON ESCAPE
ON PAGE
SET CENTURY OFF
SET ORDER TO TAG Names
RETURN

************************** END OF MAIN REPORT PROCEDURE *********************

* UTILITY PROCEDURES

PROCEDURE Brk_data
   * Print calculated data at department break
   ?
   ?? "HEADCOUNT:" STYLE "B" AT 0
   ?? number_emp   PICTURE "999"
   ?? "TOTAL:"     STYLE "B" AT 36
   ?? "  $" AT 44
   ?? salary_sum   PICTURE "999,999.99"
   ?? " "
   ?? "AVG:"       STYLE "B" AT 59
   ??  yrsexp_avg  PICTURE "99.9"
   ?? " yrs"
   ? "AVG:"        STYLE "B" AT 36
   ?? "  $" AT 44
   ?? ROUND(salary_sum/number_emp,2)  PICTURE "999,999.99"
   ?
   * Accumulate salary totals
   salary_gt  = salary_gt + salary_sum
   * EJECT PAGE    && Uncomment if user wants each group to start on new page
RETURN

PROCEDURE Brk_head
   * Update break variable and print department break heading
   group_brk = department
   * Check whether current line is close to page footer (ON PAGE) location
   IF  _plineno + 8 > on_pg_line
      EJECT PAGE        && Start new page if too close
   ELSE
      ?
      ? "Department" STYLE "BU" AT 0 ,": " STYLE "B"
      ?? department  PICTURE "@T XXXXXXXXXXXXXXX"
      IF rpt_level = 0
         ?? " (Cont'd)" && Print continuation message if group continued
			               && from previous page
      ENDIF
      ?
      rpt_level = 0     && Reset level after printing department break 								&&
	                     && heading
	ENDIF
RETURN

PROCEDURE Det_calc
   * Calculate sums and averages for printing at department breaks
   number_emp = number_emp + 1                  && Employee count
   salary_sum = salary_sum + salary             && Salary summation
   yrsexp_sum = yrsexp_sum + yrs_exper          && Yrs experience summation
   yrsexp_avg = ROUND(yrsexp_sum/number_emp,1)  && Yrs experience average
RETURN

PROCEDURE Detail
   * Print report detail
   * Check whether current line is close to page footer (ON PAGE) location
   IF _plineno + 5 > on_pg_line
      * Use new page if too close
      EJECT PAGE
   ENDIF
   ?
   ?? lastname  PICTURE "@T XXXXXXXXXXXXXXX" AT 0
   ?? ", "
   ?? firstname PICTURE "XXXXXXXXXX"
   ?? title     PICTURE "XXXXXXXXXXXXXXX" AT 30
   ?? "  $"
   ?? salary    PICTURE "99,999.99" AT 48
   ?? yrs_exper PICTURE "99.9" AT 63
   ?? degree    PICTURE "XXX"  AT 73
   ?  emp_id    AT 0
   ?? specialty AT 30
   IF rate <> 0
      * Print rate only if rate is non-zero
      ?? rate   PICTURE "99.9" AT 48
      ?? " %"
   ENDIF
   ?
RETURN

PROCEDURE Pg_break
   * Page break logic - occurs when report line = on_pg_line
   DO Pg_foot
   IF _pageno >= _pepage   && Stop at ending page
      GO BOTTOM
      SKIP
      rpt_level = 0
      RETURN
   ENDIF
   * Print page header and column headings
   DO Pg_head
   DO Brk_head
RETURN

PROCEDURE Pg_foot
   * Print page footer
   pageno = "-" + LTRIM(STR(_pageno,3,0)) + "-"
   _wrap = .T.
   _alignment = "CENTER"
   ?
   ?
   ? pageno
   _wrap = .F.
   _alignment = "LEFT"
   EJECT PAGE
RETURN

PROCEDURE Pg_head
   * Print page header and column headings
   ?
   IF _pageno <> 1
      ?
      ? MDY(DATE()) AT 0
      ?? p_title AT (_rmargin - LEN(p_title))
   ENDIF
   ?
   ?
   DEFINE BOX FROM 0 TO 79 HEIGHT 4
   ?   "Name/"           STYLE "B" AT 1
   ??  "Title/"          STYLE "B" AT 30
   ??  "Salary/"         STYLE "B" AT 48
   ??  "Exper."          STYLE "B" AT 62
   ??  "Degree"          STYLE "B" AT 73
   ?   "Employee Number" STYLE "B" AT 1
   ??  "Specialty"       STYLE "B" AT 30
   ??  "Comm. Rate"      STYLE "B" AT 48
   ?
RETURN

PROCEDURE Reinit
   * Re-initialize summary and calculation variables at department breaks
   STORE 0 TO salary_sum, number_emp, yrsexp_sum, yrsexp_avg
RETURN

PROCEDURE Rpt_end
   * Print end-of-report summary data
   ?
   ?? "FACILITY TOTAL:" STYLE "B" AT 27
   ?? "  $" AT 42
   ?? salary_gt PICTURE "9,999,999.99"
RETURN

PROCEDURE Title
   * Print report title on page one only
   ?
   _wrap = .T.
   _alignment = "CENTER"
   ? "A-T  FURNITURE INDUSTRIES" STYLE "B"
   ? "PUMPKIN CENTER FACILITY"   STYLE "BU"
   ?
   ? "HUMAN RESOURCES REPORT - QUARTERLY MANAGEMENT MEETING"
   ?
   ? MDY(DATE())
   _wrap = .F.
   _alignment = "LEFT"
RETURN
********************************** END OF EMP_REPT.PRG **********************

