PROCEDURE BarCount
*--------------------------------------------------------------------
* DESCRIPTION
*   BarCount demonstrates the use of the new BARCOUNT() function
*   and the ON POPUP command.
*--------------------------------------------------------------------
  PRIVATE nBarCount
  SET TALK OFF
  SET COLOR TO W+/B
  SET STATUS OFF

  DEFINE WINDOW BarStat FROM 6, 20 TO 10, 78 DOUBLE
  ACTIVATE WINDOW BarStat
  @ 0,2 SAY "Popup status for: "
  @ 1,2 SAY "  On bar:     of"
  @ 2,2 SAY "  Prompt:"
  ACTIVATE SCREEN

  DEFINE POPUP FilePick FROM 3,5 PROMPT FILES LIKE *.dbf
  nBarCount = BARCOUNT( "FILEPICK" )    && Get the initial count of bars
  ON POPUP FilePick DO BarStat          && Display popup info during navigation
  ACTIVATE POPUP FilePick
  RELEASE WINDOW BarStat
  RELEASE POPUP FilePick
RETURN
*-- EOP: BarCount

PROCEDURE BarStat
*--------------------------------------------------------------------
* DESCRIPTION
*   BarStat is called using the ON POPUP command to display the
*   bar information as the user moves the cursor in the popup.
*--------------------------------------------------------------------
  ACTIVATE WINDOW BarStat
  @ 0,20 SAY POPUP()                    && Display popup name
  @ 1,12 SAY STR( BAR(), 3 )            && Display current bar number
  @ 1,19 SAY STR( nBarCount, 3 )        && Display total number of bars
  @ 2,12                                && Clear out the previous bar prompt
  @ 2,12 SAY LEFT( PROMPT(),35 )        && Display the current bar prompt
  ACTIVATE SCREEN
RETURN
*-- EOP: BarStat



