******************************************************************************
* PROGRAM NAME: AREACODE.PRG
*               AREACODE DATABASE SCREEN
*               SAMPLE BUSINESS APPLICATION PROGRAM
* LAST CHANGED: 06/20/90 08:00AM
* WRITTEN BY:   Borland International Inc.
******************************************************************************
*       FILES USED:
*       Database     =  Codes.dbf  (Area code file)
*       Index file   =  Codes.mdx
*         TAG: City  =  city  <= Master
*         TAG: Code  =  code
*       External procedure file = Library.prg
******************************************************************************
* Main procedure
PROCEDURE Areacode

   * Link to external procedure file of "tool" procedures
   SET PROCEDURE TO Library

   * Set up database environment
   DO Set_env

   SET NEAR on
   SET COLOR TO &c_standard.

   * Declare variables used:
   * Database memory variables
   city = SPACE(20)
   code = 0
   * Miscellaneous variables - used to pass parameters to Library
   STORE "CODES" TO dbf
   STORE "NOT AVAILABLE" TO mlist     && No mailing list available
   STORE "N/A" TO cust_rpt            && No custom reports available
   STORE "m->city" TO key, key1
   STORE "NONE" TO key2, key3
   keyname1 = "City:"
   STORE "" TO keyname2, keyname3
   list_flds = "CITY, CODE"
   mcode     = 0
   lookup_ok = .F.                    && lookup not applicable

   DO AreaCodeM

   RELEASE gl_MainMenu                  && Allow Rest_env to reset the
   DO Rest_env                          && environment back.
   ON ERROR
   ON KEY LABEL F1
   CLEAR ALL
   CLOSE ALL
   CLEAR

RETURN

PROCEDURE AreaCodeM

   * Open database file and choose active index
   SELECT 1
   USE Codes ORDER City
   GO TOP

   record_num = RECNO()
   DO Load_fld    && Load initial record from database into memory variables

   * Show data screen
   CLEAR
   DO Dstatus
   DO Backgrnd
   DO Show_data

   * Define popup menus
   DO Bar_def

   * Activate main popup menu - execute user choices
   SET COLOR TO &c_popup.
   ACTIVATE POPUP main_mnu
   DO Sub_ret

RETURN
*** END MAIN PROCEDURE *******************************************************

*** UTILITY PROCEDURES (Proprietary to Areacode.prg) *************************
PROCEDURE Filter
   * Filter (group) data into subset
   * Select subset to set up filter condition (Y=turn on, N=abort selection,
   * T=turn off). If filter is already on, set default choice to T, show
   * window. If filter is not on, set default choice to Y, show window.
   choice = IIF(filters_on,"T","Y")
   DO Filt_ans
   IF choice = "Y"              && Start process of choosing filter condition
      mcode  = 0
      ACTIVATE WINDOW alert
         * Get user's filter condition selection
         @  0, 0 SAY "------- ENTER FILTER CONDITION -----"
         @  2, 0 SAY "Area code:" GET mcode PICTURE "999"
         READ
      DEACTIVATE WINDOW alert
      IF 0 <> mcode             && Check whether user entered data
         SET FILTER TO code = mcode
      ELSE                      && User entered no data, so exit
         ?? CHR(7)
         filters_on = .F.
         RETURN
      ENDIF
      GO TOP                    && Activate filter by moving record pointer
      * Check whether filter condition matches any records (none matching=EOF)
      filters_on = .NOT. EOF()
      IF .NOT. filters_on       && Turn off filter if no matches found
         ?? CHR(7)
         DO Show_msg WITH "No Areacode records match the filter condition"
         SET FILTER TO
         GO record_num
      ENDIF
   ELSE
      * If user selects "T", turn off filter
      SET FILTER TO
      filters_on = .F.
   ENDIF
RETURN

PROCEDURE Indexer
   * Create/rebuild index
   INDEX ON code TAG Code
   INDEX ON city TAG City
   SET ORDER TO TAG City
   GO TOP
RETURN

PROCEDURE Init_fld
   * Initialize memory variables for data entry
   city = SPACE(20)
   code = 0
RETURN

PROCEDURE Load_fld
   * Load field values from Codes database record into memory variables
   city  = city
   code  = code
RETURN

PROCEDURE Repl_fld
   * Replace database fields with values of current memory variables
   REPLACE city WITH m->city, code WITH m->code
RETURN

PROCEDURE Backgrnd
   * Show background screen
   * Draw lines and boxes
   @  1,25 TO  3,53  DOUBLE COLOR &c_blue.
   @  6,7  TO  8,38  DOUBLE COLOR &c_red.
   @  9,7  TO 11,38         COLOR &c_red.
   @  2,26 FILL TO  2,52    COLOR &c_blue.
   @  6,7  FILL TO 11,38    COLOR &c_red.
   SET COLOR TO &c_data.
   @  2,27 SAY "PERSONAL AREACODE SYSTEM"
   @  7,10 SAY "CITY:"
   @ 10,10 SAY "CODE:"
   SET COLOR TO &c_standard.
RETURN

PROCEDURE Show_data
   * Show data
   SET COLOR TO &c_fields.
   @  7,17 SAY city
   @ 10,17 SAY code PICTURE "999"
   SET COLOR TO &c_standard.
RETURN

PROCEDURE Get_data
   * Show data for data entry
   SET COLOR TO &c_data.
   @  7,17 GET m->city PICTURE "!XXXXXXXXXXXXXXXXXXX"
   @ 10,17 GET m->code PICTURE "999"
   SET COLOR TO &c_standard.
RETURN

PROCEDURE Colo_rese
PRIVATE old_color, c_messages, c_titles, c_box, c_info, c_fields

old_color = c_save

* Set the Primary colors
SET COLOR TO &old_color.

* Remove primary colors and start at the secondary colors
old_color = STUFF(old_color, 1, AT("&",old_color)+2, "")

comma = AT(",",old_color)
c_messages = LEFT(old_color, comma-1)		&& Get MESSAGES color
old_color = STUFF(old_color, 1, comma, "")	&& Remove MESSAGES color

comma = AT(",",old_color)
c_titles = LEFT(old_color, comma-1)		&& Get TITLES color
old_color = STUFF(old_color, 1, comma, "")	&& Remove TITLES color

comma = AT(",",old_color)
c_box = LEFT(old_color, comma-1)		&& Get BOX color
old_color = STUFF(old_color, 1, comma, "")	&& Remove BOX color

comma = AT(",",old_color)
c_info = LEFT(old_color, comma-1)		&& Get INFORMATION color
old_color = STUFF(old_color, 1, comma, "")	&& Remove INFORMATION color

comma = AT(",",old_color)
c_fields = old_color									&& Get FIELDS color

SET COLOR OF MESSAGES    TO &c_messages.
SET COLOR OF TITLES      TO &c_titles.
SET COLOR OF BOX         TO &c_box.
SET COLOR OF INFORMATION TO &c_info.
SET COLOR OF FIELDS      TO &c_fields.
RETURN

*** END AREACODE.PRG *********************************************************

