{*************************************************************************
 **   Ctest Version 4.3  -                                              **
 **                                                                     **
 **      This program is comprised of 29 seperate units (Char_Tables,   **
 **      Confidence, Commands, CRT, Default, Dos, EPL, EPLHeader,       **
 **      Font, Format, Graph, Graphic, Header, HMIVMI, Intnatal,        **
 **      Justify, LQ_Types, Master, Misc, Motion, PinFire, Prn_Modes,   **
 **      Push_Pop, ScrnGrph, Select, Spacing, TabTest, TypeInfo,        **
 **      Width) which are called upon by Ctest, Confidence and EPL.     **
 **      Ctest performs all the initial setup options with include      **
 **      menus and setup functions.  While Confidence, EPL and PinFire  **
 **      perform the diagnostic portion of the the test.                **
 **                                                                     **
 **                                                                     **
 **                                         Developed By Epson America  **
 **                                         Technical Support           **
 **                                         4/7/93                      **
 ************************************************************************}

Program Ctest;

uses    EpsonMenu, TypeInfo, ScrnGrph, Crt, Confidence, SetupMenu, Pinfire,
        Utilities, Default, Dos, Epl, Download, PostScpt, BidAdj, SetWidth; { These are the units that CTEST calls }

Const
    BoxBlank : String[35] = '                                   ';
var
    Selection,
    TestSelect,
    PrSelect,
    QuickSelect,
    EPLTestSelect,
    EPLQuickSelect    : Integer;
    _9Menu,
    _9AMenu,
    _24Menu,
    _24AMenu,
    SPMenu,
    Pr_Group,
    TestMenu,
    ESCP2Menu,
    QuickMenu,
    ModeMenu,
    EPLTestMen,
    PSTestMen,
    FalTestMen,
    EPLQuickMen     :  MenuInfo;  { MenuInfo is the Array Type defined in TypeInfo }
    Printer         :  Printers;
    _9Pin,LongDelay,
    Second_Menu     :  Boolean;
    Ch : Char;
    Value      : String;
    PinNum     : Integer;
    FireSingle : Boolean;

{ **************************************** }
  procedure Init_PrGrup;  { Set up MenuInfo array for Printer Group Menu List }
    Begin
      Pr_Group.NumMenuItems := 4;
      with Pr_Group do begin
        MenuItems[1]  := '9 Pin Printers ';
        MenuItems[2]  := '24 Pin Printers';
        MenuItems[3]  := ' Special Prns  ';
        MenuItems[4]  := '  Exit to Dos  ';
      end;
     end;

{ *************************************** }
   procedure Init_SPMenu;  { Set up MenuInfo array for Speciality Products Menu List }
     begin
       SPMenu.NumMenuItems := 12;
       with SPMenu do begin
         MenuItems[1]   :=   '  ActionLaser  ';
         MenuItems[2]   :=   ' ActionLaser + ';
         MenuItems[3]   :=   ' ActionLaser II';
         MenuItems[4]   :=   'ActionLaser1000';
         MenuItems[5]   :=   'ActionLaser1500';
         MenuItems[6]   :=   '    EPL-6000   ';
         MenuItems[7]   :=   '    EPL-7000   ';
         MenuItems[8]   :=   '    EPL-7500   ';
         MenuItems[9]   :=   '    EPL-8000   ';
         MenuItems[10]  :=   '    EPI-4000   ';
         MenuItems[11]  :=   '   Stylus 800  ';
         MenuItems[12]  :=   '      Quit     ';
       end;
     end;

{ *************************************** }
   procedure Init_24Menu;  { Set up MenuInfo array for 24 Pin Printer Menu List }
     begin
       _24Menu.NumMenuItems := 16;
       with _24Menu do begin
         MenuItems[1]  := '    AP-3000    ';
         MenuItems[2]  := '    AP-3250    ';
         MenuItems[3]  := '    AP-4000    ';
         MenuItems[4]  := '    AP-4500    ';
         MenuItems[5]  := '     L1000     ';
         MenuItems[6]  := '    LQ-200     ';
         MenuItems[7]  := '    LQ-500     ';
         MenuItems[8]  := '    LQ-510     ';
         MenuItems[9]  := '  LQ570/AP5000 ';
         MenuItems[10] := ' LQ570+/AP5000+';
         MenuItems[11] := '     L750      ';
         MenuItems[12] := '    LQ-800     ';
         MenuItems[13] := '    LQ-850     ';
         MenuItems[14] := '    LQ-850+    ';
         MenuItems[15] := 'Additional Prns';
         MenuItems[16] := '     Quit      ';
       end;
      _24AMenu.NumMenuItems := 14;
      with _24AMenu do begin
         MenuItems[1]  := '    LQ-860     ';
         MenuItems[2]  := '    LQ-870     ';
         MenuItems[3]  := '    LQ-950     ';
         MenuItems[4]  := '    LQ-1000    ';
         MenuItems[5]  := '    LQ-1010    ';
         MenuItems[6] :=  '    LQ-1050    ';
         MenuItems[7] :=  '    LQ-1050+   ';
         MenuItems[8] :=  ' LQ1070/AP5500';
         MenuItems[9] :=  '    LQ-1070+   ';
         MenuItems[10] := '    LQ-1170    ';
         MenuItems[11] := '    LQ-1500    ';
         MenuItems[12] := '    LQ-2500    ';
         MenuItems[13] := '    LQ-2550    ';
         MenuItems[14] := '     Quit      ';
      end;
    end;

{ ****************************************** }
  procedure Init_9Menu;  { Set up MenuInfo array for 9 Pin Printer Menu List }
    begin
      _9Menu.NumMenuItems := 14;
      with _9Menu do Begin
        MenuItems[1]  := '    Apex 80    ';
        MenuItems[2]  := '    AP-2000    ';
        MenuItems[3]  := '    AP-2250    ';
        MenuItems[4]  := '    AP-2500    ';
        MenuItems[5]  := '   DFX-5000    ';
        MenuItems[6]  := '   DFX-8000    ';
        MenuItems[7]  := '    EX-800     ';
        MenuItems[8]  := '    EX-1000    ';
        MenuItems[9]  := '    FX-86e     ';
        MenuItems[10] := '    FX-850     ';
        MenuItems[11] := '    FX-870     ';
        MenuItems[12] := '    FX-286e    ';
        MenuItems[13] := 'Additional Prns';
        MenuItems[14] := '     Quit      ';
    end;
    _9AMenu.NumMenuItems := 7;
    With _9AMenu do begin
        MenuItems[1] := '    FX-1050    ';
        MenuItems[2] := '    FX-1170    ';
        MenuItems[3] := '    LX-800     ';
        MenuItems[4] := '    LX-810     ';
        MenuItems[5] := '     T750      ';
        MenuItems[6] := '     T1000     ';
        MenuItems[7] := '     Quit      ';
      end;
    end;

{ ********************************************** }
  procedure InitTestMenu;  { Set up MenuInfo array for Initial Test Menu List }
    begin
      If Printer = AP2250 then
       TestMenu.NumMenuItems := 9
      else
        If (Printer = AP3250) or (Printer = STYLUS800) then
          TestMenu.NumMenuItems := 8
        else
          If (Printer = FX870) or (Printer = FX1170) then
            TestMenu.NumMenuItems := 8
          else
            TestMenu.NumMenuItems := 7;
      with TestMenu do begin
        MenuItems[1] := 'Confidence Test';
        MenuItems[2] := '   Pin Fire    ';
        MenuItems[3] := '  Quick Test   ';
        MenuItems[4] := '  Port Status  ';
        MenuItems[5] := ' Set Interface ';
        MenuItems[6] := '  Set Options  ';
        If Printer = AP2250 then
          begin
            MenuItems[7] := '   Bi-d Adj    ';
            MenuItems[8] := 'Default Setting';
            MenuItems[9] := '    Quit       ';
          end
        else
          if (Printer = AP3250) or (Printer = STYLUS800) then
            begin
              MenuItems[7] := '  Bi-Dir Adj   ';
              MenuItems[8] := '    Quit       ';
            end
          else
            If (Printer = FX870) or (Printer = FX1170) then
              begin
                MenuItems[7] := ' Set Cr Width  ';
                MenuItems[8] := '    Quit       ';
              end
            else
              MenuItems[7] := '     Quit      ';
      end;
    end;

{ ********************************************** }
  procedure InitEPLTestMen;  { Set up MenuInfo array for Initial EPL Test Menu List }
    begin
      EPLTestMen.NumMenuItems := 5;
      with EPLTestMen do begin
        MenuItems[1] := 'Confidence Test';
        MenuItems[2] := '  Quick Test   ';
        MenuItems[3] := '  Port Status  ';
        MenuItems[4] := ' Set Interface ';
        MenuItems[5] := '     Quit      ';
      end;
    end;

{ ********************************************* }
  procedure InitPSTestMen; { Set up MenuInfo array for Initial Post Script Test Menu List }
    begin
      PSTestMen.NumMenuItems := 4;
      with PSTestMen do begin
        MenuItems[1] := 'Confidence Test';
        MenuItems[2] := '  Port Status  ';
        MenuItems[3] := ' Set Interface ';
        MenuItems[4] := '     Quit      ';
      end;
    end;

{ ********************************************* }
  procedure InitFalTestMen;  { Set up MenuInfo array for Initial EPI Test Menu List }
    begin
      FalTestMen.NumMenuItems := 6;
      with FalTestMen do begin
        MenuItems[1] := 'Confidence Test';
        MenuItems[2] := '  Quick Test   ';
        MenuItems[3] := '  Port Status  ';
        MenuItems[4] := ' Set Interface ';
        MenuItems[5] := '  Set Options  ';
        MenuItems[6] := '     Quit      ';
      end;
    end;

{ ********************************************** }


 procedure InitESCP2Men;  { Set up MenuInfo array for Initial ESC/P2 Quick Test Menu }
   begin
     ESCP2Menu.NumMenuItems := 9;
     with ESCP2Menu do begin
        MenuItems[1]  := '  Print Modes  ';
        MenuItems[2]  := '     Fonts     ';
        MenuItems[3]  := '  Intl. Chars  ';
        MenuItems[4]  := '  Char. Tables ';
        MenuItems[5]  := '   Graphics    ';
        MenuItems[6]  := ' Line Spacing  ';
        MenuItems[7]  := 'Down-Load Chars';
        MenuItems[8]  := '    Columns    ';
        MenuItems[9]  := '     Quit      ';
     end;
   end;

{ ****************************************************** }


  procedure InitQuickMen;  { Set up MenuInfo array for Initial Quick Test Menu List }
    begin
      QuickMenu.NumMenuItems := 10;
      with QuickMenu do begin
        MenuItems[1]  := '  Print Modes  ';
        MenuItems[2]  := '     Fonts     ';
        MenuItems[3]  := '  Intl. Chars  ';
        MenuItems[4]  := '   Graphics    ';
        MenuItems[5]  := ' Line Spacing  ';
        MenuItems[6]  := 'Down-Load Chars';
        MenuItems[7]  := '    Columns    ';
        MenuItems[8]  := '     Tabs      ';
        MenuItems[9]  := ' Justification ';
        MenuItems[10] := '     Quit      ';
      end;
    end;


{ ******************************************** }
  procedure InitEPLQuickMen;  { Set up MenuInfo array for Initial EPL Quick Test
                                Menu List }
    begin
      EPLQuickMen.NumMenuItems := 7;
      with EPLQuickMen do begin
        MenuItems[1] := '     Fonts     ';
        MenuItems[2] := 'Character Table';
        MenuItems[3] := '    HMI/VMI    ';
        MenuItems[4] := '    Graphics   ';
        MenuItems[5] := 'Cursor Position';
        MenuItems[6] := ' Misc. Commands';
        MenuItems[7] := '     Quit      ';
      end;
    end;

{ ********************************************* }
  procedure WriteTitle;  { Writes CTEST Title on the Screen }
     var I:  integer;
    begin
      VideoColors (White, Black);
      Clrscr;
      VideoColors (Black, Blue);
      for I := 3 to 6 do       (* Creates a Shadow for the Box *)
        begin
          GoToXY (8, I);
          write (BoxBlank, BoxBlank);
        end;
      VideoColors (Blue, White);  { Calls Unit ScrnGrph }
      for I := 3 to 5 do
        Begin
          GotoXY (6, I);
          Write(BoxBlank, BoxBlank);
        end;
      Box (6, 2, 75, 5);
      GoToXY (25, 3);
      write ('Epson Printer Confidence Test ');
      GoToXY (34, 4);
      write ('Version 4.3');
   end;

{ ******************************************************* }
   { ****Determine what 9 Pin printer was selected during menu selection process
     and send back info in "printer" var ****** }
     procedure Decipher_9Selection (Selection:   integer; var Printer:  Printers;
                                    var Second_menu:  Boolean);
    begin
      If not(Second_Menu) then
      case Selection of
        1:  Printer :=  Apex80;
        2:  Printer :=  AP2000;
        3:  Printer :=  AP2250;
        4:  Printer :=  AP2500;
        5:  Printer :=  DFX5000;
        6:  Printer :=  DFX8000;
        7:  Printer :=  EX800;
        8:  Printer :=  EX1000;
        9:  Printer :=  FX86e;
       10:  Printer :=  FX850;
       11:  Printer :=  FX870;
       12:  Printer :=  FX286e;
       13: Begin
             Printer := Addit;
             Second_Menu := True;
           end;
       else Printer := Null;
    end
   else
     case (Selection) of
        1:  Printer := FX1050;
        2:  Printer := FX1170;
        3:  Printer := LX800;
        4:  Printer := LX810;
        5:  Printer := T750;
        6:  Printer := T1000;
       else Printer :=  Null;
     end;
    end;

{ ******************************************************** }
    { ****Determines which 24 Pin Printer was selected during the menu process
      and send back as "printer" var ***** }
  procedure Decipher_24Selection (Selection:  integer;
                                  var Second_Menu : Boolean;
                                  var Printer:  Printers);
    begin
      if not(Second_Menu) then
        case (Selection) of
          1:  Printer := AP3000;
          2:  Printer := AP3250;
          3:  Printer := AP4000;
          4:  Printer := AP4500;
          5:  Printer := L1000;
          6:  Printer := LQ200;
          7:  Printer := LQ500;
          8:  Printer := LQ510;
          9:  Printer := LQ570;
         10:  Printer := LQ570X;
         11:  Printer := L750;
         12:  Printer := LQ800;
         13:  Printer := LQ850;
         14:  Printer := LQ850n;
         15: Begin
               Printer := Addit;
               Second_Menu := True;
             end;
         else Printer := Null;
       end
      else
        case (Selection) of
          1:  Printer := LQ860;
          2:  Printer := LQ870;
          3:  Printer := LQ950;
          4:  Printer := LQ1000;
          5:  Printer := LQ1010;
          6:  Printer := LQ1050;
          7:  Printer := LQ1050n;
          8:  Printer := LQ1070;
          9:  Printer := LQ1070X;
         10:  Printer := LQ1170;
         11:  Printer := LQ1500;
         12:  Printer := LQ2500;
         13:  Printer := LQ2550;
          else Printer := Null;
        end;
    end;

{ ********************************************************** }
    { *****Determine the Special Printer selection from the menu selection
    process and send back info as "printer" var ****** }
  procedure Desipher_SPSelection(Selection:   integer; var Printer:  Printers);
    Begin
      Case Selection of
      1:   Printer := ActionLaser;
      2:   Printer := ALaser;
      3:   Printer := ALaserII;
      4:   Printer := ALaser1000;
      5:   Printer := ALaser1500;
      6:   Printer := EPL6000;
      7:   Printer := EPL7000;
      8:   Printer := EPL7500;
      9:   Printer := EPL8000;
      10:  Printer := EPI4000;
      11:  Printer := STYLUS800;
      else Printer := Null;
    end;
  end;

{ *********************************************************** }
  { ******Refreshes the specified printer type menu on the screen****** }
  procedure Refresh (_9Pin, Second_Menu : Boolean);
    begin
      if ((Printer = EPI4000) or (Printer = ALaserII) or (Printer = ALaser1000) or (Printer = ALaser1500)
          or (Printer = EPL7000) or (Printer = EPL8000)  or (Printer = STYLUS800)) then
        Refresh_Menu (15,8,SpMenu,Selection)  { Calls Unit EpsonMenu to put
                                                 special printer menu on screen }
      else If _9Pin then
        If Second_Menu then
          Refresh_Menu (15,8, _9AMenu, Selection)
        else
          Refresh_Menu (15,8,_9Menu,Selection)  { Calls Unit EpsonMenu to put
                                                9 pin printer menu on screen }
        else
          If Second_Menu then
            Refresh_Menu (15,8,_24AMenu,Selection)  { Calls Unit EpsonMenu to
                                                      put 2nd 24 pin printer menu on screen }
          else
            Refresh_Menu (15,8,_24Menu,Selection);  { Calls Unit EpsonMenu to
                                                  put 24 pin printer menu on screen }
    end;

{ ********************************************************* }
    { Sets paper path for DFX-8000 and selects CSF Bin }
  procedure SetPaperPath (CSF_Setting : CSF; Paper_Path : Path; Printer : Printers);
    Begin
      If Printer = DFX8000 then
        Begin
          Case Paper_Path of
            Front  : Write(Lst,chr(27),chr(25),'F');
            Rear   : Write(Lst,chr(27),chr(25),'B');
          end;
          Verify_Paper(Port_Setting);
        end
      else
        Case CSF_Setting of
          Single : Write(Lst,chr(27),chr(25),'1');
          Dual   : Write(Lst,chr(27),chr(25),'2');
        end;
    end;

{ ******************************************************* }
  procedure Init_Settings;  { Sets default initial settings }
    Begin
      CSF_Setting    := None;
      Paper_Setting  := Narrow;
      Color_Setting  := False;
      Font_Setting   := Non;
      Paper_Path     := Front;
      Old_Paper_Path := Paper_Path;
      Slot1          := NoCart;
      Slot2          := NoCart;
    end;

{ ************************************************************ }
    { Saves the user chose defaults depending upon user selection }
  procedure SaveDef (Port_Setting, Baud_Setting, Parity_Setting : String);
   Var Ch : Char;
    Begin
      GoToXY(30, 24);
      Write('Save as Defaults Y/N');
      Ch := Readkey;
      Case CH of
        'Y','y' : Write_Def (Port_Setting, Baud_Setting, Parity_Setting);
                { Go to unit Utilities }
        'N','n' : ; (* Do Nothing *)
        else      SaveDef (Port_Setting, Baud_Setting, Parity_Setting);
                  { Go into loop until correct key is pressed }
      end;
    end;

{ *************************************************************** }
  procedure Init_Everything;  { Initializes all default settings }
    Begin
      FileOPEN := False; (* FileOPEN is used to tell IODirect that NO file LST has been opened *)
      Read_Def(Port_Setting, Baud_Setting, Parity_Setting);  { Go to unit
                                                               Utilities }
      Init_Port(Port_Setting, Baud_Setting, Parity_Setting,FileOPEN);  { Go to unit
                                                                SetupMenu }
      Second_Menu := False;
      Emulation := HP;
      PrSelect    := 1;
      QuickSelect := 1;
      EPLQuickSelect := 1;
      Init_Settings;
      HideCursor;  { Go to unit ScrnGrph }
      Init_PrGrup;
      Init_9Menu;
      Init_24Menu;
      InitTestMenu;
      InitEPLTestMen;
      InitPSTestMen;
      InitFalTestMen;
      InitESCP2Men;
      InitQuickMen;
      InitEPLQuickMen;
      Init_SpMenu;
      LongDelay := False;
      _9pin := False;
    end;

 { ********************************************************** }
 Procedure SPConfidence( Printer : Printers ); Forward;  { The procedure is
                                                           listed below }

{ ********************************************************** }
{  This procedure displays the testmenu menu and depending on
selection performs the actual confindence test on the printer }

 Procedure Read_Value (Var Ch : Char; Var PinNum : Integer );
    Var I : Integer;
     Begin
       Readln(Value);
       GoToXY(51,22);
       Write('                ');
       GoToXY(40,22);
       Write('E to exit: ');
       I := 1;
       While I <= Length(Value) do
         Begin
           Case Value[I] of
             '0','1','2','3','4','5','6','7','8','9' :Begin
                                                        Inc(I);
                                                        Ch := 'n'; (* Used to show a number exits not an empty string. *)
                                                      end;
             'A','a','E','e' : Begin
                                 Case Value[I] of
                                   'A','a' : Ch := 'A';
                                   'E','e' : Ch := 'E';
                                 end;
                                 I := Length(Value) + 1;(* Exit Loop *)
                               end
             else              Begin
                                 Delete(Value,I,1);
                                 Inc(I);
                               end;
           end;
         end;
       Case Ch of
         'A','E' :
          else Val(Value,PinNum,I);
       end;
     end;

 Procedure Dot_Matrix ( Printer : Printers );

 Function ESCP2 : Boolean;
   Begin
     Case Printer of
       AP3250,LQ570,LQ570X,LQ870,LQ1070,LQ1070X,LQ1170,STYLUS800 : ESCP2 := True;
       else                                                        ESCP2 := False;
     end; {Case}
   end;

   Begin
     Init_Settings;
     TestSelect := 1;
     repeat
       MakeMenu (40, 10, TestMenu, TestSelect);  { go to Unit EpsonMenu and
                                                 place Initial test menu on
                                                 the screen and return
                                                  choice as "testselect"  }
       IODirect(Port_Setting,FileOPEN);  { Go to unit TypeInfo and set up the port
                                  type:  LPT1, 2, COM1, 2  }
       HideCursor;  { Go to unit ScrnGrph }
       case TestSelect of
         1:  Begin  {Confidence Test was selected in Test Menu }
               Get_Prn_Ready(Port_Setting,Longdelay,Fail,Printer);  { Unit Utilities,
                                                              tests the port
                                                              depending on its
                                                              type and returns
                                                              status }
               If Not(Fail) then
                 Begin
                   SetPaperPath(CSF_Setting, Paper_Path, Printer);
                   DefaultPrinter;  { Go to Unit Default and send codes to
                                      printer to set up defaults }
                   GoToXY(70,24);
                   VideoColors(White,Blue+Blink);
                   Write('Testing...');
                   ConfidenceTest (Printer, Paper_Setting, Font_Setting, Color_Setting, CSF_Setting, _9Pin);
                     { Go to unit Confindence and send codes to printer }
                   GotoXY(70,24);
                   VideoColors(White,Blue);
                   Write('          ');
                 end;
             end;
         2:  Begin  { PinFire was selected in Test Menu }
              If Printer <> STYLUS800 then
               Begin
                Get_Prn_Ready(Port_Setting,Longdelay, Fail,Printer);  { Unit Utilites,
                                                               test the port
                                                               and return result }
                If Not(Fail) then
                 Begin
                   SetPaperPath(CSF_Setting, Paper_Path, Printer);
                   DefaultPrinter;  { Go to unit Default and send codes to
                                      set up printer }
                   Ch := ' ';
                   PinNum := 0;
                   FireSingle := False;
                   VideoColors(White,Blue);
                   GoToXY(40,20);
                   Write('Please Enter Pin Number,');
                   GotoXY(40,21);
                   Write('or press A for all pins,');
                   GoToXY(40,22);
                   Write('E to exit: ');
                   Read_Value(Ch,PinNum);
                   While Ch <> 'E' do
                     Begin
                       If Ch <> 'E' then
                         Case Ch of
                           'A': Begin
                                  FireSingle := False;
                                  If _9Pin then
                                    PinFire9 { Go to unit PinFire }
                                  else
                                    PinFire24;  { Go to unit PinFire }
                                end;
                           'n': Begin
                                  if (_9Pin) and (PinNum > 0) and (PinNum < 10) then
                                    Begin
                                      SinglePin (PinNum, _9Pin);
                                      FireSingle := True;
                                    end
                                  else
                                    if (Not(_9Pin) and (PinNum > 0) and (PinNum < 25)) then
                                      Begin
                                        SinglePin (PinNum, _9Pin);
                                        FireSingle := True;
                                      end;
                                end;
                           else; (* Do Nothing. *)
                         end;
                       PinNum := 0;
                       Ch := ' ';
                       Read_Value(Ch, PinNum);
                     end;
                   If FireSingle then
                     Write(Lst,Chr(12));
                   GotoXY(40,20);
                   Write('                          ');
                   GotoXY(40,21);
                   Write('                          ');
                   GotoXY(40,22);
                   Write('                          ');
                 end;
               end;
             end;
         3:  Begin  { Quick Test was selected in Test Menu }
               Get_Prn_Ready(Port_Setting,Longdelay,Fail,Printer);  { Go to unit
                  Utilities and test the port and return results }
               If Not(Fail) then
                begin
                  If ESCP2 then
                     begin
                       SetPaperPath(CSF_Setting, Paper_Path, Printer);
                       DefaultPrinter;  { Go to unit Default and send codes to
                                      set up printer }
                       repeat { Until "Quit" is selected in Quick menu }
                         MakeMenu(40,9,ESCP2Menu,QuickSelect);  { Go to unit EpsonMenu
                          and display the ESCP2 Menu on screen and return selection }

                         if QuickSelect <> ESCP2Menu.NumMenuItems then  { Test to see if "Quit" was selected }
                           Quick_Test(Printer, Paper_Setting, Font_Setting, Color_Setting, QuickSelect, _9Pin)
                                           { Go to unit Confidence and run ESCP2 choice program }
                       until QuickSelect = ESCP2Menu.NumMenuItems;  { Repeat until "quit" is selected }
                       Clear_Menu(40,8,ESCP2Menu);  { Go to unit EpsonMenu and remove ESCP2 Menu from screen }
                    end
                  Else
                     begin
                       SetPaperPath(CSF_Setting, Paper_Path, Printer);
                       DefaultPrinter;  { Go to unit Default and send codes to
                                      set up printer }
                       repeat { Until "Quit" is selected in Quick menu }
                         MakeMenu(40,8,QuickMenu,QuickSelect);  { Go to unit EpsonMenu
                          and display the Quick Menu on screen and return selection }

                         if QuickSelect <> QuickMenu.NumMenuItems then  { Test to see if "Quit" was selected }
                          Quick_Test(Printer, Paper_Setting, Font_Setting, Color_Setting, QuickSelect, _9Pin)
                                           { Go to unit Confidence and run quick choice program }
                       until QuickSelect = QuickMenu.NumMenuItems;  { Repeat until "quit" is selected }
                       Clear_Menu(40,8,QuickMenu);  { Go to unit EpsonMenu and remove Quick Menu from screen }
                    end;
                 end;
               end;
         4:  Begin { Display Status of the port }
               Show_Status(Port_Setting);
               ClrScr;
               WriteTitle;
               Refresh(_9Pin, Second_Menu);
             end;
         5:  Begin  { Set Interface was selected in Test Menu }
               SetupInterface(Port_Setting, Baud_Setting, Parity_Setting);  { Go to unit SetupMenu }
               SaveDef(Port_Setting, Baud_Setting, Parity_Setting);
               Clrscr;
               WriteTitle;
               Refresh(_9Pin, Second_Menu);
             end;
         6:  Begin  { Set Options was selected in Test Menu }
               If ((Printer <> EPI4000) or (Printer <> ALaserII) or (Printer <> ALaser1000) or (Printer <> ALaser1500)
                   or (Printer <> EPL7000) or (Printer <> EPL8000)) then
                 Begin
                   SetupCCFN(_9Pin, Printer, Paper_Path, Paper_Setting, Font_Setting, CSF_Setting, Color_Setting);
                                    { Go to unit SetupMenu }
                   ClrScr;
                   WriteTitle;
                   Refresh(_9Pin, Second_Menu);
                   If Paper_Path <> Old_Paper_Path then
                     Begin
                       SetPaperPath(CSF_Setting, Paper_Path, Printer);
                       Verify_Paper(Port_Setting);  { Go to unit Utilities }
                       Old_Paper_Path := Paper_Path;
                     end;
                 end
               else
                 Begin  { If printer = "EPI4000" or "ALaserII" or "EPL7000"  or "EPL8000" then setup options for falcon }
                   OldEmulation := Emulation;
                   SetupFalconOpt(Printer, Emulation, Slot1, Slot2);
         { Go to unit SetupMenu }
                   clrscr;
                   WriteTitle;
                   Refresh_Menu (15,12,SPMenu,Selection);  { Go to unit EpsonMenu }
                   Case Emulation of  { Determine and setup the emulation type for the EPI4000 }
                     FX : Begin
                           If Emulation <> OldEmulation then
                             Begin
                              _9pin := True;
                              Dot_Matrix (Printer);
                             end;
                           end;
                     ELQ : Begin
                             If Emulation <> OldEmulation then
                               Begin
                                _9Pin := False;
                                Dot_Matrix (Printer);
                               end;
                           end;
                      HP : Begin
                             If Emulation <> OldEmulation then
                               Begin
                                 SpConfidence (Printer);
                                 TestSelect := TestMenu.NumMenuItems;
                               end;
                           end;
                   end;


                 end;
             end;
         7:  If ((Printer = AP3250) or (Printer = AP2250) or (Printer = STYLUS800)) then
               Begin
                   Get_Prn_Ready(Port_Setting,Longdelay,Fail,Printer);
                   Bidir_ADJ(Printer);
                   Clrscr;
                   WriteTitle;
                   Refresh(_9pin,Second_menu);
               end
             else
               If (Printer = FX870) or (Printer = FX1170) then
                 Begin
                   Get_Prn_Ready(Port_Setting,Longdelay,Fail,Printer);
                   Set_Cr_Width;
                   Clrscr;
                   WriteTitle;
                   Refresh(_9pin,Second_menu);
                 end
             else ; { Quit was selected from the Test Menu }

         8: If Printer = AP2250 then
              Begin
                Get_Prn_Ready(Port_Setting,Longdelay,Fail,Printer);
                Default_Options;
                Clrscr;
                WriteTitle;
                Refresh(_9pin,Second_menu);
              end
            else ; { Quit was selected for an AP3250}
        else;
       end;
     until TestSelect = TestMenu.NumMenuItems;
     Emulation := HP;
     Clear_Menu(40, 10, TestMenu);  { Remove TestMenu from the screen }
     LongDelay := false;
   end;

{ ****************************************************************** }
   { This procedure starts selection of EPL and EPI menus }
 Procedure SPConfidence;
   Var AllreadyDownloaded : Boolean;
   Begin
     EPLTestSelect := 1;
     AllreadyDownloaded := False;
     Repeat
       If ((Printer = EPI4000) or (Printer = ALaserII) or (Printer = ALaser1000) or (Printer = ALaser1500)
            or (Printer = EPL7000) or (Printer = EPL8000)) then
         Begin
           EplTestMen.NumMenuItems := 6;(* Modified so I didn't have to use two case statments *)
           MakeMenu (40, 11, FalTestMen, EPLTestSelect);  { Go to unit EpsonMenu and display initial
                                                            EPI Test Menu in grapihcs menu }
         end
       else If printer = EPL7500 then
         Begin
           EPLTestMen.NumMenuItems := 4;{ there are 3 choices in menu }
           MakeMenu (40, 11, PSTestMen, EPLTestSelect);
         end
       Else
         Begin
           EPLTestMen.NumMenuItems:= 5;
           Slot1 := NoCart;
           Slot2 := NoCart;
           MakeMenu (40, 11, EPLTestMen, EPLTestSelect);  { Go to unit EpsonMenu and display initial
                                                            EPL Test Menu in graphics menu }
         end;
       IODirect(Port_Setting,FileOPEN);  { Go to unit TypeInfo }
       HideCursor;  { Go to unit ScrnGrph }
       case EPLTestSelect of  { Return selection of either EPL or EPI4000 Test menu and
                                determine choice }

         1:  Begin  { Perform special confidence test }
               Get_Prn_Ready(Port_Setting,False,Fail,Printer);
               If Not(Fail) then
                If Printer = EPL7500 then
                  Begin
                    GoToXY(70,24);
                    VideoColors(White,Blue+Blink);
                    Write('Testing...');
                    PSconf (Printer); { Confidence was selected in EPL7500}
                    GoToXY(70,24);
                    VideoColors(White,Blue);
                    Write('          ');
                  end
                Else
                 Begin
                   GoToXY(60,22);
                   VideoColors(Blue, White + Blink);
                   Write('Down-Loading Fonts');
                   If Not(AllreadyDownloaded) then
                     Begin
                       D_Load;
                       AllreadyDownloaded := True;
                     end;
                   VideoColors(White,Blue);
                   GoToXY(60,22);
                   Write('                  ');
                   GoToXY(70,24);
                   VideoColors(White,Blue+Blink);
                   Write('Testing...');
                   EPLConf(Slot1, Slot2, Printer);
                   GoToXY(70,24);
                   VideoColors(White,Blue);
                   Write('          ');
                end;
             end;
         2:  Begin  { Perform special quick test selection }
               If Printer = EPL7500 then
                 Begin { perform set interface for EPL-7500}
                   Show_Status(Port_Setting);
                   ClrScr;
                   WriteTitle;
                   Refresh_Menu (15,12,SPMenu,Selection);
                 end
               else
                 Begin
                   Get_Prn_Ready(Port_Setting, False, Fail,Printer);
                   If Not(Fail) then
                     Begin
                       GoToXY(60,22);
                       VideoColors(Blue, White + Blink);
                       Write('Down-Loading Fonts');
                       If Not(AllreadyDownloaded) then
                         Begin
                           D_Load;
                           AllreadyDownloaded := True;
                         end;
                       VideoColors(White,Blue);
                       GoToXY(60,22);
                       Write('                  ');
                       repeat
                         MakeMenu(40,10,EPLQuickMen,EPLQuickSelect);
                         if EPLQuickSelect <> EPLQuickMen.NumMenuItems then
                           EPLQuickConf(Slot1, Slot2, Printer, EPLQuickSelect)
                       until EPLQuickSelect = EPLQuickMen.NumMenuItems;
                       Clear_Menu(40,10,EPLQuickMen);
                     end;
                   end;
             end;
         3:  Begin { Display Status of the port }
               If Printer = EPL7500 then
                 Begin { perform set interface for EPL-7500}
                   SetupInterface(Port_Setting, Baud_Setting, Parity_Setting);
                   SaveDef(Port_Setting, Baud_Setting, Parity_Setting);
                   Clrscr;
                   WriteTitle;
                   Refresh_Menu(15,12,SPMenu,Selection);
                 end
               else
                 Begin
                   Show_Status(Port_Setting);
                   ClrScr;
                   WriteTitle;
                   Refresh_Menu (15,12,SPMenu,Selection);
                 end;
             end;
         4: If Printer <> EPL7500 then
               Begin  { Perform Set Interface for EPL or EPI }
                SetupInterface(Port_Setting, Baud_Setting, Parity_Setting);
                SaveDef(Port_Setting, Baud_Setting, Parity_Setting);
                Clrscr;
                WriteTitle;
                Refresh_Menu (15,12,SPMenu,Selection);
               end
             Else
               clear_menu (40,11,PSTestMen);

         Else If (((Printer = EPI4000) or (Printer = ALaserII) or (Printer = ALaser1000) or (Printer = ALaser1500)
                or (Printer = EPL7000) or (Printer = EPL8000)) and (EPLTestSelect = 5)) then
         { If printer is EPI4000 or EPL7000 and set options was selcted then perform }
             Begin
               OldEmulation := Emulation;
               SetupFalconOpt(Printer, Emulation, Slot1, Slot2);
               clrscr;
               WriteTitle;
               Refresh_Menu (15,8,SPMenu,Selection);
               Case Emulation of
                 FX : Begin
                        _9pin := True;
                        Dot_Matrix (Printer);
                        EplTestSelect := EplTestMen.NumMenuItems;
                      end;
                ELQ : Begin
                        _9Pin := False;
                        Dot_Matrix (Printer);
                        EplTestSelect := EplTestMen.NumMenuItems;
                      end
               end;
             end
         Else ;
           clear_menu (40,11,PSTestMen);
        end;
     until EPLTestSelect = EPLTestMen.NumMenuItems;
     If Printer <> EPL7500 then
       Begin
        Clear_Menu (40, 11, EPLTestMen);
       end;
     end;

{ **************************************************************** }
 procedure CheckEPIEm;
   Var Falmode : Integer;
    Begin
      Case Emulation of
        FX  : Begin
                _9Pin := True;
                Dot_matrix(Printer);
              end;
       ELQ  : Begin
                _9Pin := False;
                Dot_matrix(Printer);
              end;
        HP  : SpConFidence(Printer);
      end;
    end;

{ *************************************************************** }
 begin  { Begin the actual CTEST program }
    Init_Everything;
    repeat  { Until "Exit to DOS" is selected from the Pr_Group Menu
  ************************************************************************ }
      Selection := 1;
      VideoColors (Black, White);
      ClrScr;
      WriteTitle;
      MakeMenu (29, 12, Pr_Group, PrSelect);  { Display Pr_Group Menu and return
                                                printer selection }
      ClrScr;
      WriteTitle;
      Case PrSelect of   { analyse printer selection "PrSelect" returned
                           from MakeMenu }
        1     : Begin
        { *********** A 9 Pin Printer has been selected **************** }
                  _9Pin := True;
                  Repeat  { Until Quit is selected from 9 pin menu "Null Printer"
              ************************************************************** }
                    MakeMenu(15,8,_9Menu,Selection);  { Display 9 Pin menu and return selection }
                    Decipher_9Selection(Selection, Printer, Second_Menu);  { Determine what printer was selected
                                                                and store in "Printer" }
                    If Second_Menu then
                      { *************************** }
                      Begin
                        Clear_Menu(15,8, _9Menu);
                        Selection := 1;
                        MakeMenu (15,8, _9AMenu, Selection);
                        Decipher_9Selection(Selection, Printer, Second_Menu);
                      End;
                      { ***************************** }
                    If ((Printer = DFX5000) or (Printer = DFX8000) or (Printer = AP2250)) then
                      LongDelay := True
                    else
                      LongDelay := False;
                    If Printer <> Null then  { If "Quit" was not selected then perform
                                               procedure Dot_Matrix }
                      begin
                        InitTestMenu;
                        Dot_Matrix(Printer);
                      end;
                  Selection := 1;
                  Second_Menu := False;
                  Until Printer = Null;
                 end;
         2     : Begin
         { ****************** A 24 pin printer has been selected ********* }
                   _9Pin := False;
                   LongDelay := False;

                   { Until "Quit" is selected from 24 pin menu .... }
                   Repeat
                     { ************************************************** }
                     MakeMenu(15,8,_24Menu,Selection); { Display 24 pin printer menu
                                                         and return selection }
                     Decipher_24Selection(Selection, Second_Menu, Printer);
                       { Determine what printer was selected }

                     If Second_Menu then
                       { ********************************** }
                       Begin
                         Clear_Menu(15,8, _24Menu);
                         Selection := 1;
                         MakeMenu (15, 8, _24AMenu, Selection);  { Display additional 24 pin
                                                                   printers and return choice }
                         Decipher_24Selection(Selection, Second_Menu, Printer);
                            { Determine what printer was selected }
                        end;
                        { ********************************** }
                      If Printer <> Null then  { If selected was not "Quit"
                                                 then run procedure Dot_Matrix }
                        Begin
                          InitTestMenu;
                          If Printer = AP3250 then
                              LongDelay := True;
                          Dot_Matrix(Printer);
                        end;
                    Second_Menu := False;
                    Selection := 1;
                    Until Printer = Null;
                      { ************************************************** }
                    end;
          3     : Begin
                    Repeat
                      MakeMenu(15,8,SPMenu,Selection);
                      Desipher_SPSelection(Selection, Printer);
                      If Printer <> Null then
                       Begin
{                        If ((Printer = EPI4000) or(Printer = ALaserII) or (Printer = ALaser1000) or (Printer = ALaser1500)
                            or (Printer = EPL7000) or (Printer = EPL8000)) then
                           CheckEPIEm;   }
                        If Printer = STYLUS800 then
                          Begin
                            InitTestMenu;
                            Dot_Matrix(Printer);
                          end
                        else
                          SPConfidence(Printer);
                          Selection := 1;
                      end;
                    Until Printer = Null;
                  end;
           Else  ;
        end;
    until PrSelect = 4;
  CloseScreen;
end . {The CTEST program }
{ **************************************************************** }
