; $Header:   F:\mp2\vcs\sc\emptydb.scv   1.7   18 Nov 1993 14:46:32   JEC  $
; Copyright (c) 1990 by Datastream Systems Incorporated
;=============================================================================
; Emptydb.sc - Empty the MP2 database that is in the current directory.
;              This script is for use with the MPTUTOR database.
;==Update Log=================================================================
; $Log:   F:\mp2\vcs\sc\emptydb.scv  $
;  
;     Rev 1.7   18 Nov 1993 14:46:32   JEC
;  Included a complete set of tables to be emptied.
;  
;     Rev 1.6   15 Jun 1993 14:07:22   PJE
;  Updated table listing for MP2 v3.0.
;  
;     Rev 1.5   25 Mar 1993 14:51:24   PJE
;  
;     Rev 1.4   25 Mar 1993 13:16:16   PJE
;  Added new tables to the list of tables that are to be emptied.
;  
;     Rev 1.3   07 Jan 1993 15:19:06   PJE
;  No change.
;  
;     Rev 1.2   26 Aug 1991 15:27:06   JPC
;  Added some new tables.
;  
;     Rev 1.1   09 May 1991 09:33:54   JPC
;  Removed ARCHIST* tables from array, added WO\WOX.
;  
;     Rev 1.0   25 Jun 1990 16:26:20   JPC
;  Initial revision.
;=============================================================================

;==============================================================================
; EmptyTable(Tbl) - Empty the Table whose path/table name is passed via Tbl.
;==============================================================================

PROC EmptyTable(Tbl)
  IF IsTable(Tbl) THEN                      ; Does the table exist?
    @ 22, 0 Clear Eol                       ; Clear the previous message
    Message "Emptying ", Tbl, " table..."   ; Yes, indicate tbl being emptied
    Echo Off
    IF IsTable(Tbl) THEN
      Empty Tbl                             ; Empty the table
    ENDIF
  ENDIF
ENDPROC

;==============================================================================
; EmptyAllTables() - Empty all the normal Maintenance Pac 2 tables, except
; work tables & dummy report tables, which are normally empty, and the Reports,
; Key, States, Groups, EmpRight and Printers tables.
;==============================================================================

PROC EmptyAllTables()
  Private Tbls, i, Stop

  ; Allocate and assign values to the array of tables that will be emptied
  DynArray Tbls[]
  Tbls[1] = "Errorlog"
  Tbls[2] = "Facility"
  Tbls[3] = "Users"
  Tbls[4] = "Analysis\\Category"
  Tbls[5] = "Analysis\\Histgram"
  Tbls[6] = "Analysis\\Pareto"
  Tbls[7] = "Analysis\\Tseries"
  Tbls[8] = "Analysis\\Udvdesc"
  Tbls[9] = "Analysis\\Udvvalue"
  Tbls[10] = "Audit\\Aud"
  Tbls[11] = "Audit\\Audchg"
  Tbls[12] = "Audit\\Audfld"
  Tbls[13] = "Audit\\Audit"
  Tbls[14] = "Audit\\Auditchg"
  Tbls[15] = "Audit\\Auditfld"
  Tbls[16] = "Audit\\Auditrpt"
  Tbls[17] = "Audit\\Auditsel"
  Tbls[18] = "Barcode\\Eqcom"
  Tbls[19] = "Barcode\\Eqcomhdr"
  Tbls[20] = "Barcode\\Eqcomlst"
  Tbls[21] = "Barcode\\Transact"
  Tbls[22] = "Ctb\\Abc"
  Tbls[23] = "Ctb\\Abcsetup"
  Tbls[24] = "Ctb\\Bhistdum"
  Tbls[25] = "Ctb\\Breqdum"
  Tbls[26] = "Ctb\\Costsum"
  Tbls[27] = "Ctb\\Dd"
  Tbls[28] = "Ctb\\Dupes"
  Tbls[29] = "Ctb\\Eoq"
  Tbls[30] = "Ctb\\Eoqavg"
  Tbls[31] = "Ctb\\Eoqquery"
  Tbls[32] = "Ctb\\Eqsub"
  Tbls[33] = "Ctb\\Eqsubsum"
  Tbls[34] = "Ctb\\Eqxref"
  Tbls[35] = "Ctb\\Fields"
  Tbls[36] = "Ctb\\Histsum"
  Tbls[37] = "Ctb\\Invysum"
  Tbls[38] = "Ctb\\Invyxref"
  Tbls[39] = "Ctb\\Keys"
  Tbls[40] = "Ctb\\Keys1"
  Tbls[41] = "Ctb\\Label"
  Tbls[42] = "Ctb\\Labordtl"
  Tbls[43] = "Ctb\\Laborhdr"
  Tbls[44] = "Ctb\\Laborsum"
  Tbls[45] = "Ctb\\Leadtime"
  Tbls[46] = "Ctb\\Nonusage"
  Tbls[47] = "Ctb\\Phistdum"
  Tbls[48] = "Ctb\\Phistsum"
  Tbls[49] = "Ctb\\Pick"
  Tbls[50] = "Ctb\\Pocustom"
  Tbls[51] = "Ctb\\Protobud"
  Tbls[52] = "Ctb\\Quote"
  Tbls[53] = "Ctb\\Reqhist"
  Tbls[54] = "Ctb\\Request"
  Tbls[55] = "Ctb\\Requestc"
  Tbls[56] = "Ctb\\Requeste"
  Tbls[57] = "Ctb\\Sparehdr"
  Tbls[58] = "Ctb\\Sparerbl"
  Tbls[59] = "Ctb\\Sparetem"
  Tbls[60] = "Ctb\\Tables"
  Tbls[61] = "Ctb\\Timehist"
  Tbls[62] = "Ctb\\Timentry"
  Tbls[63] = "Ctb\\Timerpt"
  Tbls[64] = "Ctb\\Vendsum"
  Tbls[65] = "Ctb\\Whistsum"
  Tbls[66] = "Ctb\\Wo93"
  Tbls[67] = "Ctb\\Wocst"
  Tbls[68] = "Ctb\\Wocstsum"
  Tbls[69] = "Ctb\\Woinstr"
  Tbls[70] = "Drwg\\Draw"
  Tbls[71] = "Drwg\\Eqdrwg"
  Tbls[72] = "Drwg\\Invydrwg"
  Tbls[73] = "Drwg\\Taskdraw"
  Tbls[74] = "Emp\\Attend"
  Tbls[75] = "Emp\\Crafts"
  Tbls[76] = "Emp\\Emp"
  Tbls[77] = "Emp\\Time"
  Tbls[78] = "Eq\\Costctr"
  Tbls[79] = "Eq\\Eqtype"
  Tbls[80] = "Eq\\Equip"
  Tbls[81] = "Eq\\Eqxref"
  Tbls[82] = "Eq\\Ledger"
  Tbls[83] = "Eq\\Meter"
  Tbls[84] = "Eq\\Spares"
  Tbls[85] = "Invy\\Acct"
  Tbls[86] = "Invy\\Invspec"
  Tbls[87] = "Invy\\Invtype"
  Tbls[88] = "Invy\\Invvend"
  Tbls[89] = "Invy\\Invy"
  Tbls[90] = "Invy\\Issrec"
  Tbls[91] = "Invy\\Physinv"
  Tbls[92] = "Invy\\Po"
  Tbls[93] = "Invy\\Poheader"
  Tbls[94] = "Invy\\Pohist"
  Tbls[95] = "Invy\\Pospchdr"
  Tbls[96] = "Invy\\Pospec"
  Tbls[97] = "Invy\\Reserved"
  Tbls[98] = "Invy\\Stock"
  Tbls[99] = "Invy\\Vendor"
  Tbls[100] = "Rpt\\Aging"
  Tbls[101] = "Rpt\\Asset"
  Tbls[102] = "Rpt\\Cprod"
  Tbls[103] = "Rpt\\Empprod"
  Tbls[104] = "Rpt\\Gsdummy"
  Tbls[105] = "Rpt\\Indexfix"
  Tbls[106] = "Rpt\\Invstat"
  Tbls[107] = "Rpt\\Issdum"
  Tbls[108] = "Rpt\\Meterdum"
  Tbls[109] = "Rpt\\Meterlog"
  Tbls[110] = "Rpt\\Multidum"
  Tbls[111] = "Rpt\\Physdum"
  Tbls[112] = "Rpt\\Podum"
  Tbls[113] = "Rpt\\Resdum"
  Tbls[114] = "Rpt\\Taskdum"
  Tbls[115] = "Rpt\\Venddum"
  Tbls[116] = "Rpt\\Weeksum"
  Tbls[117] = "Rpt\\Woback"
  Tbls[118] = "Rpt\\Wobcklog"
  Tbls[119] = "Rpt\\Wosum"
  Tbls[120] = "Spm\\Spm"
  Tbls[121] = "Spm\\Spmdesc"
  Tbls[122] = "Spm\\Spmgraph"
  Tbls[123] = "Spm\\Spmvalue"
  Tbls[124] = "Task\\Expense"
  Tbls[125] = "Task\\Instr"
  Tbls[126] = "Task\\Mtsksub"
  Tbls[127] = "Task\\Multitsk"
  Tbls[128] = "Task\\Reqmt"
  Tbls[129] = "Task\\Task"
  Tbls[130] = "Wo\\Rfo"
  Tbls[131] = "Wo\\Wo"
  Tbls[132] = "Wo\\Woc"
  Tbls[133] = "Wo\\Woe"
  Tbls[134] = "Wo\\Wohist"
  Tbls[135] = "Wo\\Wohistc"
  Tbls[136] = "Wo\\Wohiste"
  Tbls[137] = "Wo\\Wohistp"
  Tbls[138] = "Wo\\Wohistv"
  Tbls[139] = "Wo\\Womtask"
  Tbls[140] = "Wo\\Wop"
  Tbls[141] = "Wo\\Wotype"
  Tbls[142] = "Wo\\Wov"
  Tbls[143] = "Work\\Crafthrs"
  Tbls[144] = "Work\\Genshort"
  Tbls[145] = "Work\\Isstrans"
  Tbls[146] = "Work\\Issue"
  Tbls[147] = "Work\\Pcheck"
  Tbls[148] = "Work\\Poxtract"
  Tbls[149] = "Work\\Poxvend"
  Tbls[150] = "Work\\Query"
  Tbls[151] = "Work\\Slevel"
  Tbls[152] = "Work\\Wohistwk"
  Tbls[153] = "Work\\Woxtract"

  Stop = DynArraySize(Tbls)             ; Assign stopping point to a variable
  FOR i From 1 To Stop                  ; Step thru each element of Tbls[]
    EmptyTable(Directory() + Tbls[i])   ; Call procedure to empty the table
    Reset
  ENDFOR
ENDPROC

;==============================================================================
; WarningMsg() - Display a warning message indicating that the database in the
; current directory will be emptied if the user continues.  Provide a menu so
; the user can continue with the process or quit.  Return True if Continue is
; selected, or False if Quit is selected.
;==============================================================================

PROC WarningMsg()
  Private c, Choice

  SetMargin 6                           ; Set text left margin
  PaintCanvas Attribute 7 9, 8, 16, 75  ; Paint the shadow
  Style Attribute SysColor(21)          ; Set colors of text box
  @ 8, 6                                ; Start text box on row 8
  Text
ͻ
                             WARNING                            
 This script will empty the Maintenance Pac 2 database in the     
                                                                  
 directory.  If this is permanent data that you want to keep,     
 Select Quit from the menu.  Otherwise select Continue to empty   
 the database tables.                                             
ͼ
  EndText
  SetMargin Off                                ; Reset margin to 0
  Style Attribute SysColor(23)                 ; Set color for  WARNING 
  @ 9, 35 ?? " WARNING "                     ; Show in other color
  Style                                        ; Set color to normal
  @ 11,  8 ?? Format("W64, AC", Directory())   ; Display other stuff in normal color
  @ 13, 15 ?? "Quit"
  @ 13, 53 ?? "Continue"
  WHILE CharWaiting()                          ; Empty the keyboard buffer
    c = Getchar()
  ENDWHILE
  ShowMenu
    "Quit"    : "Do NOT empty the database tables.",
    "Continue": "Go ahead and empty the database tables."
  To Choice
  Return Choice = "Continue"                   ; Return True if Continue
ENDPROC

WarningMsg()                                   ; Display warning & get response
IF Retval THEN                                 ; User says to continue
  Cursor Off                                   ; Turn cursor off
  Password ""                               ; Allow access to encrypted tbls
  EmptyAllTables()                             ; Do the dirty deed
  Unpassword ""                             ; Remove access to encrypted tbls
ENDIF

