/****************************************************************************/
/*                                                                          */
/*    PROGRAM NAME: SADMCMD                                                 */
/*    -------------                                                         */
/*    OS/2 Lan Server 3.0  API sample program.                              */
/*    @Copyright International Business Machines Corp. 1984, 1992           */
/*    @Copyright Microsoft Corp. 1984, 1991                                 */
/*                                                                          */
/*    What this program does: This program executes a command on a remote   */
/*    server. The command to be executed on the remote server is passed     */
/*    as a command line parameter to this program but it must reside        */
/*    on a disk visible to the target server.                               */
/*                                                                          */
/*    REQUIRED FILES:                                                       */
/*    ---------------                                                       */
/*    SADMCMD.C      -  Source code for this program                        */
/*                                                                          */
/*    REQUIRED LIBRARIES:                                                   */
/*    -------------------                                                   */
/*    NETAPI.LIB     -  Netapi library                                      */
/*                                                                          */
/*    NetAPI functions used in this program:                                */
/*    -------------------------------                                       */
/*    NetServerAdminCommand                                                 */
/*                                                                          */
/****************************************************************************/

/*------- OS/2 include files -----------------------------------------------*/
#define  INCL_BASE
#include <os2.h>

/*------- LAN Systems API Toolkit include files ----------------------------*/
#define  INCL_32                        /* use 32bit includes */
#include <lanserv\neterr.h>
#include <lanserv\netcons.h>
#include <lanserv\server.h>

/*------- C include files --------------------------------------------------*/
#define  __TILE__                       /* used tiled (16bit compat) memory */
#include <stdlib.h>
#include <memory.h>
#include <string.h>
#include <stdio.h>

/*------- Definitions ------------------------------------------------------*/
#define  BUFLEN 10000              /* output buffer size */


/****************************************************************************/
/* MAIN C function                                                          */
/*--------------------------------------------------------------------------*/
VOID main(argc, argv)
   int argc;
   char *argv[];
{
   USHORT   usRc          = 0;       /* return code */
   USHORT   usBytesRead   = 0;       /* number of bytes read */
   USHORT   usTotalAvail  = 0;       /* available entries */
   SHORT    sResult       = 0;       /* exit code of the executed command */
   USHORT   usCmdLen      = 0;       /* command line length */
   USHORT   usArgc;                  /* arguments counter */
   PCHAR    pcBuf;                   /* pointer to output buffer */
   PCHAR    pcCommand;               /* pointer to command buffer */
   CHAR     servername[CNLEN+1];     /* server name */

   strupr(argv[0]);
   if (argc < 3) {
      printf("\nUsage: %s <\\\\targetservername> <commands>\n",argv[0]);
      exit(1);
   } /* endif */

   strupr(argv[1]);
   strcpy(servername,argv[1]);

   /* calculate the size of command buffer */

   for (usArgc = 2; usArgc < argc ; usArgc++ ) {
       usCmdLen += strlen(argv[usArgc]) + 1;
   } /* endfor */

   /* allocate command buffer */

   pcCommand = (PCHAR )_tmalloc( usCmdLen);
   memset( pcCommand,'\x00',usCmdLen);

   /* fill command buffer with arguments from command line */

   strcpy(pcCommand,argv[2]);
   for (usArgc = 3; usArgc < argc ; usArgc++ ) {
       strcat(pcCommand," ");
       strcat(pcCommand,argv[usArgc]);
   } /* endfor */

   /* allocate output  buffer */

   pcBuf = (PCHAR )_tmalloc( BUFLEN);
   memset(pcBuf,'\x00',BUFLEN);

   printf("Command sent to %s is: %s\n",servername,pcCommand);

   /* call api function */

   usRc = NetServerAdminCommand (servername,    /* name of remote server */
                                 pcCommand,     /* command to be executed */
                                 &sResult,      /* returned exit code */
                                 pcBuf,         /* output buffer */
                                 BUFLEN,        /* output buffer size */
                                 &usBytesRead,  /* num of bytes returned */
                                 &usTotalAvail);/* num of bytes available */

   if (usRc != NERR_Success ) {
      if (usRc == ERROR_MORE_DATA) {
         printf("\nBytesread = %d TotalAvail = %d\n",
                   usBytesRead,usTotalAvail);
         printf("Output buffer is too small\n\n");
      } else {
         printf("NetServerAdminCommand usRc = %d\n",usRc);
         _tfree( pcBuf);
         _tfree( pcCommand);
         exit(usRc);
      } /* endif */
   } /* endif */

   /*************************************************************************/
   /* PLEASE NOTE THAT THE HIGH NIBBLE OF sRESULT IS ALWAYS 0               */
   /*-----------------------------------------------------------------------*/

   printf("Returned exit code = %d (HIGH NIBBLE IS ALWAYS 0)\n\n",sResult);

   /* print returned data */

   *(pcBuf+BUFLEN-1) = '\0';    /* make sure that  buffer ends with 0 */
   printf("%s\n",pcBuf);

   _tfree( pcBuf);
   _tfree( pcCommand);
   exit(0);
}


