/****************************************************************************/
/*                                                                          */
/*    PROGRAM NAME: ML                                                      */
/*    -------------                                                         */
/*    OS/2 Lan Server 3.0  API sample program.                              */
/*    @Copyright International Business Machines Corp. 1984, 1992           */
/*    @Copyright Microsoft Corp. 1984, 1991                                 */
/*                                                                          */
/*    What this program does: It logs on a user.                            */
/*    User name, password (if required), and domain name are passed         */
/*    on the command line.                                                  */
/*                                                                          */
/*    REQUIRED FILES:                                                       */
/*    ---------------                                                       */
/*    ML.C            -  Source code for this program                       */
/*                                                                          */
/*    REQUIRED LIBRARIES:                                                   */
/*    -------------------                                                   */
/*    UPM.LIB         -  UPM library                                        */
/*                                                                          */
/****************************************************************************/

/*------- OS/2 include files -----------------------------------------------*/
#define INCL_BASE
#include <os2.h>

/*------- LAN Systems API Toolkit include files ----------------------------*/
#define INCL_32               /* use 32bit includes */
#include <lanserv\upm.h>

/*------- C include files --------------------------------------------------*/
#include <stdio.h>
#include <string.h>



/****************************************************************************/
/* MAIN C function                                                          */
/*--------------------------------------------------------------------------*/
main(argc, argv)
   int argc;
   char *argv[];
{
USHORT      usRc;
USHORT      usIndex;
HKBD        KbdHandle;
KBDKEYINFO  CharData;

    strupr(argv[0]);
    if (argc < 3) {            /* not enough parameters */
       printf("Usage: %s <username> <password> <domainname>\n",argv[0]);
       printf("                or\n");
       printf("Usage: %s <username> <domainname>\n",argv[0]);
       exit(0);
    } /* endif */

   printf("%s logon in progress\n",argv[0]);

   if (argc==4) {             /* <username> <password> <domainname> */

      strupr(argv[2]);        /* password must be UPPERCASE */

      usRc = UPMGLGN(
       strlen(argv[1]),       /*  userid length     */
       strlen(argv[2]),       /*  password length   */
       strlen(argv[3]),       /*  remotename length */
       UPM_DOMAIN,            /*  remotetype        */
       UPM_USER,              /*  authcheck         */
       argv[1],               /*  userid            */
       argv[2],               /*  password          */
       argv[3]);              /*  remotename        */

   } else {                   /* <username> <domainname> */

      usRc = UPMGLGN(
       strlen(argv[1]),       /*  userid length     */
       0,                     /*  password length   */
       strlen(argv[2]),       /*  remotename length */
       UPM_DOMAIN,            /*  remotetype        */
       UPM_USER,              /*  authcheck         */
       argv[1],               /*  userid            */
       NULL,                  /*  password          */
       argv[2]);              /*  remotename        */

   } /* endif */

   if (usRc == 0) {
      printf("%s you are now logged on\n",argv[0]);
   } else {
      printf("UPMGLGN usRc = %X\n",usRc);
      exit(usRc);
   } /* endif */

}

