/***************************************************************************/
/*                                                                         */
/*    PROGRAM NAME: FILEENUM                                               */
/*    -------------                                                        */
/*    OS/2 Lan Server 3.0  API sample program.                             */
/*    @Copyright International Business Machines Corp. 1984, 1992          */
/*    @Copyright Microsoft Corp. 1984, 1991                                */
/*                                                                         */
/*    What this program does:                                              */
/*                It gets information on all files within a given          */
/*                filepath that have been opened by a specific user.       */
/*                Both the path and the userid may be left unspecified     */
/*                to get information on all files opened by all users      */
/*                on the specified server.                                 */
/*                                                                         */
/*                The program must be executed by an administrator         */
/*                and may execute either locally or remotely.              */
/*                                                                         */
/*    REQUIRED FILES:                                                      */
/*    ---------------                                                      */
/*    FILEENUM.MAK    - IBM C-Set/2 NMAKE File                             */
/*    FILEENUM.C      - C source code for the main program.                */
/*    ERRMSG.C        - C source code for the Error_Message function.      */
/*                                                                         */
/*    REQUIRED LIBRARIES:                                                  */
/*    -------------------                                                  */
/*    NETAPI.LIB     -  Netapi library for OS/2                            */
/*                       (in the APITK\OS2\LIB directory).                 */
/*                                                                         */
/*    NetAPI functions used in this program :                              */
/*    ---------------------------------------                              */
/*    NetFileEnum2                                                         */
/*                                                                         */
/***************************************************************************/

/*------------------ OS/2 Include definitions -----------------------------*/
#define  INCL_BASE
#include <os2.h>
#include <limits.h>

/*------------LAN Systems API Toolkit Include definitions -----------------*/
#define  INCL_32                   /* use LS 32bit includes */
#include <lanserv\netcons.h>
#include <lanserv\shares.h>
#include <lanserv\neterr.h>

/*--------------------- C Include definitions -----------------------------*/
#define __TILE__
#include <stdlib.h>
#include <stdio.h>
#include <memory.h>

/*--------------------- Function Declarations ------------------------------*/

VOID Error_Message( USHORT, PSZ);



/****************************************************************************/
/* Main C Function                                                          */
/*--------------------------------------------------------------------------*/

VOID main(argc, argv)
USHORT argc;
PCHAR  argv[];
{
  USHORT                  usRc             = 0; /* API return code         */
  USHORT                  usEntriesprinted = 1;
  PCHAR                   pchServername = NULL; /* Server name             */
  PCHAR                   pchBasepath   = NULL; /* Root of path for files  */
  PCHAR                   pchUsername   = NULL; /* Userid                  */
  SHORT                   sLevel              ; /* API structure level used*/
  struct file_info_3 LSFAR *pchBuf              ; /* FileInfo buffer         */
  USHORT                  usBuflen         = 0; /* Size of FileInfo buffer */
  USHORT                  usEntriesread    = 0; /* Number of entries read  */
  USHORT                  usTotalentries   = 0; /* Total entries available */
  FRK                     frkResume_key       ; /* FRK is defined
                                                   in SHARES.H as
                                        typedef struct res_file_enum_2 FRK */

  /* Check the validity of the input parameters.                           */
  /*                                                                       */

  if ( argc >= 2) {
     if ( *argv[1] != '\\' && * argv[1] != 'N') {
           usRc = 1;
           printf("Invalid Servername format. \n");
     }
     else
        if ( *argv[1] == 'N')
           pchServername = NULL;
        else
           pchServername = argv[1];
     if ( argc >=3 ) {
        if ( *(argv[2]+1) == ':')
           pchBasepath = argv[2];
        else {
           usRc = 1;
           printf(" Invalid Basepath format.\n");
        }
        if ( argc == 4 )
           pchUsername = argv[3];
        else {
           usRc = 1;
           printf(" Incorrect number of arguments.\n");
        } /* endif */
     } /* endif */
  } /* endif */
  else
     usRc = 1;

  /* If the input parameters are invalid, give instructions and exit.      */

  if ( usRc != 0) {
        printf(" \n");
        printf(" For a remote server, the correct format is :");
        printf("    %s <servername> <Basepath> <Username>\n",argv[0]);
        printf(" For a local server, the correct format is  :");
        printf("    %s <NULL> <Basepath> <Username>\n",argv[0]);
        printf(" OR %s \n\n",argv[0]);

        printf(" Servername : \\\\<server machinename>\n");
        printf(" Basepath   : <drive>:\\<pathname> \n");

        DosExit(EXIT_PROCESS, 0);
     }

  sLevel        = 3;            /* Use information level 3                 */

  FRK_INIT( frkResume_key);     /* Initialize the resume key to enable     */
                                /* retrieval of information that exceeds   */
                                /* the 64 K buffer size limit.             */

  usRc = NetFileEnum2( pchServername   /* Initial call to establish the    */
                     , pchBasepath     /* amount of information available. */
                     , pchUsername
                     , sLevel
         , (PCHAR LSFAR) pchBuf
                     , usBuflen
                     ,&usEntriesread
                     ,&usTotalentries
                     ,&frkResume_key);

  if ( ((sizeof(struct file_info_3)+(UNLEN+1L)+PATHLEN)*usTotalentries)
      > USHRT_MAX) {

     /* NOTE: DosAllocSeg allocates 64 Kb of space if the first argument   */
     /*       is set equal to 0.                                           */

     usBuflen = USHRT_MAX;
  }
  else {
     usBuflen = (sizeof(struct file_info_3)+(UNLEN+1)+PATHLEN)*usTotalentries;
  }

  pchBuf = (struct file_info_3 *)_tmalloc( usBuflen);

  /* Continue to issue NetFileEnum2 calls until all information has been   */
  /* retrieved.                                                            */

  do {

     memset( pchBuf, '\x00', usBuflen); /* Clear the buffer by filling     */
                                        /* it with zeros.                  */

     usRc = NetFileEnum2( pchServername
                        , pchBasepath
                        , pchUsername
                        , sLevel
            , (PCHAR LSFAR) pchBuf
                        , usBuflen
                        ,&usEntriesread
                        ,&usTotalentries
                        ,&frkResume_key);

     switch ( usRc ) {

     case NERR_Success:
     case ERROR_MORE_DATA:
        printf("Servername     : %s\n",pchServername);
        printf("Basepath       : %s\n",pchBasepath);
        printf("Username       : %s\n",pchUsername);
        printf("Level          : %d\n",sLevel);
        printf("Return code from NetFileEnum2 : %d\n",usRc);
        printf("Entries read   : %d\n",usEntriesread);
        printf("Total entries  : %d\n",usTotalentries);

        if (usEntriesread != 0) {

           printf("Server type    : %d\n",frkResume_key.res_fs);
           printf("Progressive    : %ld\n",frkResume_key.res_pro);
           usEntriesprinted = 1;

           /* Print out all entries in a given buffer                         */

           do {
              printf("\n");
              printf("/----------------\\\n");
              printf("| File ID Number : %ld\n",pchBuf->fi3_id);

              printf("| App.Permissions: %02X(hex) =>",pchBuf->fi3_permissions);

              if ((pchBuf->fi3_permissions & PERM_FILE_READ) != 0)
                 printf(" Read");
              if ((pchBuf->fi3_permissions & PERM_FILE_WRITE) != 0)
                 printf(" Write");
              if ((pchBuf->fi3_permissions & PERM_FILE_CREATE) != 0)
                 printf(" Create");
              printf("\n");

              printf("| # of File locks: %d\n",pchBuf->fi3_num_locks);
              printf("| Pathname       : %s\n",pchBuf->fi3_pathname);
              printf("| Username       : %s\n",pchBuf->fi3_username);
              printf("\\----------------/\n");
              pchBuf++;
           } while (++usEntriesprinted <= usEntriesread ); /* enddo */
        } /* endif */
        break;
     default :
        Error_Message(usRc,"NetFileEnum2");/* Send an error message        */
        break;
     } /*endswitch*/

  } while(usRc == ERROR_MORE_DATA);/* enddo */

  _tfree( pchBuf);

}
