/***************************************************************************/
/*                                                                         */
/*    PROGRAM NAME: ERRMSG                                                 */
/*    -------------                                                        */
/*    OS/2 Lan Server 3.0  API sample program.                             */
/*    @Copyright International Business Machines Corp. 1984, 1992          */
/*    @Copyright Microsoft Corp. 1984, 1991                                */
/*                                                                         */
/*    What this program does:                                              */
/*                     It provides a common detailed error message         */
/*                generation function for programs using the NetAPI        */
/*                functions and return codes.                              */
/*                                                                         */
/*    REQUIRED FILES:                                                      */
/*    ---------------                                                      */
/*    ERRMSG.C        - C source code for the Error_Message function.      */
/*                                                                         */
/*    REQUIRED LIBRARIES:                                                  */
/*    -------------------                                                  */
/*    NETAPI.LIB     -  NetAPI library for OS/2                            */
/*                      (in the APITK\OS2\LIB directory)                   */
/*                                                                         */
/*    NetAPI functions used in this program :                              */
/*    ---------------------------------------                              */
/*                                                                         */
/*    None.                                                                */
/*                                                                         */
/***************************************************************************/

/*------------------ OS/2 Include definitions -----------------------------*/
#define  INCL_BASE
#include <os2.h>

/*--------------LAN Systems API ToolKit Include definitions ---------------*/
#define  INCL_32                        /* use 32bit includes */
#include <lanserv\neterr.h>

/*--------------------- C Include definitions ------------------------------*/
#include <stdio.h>

/****************************************************************************/
/* Error_Message Function                                                   */
/*    Gives a detailed error message (in the case of common errors)         */
/*   and halts execution when the supplied return code indicates failure.   */
/*--------------------------------------------------------------------------*/

VOID Error_Message( USHORT usRc, PSZ pszNetAPIName)
{

  switch (usRc) {
  case  NERR_Success :
     break;
  case ERROR_BAD_NETPATH :
     printf("%s return code : %d - The network path cannot be found\n",
     pszNetAPIName,usRc);
     printf("Possible cause: The server is not started or does not exist.\n");
     break;
  case NERR_BufTooSmall   :
     printf("%s return code : %d - The buffer is too small for",
     pszNetAPIName,usRc);
     printf(" fixed-length data.\n");
     break;
  case NERR_ResourceNotFound :
     printf("%s return code : %d - The network resource cannot be found\n",
     pszNetAPIName,usRc);
     break;
  case NERR_RemoteOnly:
     printf("%s return code : %d - This operation is not supported on\n",
     pszNetAPIName,usRc);
     printf("                      workstations.\n");
     break;
  case NERR_DeviceNotShared:
     printf("%s return code : %d - Device not shared\n",pszNetAPIName,usRc);
     printf("                   or device does not exist.\n");
     break;
  case NERR_WkstaNotStarted :
     printf("%s return code : %d - Requester service not started.\n",
     pszNetAPIName,usRc);
     break;
  case NERR_NetNameNotFound:
     printf("%s return code : %d - Netname not found.\n",pszNetAPIName,usRc);
     printf("            The Netname is not shared \n");
     printf("         or the Netname does not exist.\n");
     break;
  case ERROR_ACCESS_DENIED :
     printf("%s return code : %d - Access denied.\n",pszNetAPIName,usRc);
     printf("            Administrator privilege is required.\n");
     break;
  default :
     printf("Unexpected return code from %s : %d\n", pszNetAPIName, usRc);
     break;
  } /* endswitch */

  if (usRc != NERR_Success)
     DosExit(EXIT_PROCESS, usRc);

} /* end Error_Message */

