/**************************************************************************

   Module Name    = UPM.H

   Descriptive Name = User Profile Management Include file

   (C) Copyright IBM Corporation 1988, 1992.  All rights reserved.
   (C) Copyright Microsoft Corporation 1988, 1991.  All rights reserved.
   Licensed Material - Program Property of IBM

   Function = Include File defining Api Logon/Logoff

   Operating System = OS/2

**************************************************************************/

/*
*
*    IMPORTANT!  IMPORTANT! IMPORTANT! IMPORTANT! IMPORTANT! IMPORTANT!
*    READ THIS FIRST BEFORE MAKING ANY CHANGES
*
*    This file was modified to provide support for 32-bit code.
*
*    Any 32-bit module that includes this header file must define
*    the constant INCL_32.
*
*    Do not add any keywords like far, pascal, etc. which are not
*    recognized by the 32-bit compiler. The constants defined below
*    must be used to replace these keywords.
*
*    #ifdef INCL_32    ( defined by 32-bit apps )
*        #define LSFAR
*        #define LSPAS
*        #define LSPTR  _Seg16
*        #define LSINT  short
*    #else                 ( for 16-bit apps )
*        #define LSFAR  far
*        #define LSPAS  pascal
*        #define LSPTR
*        #define LSINT  int
*    #endif
*
*/

#ifdef  INCL_32
  #pragma pack(1)
  #define LSFAR
  #define LSPAS
  #define LSPTR  _Seg16
  #define LSINT  short
#else
  #define LSFAR  far
  #define LSPAS  pascal
  #define LSPTR
  #define LSINT  int
#endif

#define upmelgn  UPMELGN
#define upmelgff UPMELGFF
#define upmelocu UPMELOCU
#define upmelocl UPMELOCL
#define upmeulgn UPMEULGN
#define upmeulgf UPMEULGF
#define upmeusrl UPMEUSRL
#define upmesetp UPMESETP
#define upmegetp UPMEGETP
#define upmglgn  UPMGLGN
#define upmgulgn UPMGULGN
#define upmglgff UPMGLGFF
#define upmgulgf UPMGULGF
#define upmglocu UPMGLOCU
#define upmglocl UPMGLOCL
#define upmgusrl UPMGUSRL

/*
     String lengths
*/
#define UPM_UIDLEN    10

/*
The following password length applies to user logon profile entries only.
*/
#define UPM_PWDLEN    10
#define UPM_REMLEN    17

/*
     Log (generic) an application process on the the system
*/

LSINT LSFAR LSPAS UPMGLGN(
            unsigned short,        /*  userid length     */
            unsigned short,        /*  password length   */
            unsigned short,        /*  remotename length */
            unsigned short,        /*  remotetype        */
            unsigned short,        /*  authcheck         */
            unsigned char LSFAR *,   /*  userid            */
            unsigned char LSFAR *,   /*  password          */
            unsigned char LSFAR *);  /*  remotename        */

/*
     Log (generic) a user on to the system
*/
LSINT LSFAR LSPAS UPMGULGN(
            unsigned short,          /*  userid length     */
            unsigned short,          /*  password length   */
            unsigned short,          /*  remotename length */
            unsigned short,          /*  remotetype        */
            unsigned short,          /*  flags             */
            unsigned char LSFAR *,   /*  userid            */
            unsigned char LSFAR *,   /*  password          */
            unsigned char LSFAR *);  /*  remotename        */
/*
     Log (generic) an application process off the system
*/

LSINT LSFAR LSPAS UPMGLGFF(
            unsigned short,          /*  userid length     */
            unsigned short,          /*  remotename length */
            unsigned short,          /*  remotetype        */
            unsigned char LSFAR *,   /*  userid            */
            unsigned char LSFAR *);  /*  remotename        */

/*
     Log (generic) a user off the system
*/

LSINT LSFAR LSPAS UPMGULGF(
            unsigned short,          /*  userid length     */
            unsigned short,          /*  remotename length */
            unsigned short,          /*  remotetype        */
            unsigned char LSFAR *,   /*  userid            */
            unsigned char LSFAR *);  /*  remotename        */

/*
     Get (generic) locally logged on user ID.
*/

LSINT LSFAR LSPAS UPMGLOCU(
            unsigned short *,       /*  userid length     */
            unsigned char LSFAR *,  /*  userid            */
            unsigned short *);      /*  user type         */
/*
     Logon (generic) a local user ID.
*/

LSINT LSFAR LSPAS UPMGLOCL(
            unsigned short *,         /*  userid length     */
            unsigned char LSFAR *,    /*  userid            */
            unsigned short *);        /*  user type         */

/*
     (generic) logon user list
*/
LSINT LSFAR LSPAS UPMGUSRL(
            unsigned short,          /*  remotename length */
            unsigned short,          /*  remotetype        */
            unsigned short,          /*  bufferlen         */
            unsigned short LSFAR *,  /*  entriesread */
            unsigned short LSFAR *,  /*  totalentry  */
            unsigned char LSFAR *,   /*  remotename  */
            unsigned char LSFAR *);  /*  buffer      */

/*
     Log an application process on the the system
*/
LSINT LSFAR LSPAS UPMELGN(
            unsigned char LSFAR *,   /*  userid      */
            unsigned char LSFAR *,   /*  password     */
            unsigned char LSFAR *,   /*  remotename  */
            unsigned short,          /*  remotetype  */
            unsigned short );        /*  authcheck   */

/*
     Log an application process off the system
*/
LSINT LSFAR LSPAS UPMELGFF(
            unsigned char LSFAR *,   /*  userid      */
            unsigned char LSFAR *,   /*  remotename  */
            unsigned short );        /*  remotetype  */
/*
     Get the local user ID logged on the system
*/
LSINT LSFAR LSPAS UPMELOCU(
            unsigned char LSFAR *,   /*  userid      */
            unsigned short *);       /*  type  */
/*
     Logon a local user ID on the system
*/
LSINT LSFAR LSPAS UPMELOCL(
            unsigned char LSFAR *,   /*  userid      */
            unsigned short *);       /*  type  */

/*
     Log a user on the system
*/
LSINT LSFAR LSPAS UPMEULGN(
            unsigned char LSFAR *,   /*  userid      */
            unsigned char LSFAR *,   /*  password    */
            unsigned char LSFAR *,   /*  remotename  */
            unsigned short,          /*  remotetype  */
            unsigned short );        /*  flags       */

/*
     Log a user off the system
*/
LSINT LSFAR LSPAS UPMEULGF(
            unsigned char LSFAR *,   /*  userid      */
            unsigned char LSFAR *,   /*  remotename  */
            unsigned short );        /*  remotetype  */
/*
     Logged on user list
*/

LSINT LSFAR LSPAS UPMEUSRL(
            unsigned char LSFAR *,     /*  remotename  */
            short,                     /*  remotetype  */
            char LSFAR *,              /*  buffer      */
            unsigned short,            /*  bufferlen   */
            unsigned short LSFAR *,    /*  entriesread */
            unsigned short LSFAR * );  /*  totalentry  */

/*
     Set a Users logon profile
*/

LSINT LSFAR LSPAS UPMESETP (
            unsigned char LSFAR *,     /*  userid      */
            char LSFAR *,              /*  buffer      */
            unsigned short,            /*  entries     */
            unsigned short );          /*  level       */

/*
     Get a Users logon profile
*/

LSINT LSFAR LSPAS UPMEGETP (
            unsigned char LSFAR *,     /*  userid      */
            char LSFAR *,              /*  buffer      */
            unsigned short,            /*  bufferlen   */
            unsigned short LSFAR *,    /*  entriesread */
            unsigned short LSFAR *,    /*  totalavail  */
            unsigned short);           /*  level       */

/*
     User logon structure for UPMGUSRL
*/

struct UPM_G_USER_LOGON
       {
         unsigned short useridlen;
         unsigned short remotelen;
         unsigned short remotetype;
         LSINT          sessionid;
         char           userid[UPM_UIDLEN + 1];
         char           remotename[UPM_REMLEN + 1];
       };

/*
     User logon structure for upmeusrl
*/

struct UPM_USER_LOGON
       {
         char    userid[UPM_UIDLEN + 1];
         short   remotetype;
         char    remotename[UPM_REMLEN + 1];
         LSINT   sessionid;
       };

/*
     User logon profile structure for upmegetp and upmesetp
*/

struct UPM_USER_LOGON_PROF_0 {
          unsigned char userid[ UPM_UIDLEN + 1];
          unsigned char password[ UPM_PWDLEN + 1];
          unsigned char remotename[ UPM_REMLEN + 1];
          unsigned short remotetype;
          };

/*
     Valid values for the remotetype parameter
*/
#define UPM_LOCAL            1
#define UPM_DNODE            2
#define UPM_DOMAIN           3
/*
     Additional remotetype value for upmeulgf
*/
#define UPM_DOMAIN_MAX_FORCE 4

/*
     Verbose upmeulgn (1.3.x style)
*/
#define UPM_DOMAIN_VERBOSE   5

/*
     Additional remotetype values for upmeusrl
*/
#define UPM_LOCAL_HPFS     21
#define UPM_ALL            22

/*
     Lan Server logon flags for UPMEULGN.
     If UPM_FL_LOCVER or UPM_FL_NOVER is specified remotename must null.
*/

#define UPM_FL_LOCVER               0x01   /* Local verification  */
#define UPM_FL_NOVER                0x02   /* No verification     */
#define UPM_FL_DOMVER               0x03   /* Domain verification */

/*
     Valid values for the authcheck parameter
*/
#define UPM_CONFIG         1
#define UPM_ADMIN          2
#define UPM_USER           3

/*
     Valid user type privilege levels
*/
#define UPM_PRIV_USER         1
#define UPM_PRIV_ADMIN        2
#define UPM_PRIV_LOCAL_ADMIN  9
/*
     Return values

     Note:  These values are all negative.  Any positive return
           value signifies an unexpected OS/2 system level error
           occurred.  The positive value is the OS/2 return code.
*/
#define UPM_OK                 0      /* Successful.                         */
#define UPM_LOG_INPROC         0xFB01 /* Another logon is in process.        */
#define UPM_BAD_TYPE           0xFB02 /* Bad remotetype.                     */
#define UPM_NOMEM              0xFB03 /* Cannot allocate required memory.    */
#define UPM_LOG_FILE_NOT_FOUND 0xFB04 /* An execute file could not be found. */
#define UPM_FAIL_SECURITY      0xFB05 /* User not logged, failed security
                                         clearance.                          */
#define UPM_BAD_PARAMETER      0xFB06 /* A parameter passed was invalid.     */
#define UPM_BAD_AUTHCHECK      0xFB07 /* Authcheck was not valid.            */
#define UPM_LOG_CANCEL         0xFB08 /* User has canceled from the logon
                                         panel.                              */
#define UPM_NOT_LOGGED         0xFB10 /* A logon has not occured for this
                                         userid.                             */
#define UPM_LOGGED             0xFB12 /* A domain logon is currently active. */
#define UPM_SYS_ERROR          0xFB13 /* An unexpected system error.         */
#define UPM_OPEN_SESSIONS      0xFB14 /* The domain logoff failed, The domain
                                         logon has active sessions.          */
#define UPM_ULP_LOADED         0xFB15 /* The local logon failed, a local
                                         logon with a user logon profile is
                                         active.                             */
#define UPM_LOGGED_ELSEWHERE   0xFB16 /* The domain logon failed, the userid
                                         is already logged on the domain.    */
#define UPM_PASSWORD_EXP       0xFB17 /* The users password is expired.      */
#define UPM_UNAVAIL            0xFB18 /* The logon failed, The remote node
                                         or server could not be contacted to
                                         process the logon request.          */
#define UPM_ACTIVE             0xFB19 /* The domain logon or logoff failed,
                                         a domain logon, logoff or net
                                         command is in process.              */
#define UPM_SS_PWDEXPWARNING   0xFB20 /* The local logon succeeded. The users
                                         password is expired.                */
#define UPM_SS_BUSY            0xFB21 /* The local logon failed. The Local
                                         security was busy.                     */
#define UPM_SS_DEAD            0xFB22 /* The local logon failed. Local
                                         security has terminated unexpectedly.  */
#define UPM_ERROR_MORE_DATA    0xFB23 /* More data is available, the buffer
                                         provided is not large enough.       */
#define UPM_MAX_ENT_EXCEEDED   0xFB24 /* Update failed, the input buffer
                                         contains more than 16 entries.      */
#define UPM_DUP_ULP_ENTRY      0xFB25 /* Two or more entries with the same
                                         remote name and user ID were
                                         detected.                           */
#define UPM_MAX_ULP_EXCEEDED   0xFB26 /* Database contains maximum number
                                         entries                             */
#define UPM_NODISK             0xFB27 /* Insufficient disk space was available to
                                         process this request   */
#define UPM_PROF_NOT_FOUND     0xFB28 /* Did not find user logon profile for
                                         user ID. */
#define UPM_ERROR_NONVAL_LOGON 0xFB29 /* Non validated Lan Server logons are not
                                         allowed with server service started  */





#ifdef  INCL_32
#pragma linkage (UPMGLGN,  far16 pascal)
#pragma linkage (UPMGULGN, far16 pascal)
#pragma linkage (UPMGLGFF, far16 pascal)
#pragma linkage (UPMGULGF, far16 pascal)
#pragma linkage (UPMGLOCU, far16 pascal)
#pragma linkage (UPMGLOCL, far16 pascal)
#pragma linkage (UPMGUSRL, far16 pascal)
#pragma linkage (UPMELGN,  far16 pascal)
#pragma linkage (UPMELGFF, far16 pascal)
#pragma linkage (UPMELOCU, far16 pascal)
#pragma linkage (UPMELOCL, far16 pascal)
#pragma linkage (UPMEULGN, far16 pascal)
#pragma linkage (UPMEULGF, far16 pascal)
#pragma linkage (UPMEUSRL, far16 pascal)
#pragma linkage (UPMESETP, far16 pascal)
#pragma linkage (UPMEGETP, far16 pascal)
#pragma pack()
#endif

