/**************************************************************************/
/*                                                                        */
/*              IBM OS/2(tm) Local Area Network (LAN) Server              */
/*                            Version 3.0                                 */
/* (c) Copyright International Business Machines Corporation, 1988, 1992  */
/*                                                                        */
/**************************************************************************/

/********************************************************************
 *								    *
 *  About this file ...  SHARES.H				    *
 *								    *
 *  This file contains information about the NetShare, NetSession,  *
 *  NetFile, and NetConnection APIs.  For each API class there is   *
 *  a section on:						    *
 *								    *
 *	Function prototypes.					    *
 *								    *
 *	Data structure templates.				    *
 *								    *
 *	Definition of special values.				    *
 *								    *
 *								    *
 *  NOTE:  You must include NETCONS.H before this file, since this  *
 *	   file	depends on values defined in NETCONS.H.		    *
 *								    *
 *	   This file is always included by LAN.H.		    *
 *								    *
 ********************************************************************/


#ifdef  INCL_32
#pragma pack(1)
#endif



/****************************************************************
 *								*
 *	  	Share Class			                *
 *								*
 ****************************************************************/

#if (defined( INCL_NETSHARE ) || !defined( LAN_INCLUDED )) \
    && !defined( NETSHARE_INCLUDED )

#define NETSHARE_INCLUDED

/****************************************************************
 *                                                              *
 *              Function prototypes - SHARE                     *
 *                                                              *
 ****************************************************************/

extern API_FUNCTION
  NetShareAdd ( const char LSFAR * pszServer,
                short              sLevel,
                const char LSFAR * pbBuffer,
                unsigned short     cbBuffer );

extern API_FUNCTION
  NetShareCheck ( const char LSFAR *     pszServer,
                  const char LSFAR *     pszDeviceName,
                  unsigned short LSFAR * pusType );

extern API_FUNCTION
  NetShareDel ( const char LSFAR * pszServer,
                const char LSFAR * pszNetName,
                unsigned short     usReserved );

extern API_FUNCTION
  NetShareEnum ( const char LSFAR *     pszServer,
                 short                  sLevel,
                 char LSFAR *           pbBuffer,
                 unsigned short         cbBuffer,
                 unsigned short LSFAR * pcEntriesRead,
                 unsigned short LSFAR * pcTotalAvail );

extern API_FUNCTION
  NetShareGetInfo ( const char LSFAR *     pszServer,
                    const char LSFAR *     pszNetName,
                    short                  sLevel,
                    char LSFAR *           pbBuffer,
                    unsigned short         cbBuffer,
                    unsigned short LSFAR * pcbTotalAvail );

extern API_FUNCTION
  NetShareSetInfo ( const char LSFAR * pszServer,
                    const char LSFAR * pszNetName,
                    short              sLevel,
                    const char LSFAR * pbBuffer,
                    unsigned short     cbBuffer,
                    short              sParmNum );


/****************************************************************
 *								*
 *	  	Data structure templates - SHARE		*
 *								*
 ****************************************************************/

struct share_info_0 {
    char		shi0_netname[NNLEN+1];
};  /* share_info_0 */

struct share_info_1 {
    char               shi1_netname[NNLEN+1];
    char               shi1_pad1;
    unsigned short     shi1_type;
    char LSFAR * LSPTR shi1_remark;
};  /* share_info_1 */

struct share_info_2 {
    char               shi2_netname[NNLEN+1];
    char               shi2_pad1;
    unsigned short     shi2_type;
    char LSFAR * LSPTR shi2_remark;
    unsigned short     shi2_permissions;
    unsigned short     shi2_max_uses;
    unsigned short     shi2_current_uses;
    char LSFAR * LSPTR shi2_path;
    char               shi2_passwd[SHPWLEN+1];
    char               shi2_pad2;
};  /* share_info_2 */


/****************************************************************
 *								*
 *	  	Special values and constants - SHARE		*
 *								*
 ****************************************************************/


/*
 *	Values for parmnum parameter to NetShareSetInfo.
 */

#define	SHI_REMARK_PARMNUM		4
#define	SHI_PERMISSIONS_PARMNUM		5
#define	SHI_MAX_USES_PARMNUM		6
#define	SHI_PASSWD_PARMNUM		9

#define	SHI1_NUM_ELEMENTS		4
#define	SHI2_NUM_ELEMENTS		10


/*
 *	Share types (shi1_type and shi2_type fields).
 */

#define STYPE_DISKTREE 			0
#define STYPE_PRINTQ   			1
#define STYPE_DEVICE   			2
#define STYPE_IPC      			3

#define SHI_USES_UNLIMITED		-1

#endif /* NETSHARE_INCLUDED */


/****************************************************************
 *								*
 *	  	Session Class			                *
 *								*
 ****************************************************************/

#if (defined( INCL_NETSESSION ) || !defined( LAN_INCLUDED )) \
    && !defined( NETSESSION_INCLUDED )

#define NETSESSION_INCLUDED


/****************************************************************
 *                                                              *
 *              Function prototypes - SESSION                   *
 *                                                              *
 ****************************************************************/

extern API_FUNCTION
  NetSessionDel ( const char LSFAR * pszServer,
                  const char LSFAR * pszClientName,
                  short              sReserved );

extern API_FUNCTION
  NetSessionEnum ( const char LSFAR *     pszServer,
                   short                  sLevel,
                   char LSFAR *           pbBuffer,
                   unsigned short         cbBuffer,
                   unsigned short LSFAR * pcEntriesRead,
                   unsigned short LSFAR * pcTotalAvail );

extern API_FUNCTION
  NetSessionGetInfo ( const char LSFAR *     pszServer,
                      const char LSFAR *     pszClientName,
                      short                  sLevel,
                      char LSFAR *           pbBuffer,
                      unsigned short         cbBuffer,
                      unsigned short LSFAR * pcbTotalAvail );


/****************************************************************
 *								*
 *		Data structure templates - SESSION		*
 *								*
 ****************************************************************/


struct session_info_0 {
    char LSFAR * LSPTR sesi0_cname;
};  /* session_info_0 */

struct session_info_1 {
    char LSFAR * LSPTR sesi1_cname;
    char LSFAR * LSPTR sesi1_username;
    unsigned short     sesi1_num_conns;
    unsigned short     sesi1_num_opens;
    unsigned short     sesi1_num_users;
    unsigned long      sesi1_time;
    unsigned long      sesi1_idle_time;
    unsigned long      sesi1_user_flags;
};  /* session_info_1 */

struct session_info_2 {
    char LSFAR * LSPTR sesi2_cname;
    char LSFAR * LSPTR sesi2_username;
    unsigned short     sesi2_num_conns;
    unsigned short     sesi2_num_opens;
    unsigned short     sesi2_num_users;
    unsigned long      sesi2_time;
    unsigned long      sesi2_idle_time;
    unsigned long      sesi2_user_flags;
    char LSFAR * LSPTR sesi2_cltype_name;
};  /* session_info_2 */

struct session_info_10 {
        char LSFAR * LSPTR sesi10_cname;
        char LSFAR * LSPTR sesi10_username;
        unsigned long      sesi10_time;
        unsigned long      sesi10_idle_time;
};  /* session_info_10 */





/****************************************************************
 *								*
 *	  	Special values and constants - SESSION		*
 *								*
 ****************************************************************/

/*
 *	Bits defined in sesi1_user_flags.
 */

#define SESS_GUEST		1	/* session is logged on as a guest */
#define SESS_NOENCRYPTION	2	/* session is not using encryption */


#define SESI1_NUM_ELEMENTS	8
#define SESI2_NUM_ELEMENTS	9

#endif /* NETSESSION_INCLUDED */


/****************************************************************
 *								*
 *	  	Connection Class			        *
 *								*
 ****************************************************************/

#if (defined( INCL_NETCONNECTION ) || !defined( LAN_INCLUDED )) \
    && !defined( NETCONNECTION_INCLUDED )

#define NETCONNECTION_INCLUDED


/****************************************************************
 *                                                              *
 *              Function prototypes - CONNECTION                *
 *                                                              *
 ****************************************************************/

extern API_FUNCTION
  NetConnectionEnum ( const char LSFAR *     pszServer,
                      const char LSFAR *     pszQualifier,
                      short                  sLevel,
                      char LSFAR *           pbBuffer,
                      unsigned short         cbBuffer,
                      unsigned short LSFAR * pcEntriesRead,
                      unsigned short LSFAR * pcTotalAvail );


/****************************************************************
 *								*
 *	  	Data structure templates - CONNECTION		*
 *								*
 ****************************************************************/

struct connection_info_0 {
    unsigned short	coni0_id;
};  /* connection_info_0 */

struct connection_info_1 {
    unsigned short     coni1_id;
    unsigned short     coni1_type;
    unsigned short     coni1_num_opens;
    unsigned short     coni1_num_users;
    unsigned long      coni1_time;
    char LSFAR * LSPTR coni1_username;
    char LSFAR * LSPTR coni1_netname;
};  /* connection_info_1 */

#endif /* NETCONNECTION_INCLUDED */


/****************************************************************
 *								*
 *	  	File Class			                *
 *								*
 ****************************************************************/

#if (defined( INCL_NETFILE ) || !defined( LAN_INCLUDED )) \
    && !defined( NETFILE_INCLUDED )

#define NETFILE_INCLUDED


/****************************************************************
 *                                                              *
 *              Function prototypes - FILE                      *
 *                                                              *
 ****************************************************************/

extern API_FUNCTION
  NetFileClose ( const char LSFAR * pszServer,
                 unsigned short     usFileId );

extern API_FUNCTION
  NetFileClose2 ( const char LSFAR * pszServer,
                  unsigned long      ulFileId );

extern API_FUNCTION
  NetFileEnum ( const char LSFAR *     pszServer,
                const char LSFAR *     pszBasePath,
                short                  sLevel,
                char LSFAR *           pbBuffer,
                unsigned short         cbBuffer,
                unsigned short LSFAR * pcEntriesRead,
                unsigned short LSFAR * pcTotalAvail );

extern API_FUNCTION
  NetFileEnum2 ( const char LSFAR *     pszServer,
                 const char LSFAR *     pszBasePath,
                 const char LSFAR *     pszUserName,
                 short                  sLevel,
                 char LSFAR *           pbBuffer,
                 unsigned short         cbBuffer,
                 unsigned short LSFAR * pcEntriesRead,
                 unsigned short LSFAR * pcEntriesRemaining,
                 void LSFAR *           pResumeKey );

extern API_FUNCTION
  NetFileGetInfo ( const char LSFAR *     pszServer,
                   unsigned short         usFileId,
                   short                  sLevel,
                   char LSFAR *           pbBuffer,
                   unsigned short         cbBuffer,
                   unsigned short LSFAR * pcbTotalAvail );

extern API_FUNCTION
  NetFileGetInfo2 ( const char LSFAR *     pszServer,
                    unsigned long          ulFileId,
                    short                  sLevel,
                    char LSFAR *           pbBuffer,
                    unsigned short         cbBuffer,
                    unsigned short LSFAR * pcbTotalAvail );


/****************************************************************
 *								*
 *	  	Data structure templates - FILE			*
 *								*
 ****************************************************************/

struct file_info_0 {
    unsigned short	fi0_id;
};  /* file_info_0 */

struct file_info_1 {
    unsigned short     fi1_id;
    unsigned short     fi1_permissions;
    unsigned short     fi1_num_locks;
    char LSFAR * LSPTR fi1_pathname;
    char LSFAR * LSPTR fi1_username;
};  /* file_info_1 */

struct file_info_2 {
    unsigned long	fi2_id;
};  /* file_info_2 */

struct file_info_3 {
    unsigned long      fi3_id;
    unsigned short     fi3_permissions;
    unsigned short     fi3_num_locks;
    char LSFAR * LSPTR fi3_pathname;
    char LSFAR * LSPTR fi3_username;
};  /* file_info_3 */


struct res_file_enum_2 {
    unsigned short	res_pad;	 /* not used now */
    unsigned short      res_fs;          /* server type */
    unsigned long	res_pro;	  /* progressive */
};  /* res_file_enum_2 */

/****************************************************************
 *								*
 *		Special values and constants - FILE		*
 *								*
 ****************************************************************/

					/* bit values for permissions */
#define	PERM_FILE_READ		0x1	/* user has read access */
#define	PERM_FILE_WRITE		0x2	/* user has write access */
#define	PERM_FILE_CREATE	0x4	/* user has create access */


typedef struct res_file_enum_2 FRK;

#define FRK_INIT( f )	\
	{		\
		(f).res_pad = 0L;	\
		(f).res_fs = 0;	\
		(f).res_pro = 0;	\
	}


#endif /* NETFILE_INCLUDED */

#ifdef  INCL_32
#pragma linkage (NetShareAdd, far16 pascal)
#pragma linkage (NetShareCheck, far16 pascal)
#pragma linkage (NetShareDel, far16 pascal)
#pragma linkage (NetShareEnum, far16 pascal)
#pragma linkage (NetShareGetInfo, far16 pascal)
#pragma linkage (NetShareSetInfo, far16 pascal)
#pragma linkage (NetSessionDel, far16 pascal)
#pragma linkage (NetSessionEnum, far16 pascal)
#pragma linkage (NetSessionGetInfo, far16 pascal)
#pragma linkage (NetConnectionEnum, far16 pascal)
#pragma linkage (NetFileClose, far16 pascal)
#pragma linkage (NetFileClose2, far16 pascal)
#pragma linkage (NetFileEnum, far16 pascal)
#pragma linkage (NetFileEnum2, far16 pascal)
#pragma linkage (NetFileGetInfo, far16 pascal)
#pragma linkage (NetFileGetInfo2, far16 pascal)
#pragma pack()
#endif
