/********************************************************************/
/**                     Microsoft LAN Manager                      **/
/**               Copyright(c) Microsoft Corp., 1987-1990          **/
/********************************************************************/

/********************************************************************
 *                                                                  *
 *  About this file ...  HPFS386.H                                  *
 *                                                                  *
 *  This file contains information about the HPFS386 APIs.          *
 *                                                                  *
 *      Function prototypes.                                        *
 *                                                                  *
 *      Data structure templates.                                   *
 *                                                                  *
 *      Definition of special values.                               *
 *                                                                  *
 *                                                                  *
 *  NOTE:  You must include NETCONS.H before this file, since this  *
 *         file depends on values defined in NETCONS.H.             *
 *                                                                  *
 ********************************************************************/

/**INTERNAL_ONLY**/
/*
 *
 *    IMPORTANT!  IMPORTANT! IMPORTANT! IMPORTANT! IMPORTANT! IMPORTANT!
 *    READ THIS FIRST BEFORE MAKING ANY CHANGES
 *
 *  NOTE: This file must be HtoINCable
 *
 *    This file was modified to provide support for 32-bit code.
 *
 *    Any 32-bit module that includes this header file must define
 *    the constant INCL_32.
 *
 *    It is assumed that "netcons.h" is included before this file.
 *
 *    The following contants are defined in netcons.h as shown below:
 *
 *    #ifdef INCL_32    ( defined by 32-bit apps )
 *        #define LSFAR
 *        #define LSPAS
 *        #define LSPTR  _Seg16
 *        #define LSINT  short
 *    #else                 ( for 16-bit apps )
 *        #define LSFAR  far
 *        #define LSPAS  pascal
 *        #define LSPTR
 *        #define LSINT  int
 *    #endif
 *
 *    Do not add any keywords like far, pascal, etc. which are not recognized
 *    by the 32-bit compiler. The constants defined in netcons.h (LSFAR, LSPAS)
 *    must be used to replace these keywords.
 *
 */
/**END_INTERNAL**/

/**INTERNAL_ONLY**/
/*
 *  IBM CHANGE LOG:  (This file is based off the 90jul02 MS LM2.0 build.)
 * mark = def/feat yymondd release who <Description.>
 *
 * @d01 = d   3273 93aug27 ls.r301 glm <Add hi1_MMReadSzTot, hi1_MMReadSz,
 *                                      and hi1_PartialSz.>
 *
 * @d02 = d   4652 93nov12 ls.r301 btl <Add 0x101 to retrieve PV Statistics>
 * @d03 = d   5079 94jan06 ls.r301 btl <Add 0x102 to map HPFS386 memory>
 * @d04 = f    459 94jan07 ls.r301  GY  <For PENTIUM support.  Added
 *                                       HPFS386_Request_MiscInfo and
 *                                       hpfs386_MiscInfo>
 */
/**END_INTERNAL**/


/*NOINC*/
#ifdef  INCL_32
#pragma pack(1)
#endif



/****************************************************************
 *                                                              *
 *                     Function prototypes                      *
 *                                                              *
 ****************************************************************/

#ifdef  INCL_32

APIRET APIENTRY
  HPFS386GETINFO(char *                   pszReserved,
                 char *                   pszInfo,
                 unsigned long            Level,
                 char *                   pbBuffer,
                 unsigned long            cbBuffer,
                 unsigned long *          pcbAvail);

APIRET APIENTRY
  HPFS386REQUEST(char *                   pszReserved,
                 unsigned long            ulFunction,
                 char *                   pbInBuffer,
                 unsigned long            cbInBuffer,
                 char *                   pbOutBuffer,
                 unsigned long            cbOutBuffer,
                 unsigned long *          pcbAvail);

#else

extern API_FUNCTION
  HPFS386GetInfo16(char LSFAR *             pszReserved,
                   char LSFAR *             pszInfo,
                   unsigned short           Level,
                   char LSFAR *             pbBuffer,
                   unsigned short           cbBuffer,
                   unsigned short LSFAR *   pcbAvail);


#endif
/*INC*/


/****************************************************************
 *                                                              *
 *                 Special values and constants                 *
 *                                                              *
 ****************************************************************/

#define  HPFS386_NotRunning      0x00000000
#define  HPFS386_Running         0x00000001
#define  HPFS386_LocallySecure   0x00000002

#define  HPFS386_Request_Lock    0x0
#define  HPFS386_Request_Unlock  0x1
#define  HPFS386_Request_Read    0x2
/**INTERNAL_ONLY**/
#define  HPFS386_Request_VolInfo  0x100
#define  HPFS386_Request_PVStats  0x101
#define  HPFS386_Request_MapMem   0x102
#define  HPFS386_Request_MiscInfo 0x103
/**END_INTERNAL**/

/****************************************************************
 *                                                              *
 *                   Data structure templates                   *
 *                                                              *
 ****************************************************************/

struct hpfs386_info_0   {
      unsigned long hi0_status;
};    /* hpfs386_info_0 */

/**INTERNAL_ONLY**/
/*                 NOTE NOTE: pinbuild/fsd/wrfsctl.asm is dependent upon
 *                 NOTE NOTE: the order of hpfs386_info_1 struc elements!!
*/
/**END_INTERNAL**/

struct hpfs386_info_1 {
    unsigned long hi1_Len;              /* length of structure */
    unsigned char hi1_MajorVer;         /* Volume's version */
    unsigned char hi1_MinorVer;
    unsigned char hi1_pad1[2];
    unsigned long hi1_DrvFlag;          /* SPB flags */
    unsigned long hi1_VolFlag;          /* VOL flags */
    unsigned char hi1_Unit;             /* unit number */
    unsigned char hi1_Drive;            /* drive number */
    unsigned char hi1_LazyFlag;         /* lazy writing flag */
    unsigned char hi1_LazyPri;          /* lazy writing priority */
    unsigned long hi1_BufferIdle;       /* BufferIdle value for drive */
    unsigned long hi1_Maxage;           /* Maxage value for drive */
    unsigned long hi1_SpareDB;          /* count of Spare DBs left on volume */
    unsigned long hi1_Sectors;          /* # of sectors on volume */
    unsigned long hi1_Space;            /* space remaining (in sectors) */
    unsigned char hi1_Label[11];        /* volume label */
    unsigned char hi1_LabelLen;         /* length of volume label */
    unsigned long hi1_BootID;           /* volume serial number */
    unsigned long hi1_AltSPB;           /* alternate spare block sector */
    unsigned long hi1_HFUsed;           /* # of hotfixes in effect */
    unsigned long hi1_HFMax;            /* max # of hotfixes available */
    unsigned long hi1_DDCapabilities;   /* device driver capabilities flag */
    unsigned long hi1_Contig;           /* contiguity factor (in KBytes) */
                                        /*  single sector allocation if == 1 */
/**INTERNAL_ONLY**/
#if 1          /* always defined for IBM Internal use; not for external use */
    unsigned long hi1_MMReadSzTot;      /* size of one Multimedia file read           */
                                        /*  ahead (in KBytes). See REMARKS below.     */
    unsigned long hi1_MMReadSz;         /* size of disk reads used to perform one MM  */
                                        /*  file read ahead (in KBytes). See REMARKS below. */
    unsigned long hi1_PartialSz;        /* non-sector aligned read size (in bytes). See REMARKS below. */
#else
/**END_INTERNAL**/
    unsigned long hi1_Reserved[3];      /* must be passed in as zero */
/**INTERNAL_ONLY**/
#endif
/**END_INTERNAL**/
};      /* hpfs386_info_1 */


struct hpfs386_info_2 {
    unsigned long hi2_CacheReads[2];    /* # of cache reads */
    unsigned long hi2_DiskReads[2];     /* # of synchronous disk reads */
    unsigned long hi2_LazyWrites[2];    /* # of lazy writes */
    unsigned long hi2_DiskWrites[2];    /* # of synchronous disk writes */
    unsigned long hi2_HotFixes;         /* # of hotfixes done */
    unsigned short hi2_ReadHits;        /* Read Cache Hit % */
    unsigned short hi2_WriteHits;       /* Write Cache Hit % */
};      /* hpfs386_info_2 */


/**INTERNAL_ONLY**/
struct hpfs386_info_101 {
    unsigned long hi101_Version;          /* Version number of structure returned */
    unsigned long hi101_NameLength;       /* length of names in entries */
    unsigned long hi101_TotalEntries;     /* Total Number of Entries available */
    unsigned long hi101_NumEntries;       /* number of entries returned */
};    /* hpfs386_info_101 */

struct hpfs386_info_102 {
    unsigned long hi102_Function;         /* Map or Free Map */
    unsigned long hi102_Object;           /* Object type */
    unsigned long hi102_Address;          /* Address to map, free, or returned map */
    unsigned long hi102_Length;           /* Length of object mapped */
    unsigned long hi102_OrigAddress;      /* original global address */
};    /* hpfs386_info_102 */

#define     HPFS386_MAPMEM_MAP      0
#define     HPFS386_MAPMEM_FREEMAP  1

#define     HPFS386_MAPMEM_DATASEG  0     /* map HPFS386 data segment */
#define     HPFS386_MAPMEM_BUFNODES 1     /* map HPFS386 bufnodes */
#define     HPFS386_MAPMEM_HEAP     2     /* map HPFS386 heap */
#define     HPFS386_MAPMEM_USERDEF  32    /* map user specified address */

#ifdef   PENTIUM
struct hpfs386_MiscInfo  {             /* @d04a                        */
   unsigned short hmi_buflen;          /* Length of buffer inc. length */
   unsigned char  hmi_4MBpages;        /* # of 4MB pages - PENTIUM     */
   unsigned char  hmi_pad;             /* Pad for now                  */
   unsigned long  hmi_Status;          /* Status bitmap                */
};    /* hpfs386_MiscInfo */

/* Flags for hmi_Status */
#define  MISCINFO_PENTIUM       0x00000001   /* Running on PENTIUM */


#endif
/**END_INTERNAL**/


/**INTERNAL_ONLY**/
/*
 *      REMARKS on "hi1_MMReadSzTot"
 *      ----------------------------
 *
 *      This is the size of one Multimedia file read ahead, typically the
 *      same as the volume's Contiguity Factor (hi1_Contig).  An
 *      hi1_MMReadSzTot value of zero, means the svr is not doing MM file
 *      read ahead.  NOTE:  one MM read ahead may be composed of one or
 *      *multiple* disk reads.  The value of hi1_MMReadSz determines how
 *      many actual disk reads comprise a MM read ahead (in other words,
 *      hi1_MMReadSzTot / hi1MMReadSz = # of disk reads per read ahead).
 *
 *
 *      REMARKS on "hi1_MMReadSz"
 *      -------------------------
 *
 *      This is the "disk read size" used to perform Multimedia file read
 *      ahead.  If hi1_MMReadSzTot is zero, hi1_MMReadSz is undefined.
 *      NOTE:  one MM read ahead may be composed of one or *multiple*
 *      disk reads.  The value of hi1_MMReadSz determines how many actual
 *      disk reads comprise a MM read ahead (in other words,
 *      hi1_MMReadSzTot / hi1MMReadSz = # of disk reads per read ahead).
 *
 *
 *      REMARKS on "hi1_PartialSz"
 *      --------------------------
 *
 *      When the svr is NOT doing MM file read ahead (ie, hi1_MMReadSzTot
 *      is zero), this field may be used to more closely model how hpfs386
 *      satisfies client read requests on MM files.  When the svr is not
 *      doing MM read ahead, a client's read request will require two disk
 *      reads, if the read range does not begin and end on a sector
 *      boundary.  The first disk read is for "client read size minus
 *      hi1_PartialSz".  The 2nd disk read is for hi1_PartialSz.
 *
 *      When the svr is doing MM file read ahead, this field is still
 *      valid, albeit uninteresting.
*/
/**END_INTERNAL**/


/*NOINC*/
#ifdef   INCL_32
/*INC*/

struct hpfs386_req_LockBuffer      {
      unsigned long   hrlb_ulLinearAddress;
      unsigned long   hrlb_ulPhysicalAddress;
      unsigned long   hrlb_ulLockHandle[3];
};    /* hpfs386_req_LockBuffer */


struct hpfs386_req_LockRequest     {
      unsigned long   hrlr_ulLinearAddress;
      unsigned long   hrlr_ulLength;
      unsigned long   hrlr_ulFlags;
};    /* hpfs386_req_LockRequest */


struct hpfs386_req_Timing          {
      unsigned long   hrtm_ulTimeIn[2];
      unsigned long   hrtm_ulTimeOut[2];
};    /* hpfs386_req_Timing */


struct hpfs386_req_ReadBuffer      {
        unsigned long   hrrb_ulLinearAddress;
        unsigned long   hrrb_ulPhysicalAddress;
        unsigned long   hrrb_ulLength;
};     /* hpfs386_req_ReadBuffer */

struct hpfs386_req_ReadRequest     {
        unsigned long   hrrr_ulNumBufs;
        unsigned long   hrrr_ulHandle;
        unsigned long   hrrr_ulStartSector;
};      /* hpfs386_req_ReadRequest */

/*NOINC*/
#endif
/*INC*/

/*NOINC*/
#ifdef   INCL_32

/**INTERNAL_ONLY**/
#ifdef __IBMC__
/**END_INTERNAL**/

#pragma linkage (HPFS386GETINFO, system)
#pragma linkage (HPFS386REQUEST, system)

/**INTERNAL_ONLY**/
#endif
/**END_INTERNAL**/

#endif
/*INC*/
