/*****************************************************************/
/**                   IBM LAN Services                          **/
/**             Copyright(c) IBM Corp., 1992                    **/
/*****************************************************************/

/********************************************************************
 *                                                                  *
 *  About this file ...  DCDB.H                                     *
 *                                                                  *
 *  This file contains information about the DCDB (Domain Control   *
 *  Data Base) APIs. For Each API class there is a section on:      *
 *                                                                  *
 *      Function prototypes.                                        *
 *                                                                  *
 *      Data structure templates.                                   *
 *                                                                  *
 *      Definition of special values.                               *
 *                                                                  *
 *  NOTE:  You must include NETCONS.H before this file, since this  *
 *         file depends on values defined in NETCONS.H.             *
 *                                                                  *
 ********************************************************************/

#pragma pack(1)

#if !defined NETDCDB_INCLUDED
#define NETDCDB_INCLUDED

#define APP_LEN      8
#define ALIAS_LEN    8


/****************************************************************
 *                                                              *
 *              Function prototypes - NetAliasXXX               *
 *                                                              *
 ****************************************************************/

extern API_FUNCTION
 NetAliasAdd (const char LSFAR *,            /* server                    */
              short,                         /* level (2)                 */
              char LSFAR *,                  /* buffer (send)             */
              unsigned short);               /* buffer length             */

extern API_FUNCTION
 NetAliasDel (const char LSFAR *,            /* server                    */
              char LSFAR *,                  /* alias                     */
              unsigned long);                /* reserved                  */

extern API_FUNCTION
 NetAliasGetInfo (const char LSFAR *,        /* server                    */
                  char LSFAR *,              /* alias                     */
                  short,                     /* level (0, 1, 2)           */
                  char LSFAR *,              /* buffer (receive)          */
                  unsigned short,            /* buffer length             */
                  unsigned short LSFAR *);   /* bytes available           */

extern API_FUNCTION
 NetAliasSetInfo (const char LSFAR *,        /* server                    */
                  char LSFAR *,              /* alias                     */
                  short,                     /* level (1, 2)              */
                  char LSFAR *,              /* buffer (send)             */
                  unsigned short,            /* buffer length             */
                  unsigned short);           /* parameter number          */

extern API_FUNCTION
 NetAliasEnum (const char LSFAR *,           /* server                    */
               short,                        /* level (0, 1, 2)           */
               unsigned short,               /* type                      */
               char LSFAR *,                 /* buffer (receive)          */
               unsigned short,               /* buffer length             */
               unsigned short LSFAR *,       /* entries returned          */
               unsigned short LSFAR *);      /* entries available         */

/****************************************************************
 *                                                              *
 *              Data structure templates - Alias                *
 *                                                              *
 ****************************************************************/

struct alias_info_0 {
   char   ai0_alias[ALIAS_LEN + 1];
};

struct alias_info_1 {
   char                 ai1_alias[ALIAS_LEN + 1];
   char                 ai1_pad;
   char LSFAR * LSPTR   ai1_remark;
   unsigned short       ai1_type;
};

struct alias_info_2 {
   char                 ai2_alias[ALIAS_LEN + 1];
   char                 ai2_pad_1;
   char LSFAR * LSPTR   ai2_remark;
   unsigned short       ai2_type;
   unsigned short       ai2_location;
   char                 ai2_server[CNLEN + 1];
   unsigned short       ai2_mode;
   unsigned short       ai2_maxuses;
   char                 ai2_netname[NNLEN + 1]; /* file or print    */
   char                 ai2_pad_2;
   char                 ai2_queue[QNLEN + 1];   /* print or serial    */
   char                 ai2_pad_3;
   char LSFAR * LSPTR   ai2_path;               /* file only          */
   unsigned short       ai2_priority;           /* serial only        */
   char LSFAR * LSPTR   ai2_device_pool;        /* serial only        */
};

/****************************************************************
 *                                                              *
 *              Special values and constants - Alias            *
 *                                                              *
 ****************************************************************/

/*
 * values for ai2_mode
 */

#define ALIAS_MODE_STARTUP             0x0000
#define ALIAS_MODE_BYADMIN             0x0001

/*
 * value for ai2_mode (files alias only)
 */

#define ALIAS_MODE_DYNAMIC             0x0002

/*
 * values for ai2_location
 */

#define ALIAS_LOCATION_INTERNAL        0x0000
#define ALIAS_LOCATION_EXTERNAL_DOS    0x0001
#define ALIAS_LOCATION_EXTERNAL_OS2    0x0002
#define ALIAS_LOCATION_EXTERNAL_BOTH   0x0003

/*
 * values for type
 */

#define ALIAS_TYPE_FILE                0x0001
#define ALIAS_TYPE_PRINTER             0x0002
#define ALIAS_TYPE_SERIAL              0x0004

/*
 * values for alias SetInfo
 */

#define ALIAS_REMARK_PARMNUM        3
#define ALIAS_MODE_PARMNUM          7
#define ALIAS_MAXUSES_PARMNUM       8
#define ALIAS_PATH_PARMNUM         13
#define ALIAS_PRIORITY_PARMNUM     14
#define ALIAS_DEVICEPOOL_PARMNUM   15

#define AI1_NUM_ELEMENTS            4
#define AI2_NUM_ELEMENTS           15

/****************************************************************
 *                                                              *
 *              Function prototypes - Logon Assignments         *
 *                                                              *
 ****************************************************************/

extern API_FUNCTION
 NetUserGetLogonAsn (const char LSFAR *,        /* server                    */
                     char LSFAR *,              /* user                      */
                     short,                     /* level (1)                 */
                     unsigned short,            /* type                      */
                     char LSFAR *,              /* buffer (receive)          */
                     unsigned short,            /* buffer length             */
                     unsigned short LSFAR *);   /* bytes available           */

extern API_FUNCTION
 NetUserSetLogonAsn(const char LSFAR *,         /* server                    */
                    char LSFAR *,               /* user                      */
                    short,                      /* level (1)                 */
                    char LSFAR *,               /* buffer (send)             */
                    unsigned short);            /* buffer length             */

/****************************************************************
 *                                                              *
 *              Data structure templates - Logon Assignments    *
 *                                                              *
 ****************************************************************/

struct logon_asn_info_1
  {
   unsigned long    lai1_reserved;
   unsigned short   lai1_count;                 /* logon_asn_list structures */
  };

struct logon_asn_list
  {
   char             lal_alias[ALIAS_LEN + 1];
   char             lal_pad;
   unsigned short   lal_type;
   char             lal_device[DEVLEN + 1];     /* drive or device name */
  };


/****************************************************************
 *                                                              *
 *              Function prototypes - Application Selectors     *
 *                                                              *
 ****************************************************************/

extern API_FUNCTION
 NetUserGetAppSel(const char LSFAR *,           /* server                    */
                  char LSFAR *,                 /* user                      */
                  short,                        /* level (1)                 */
                  unsigned short,               /* type                      */
                  char LSFAR *,                 /* buffer (receive)          */
                  unsigned short,               /* buffer length             */
                  unsigned short LSFAR *);      /* bytes available           */

extern API_FUNCTION
 NetUserSetAppSel(const char LSFAR *,           /* server                    */
                  char LSFAR *,                 /* user                      */
                  short,                        /* level (1)                 */
                  char LSFAR *,                 /* buffer (send)             */
                  unsigned short);              /* buffer length             */

/****************************************************************
 *                                                              *
 *              Data structure templates - Application Selectors*
 *                                                              *
 ****************************************************************/

struct app_sel_info_1
  {
   unsigned long    asi1_reserved;
   unsigned short   asi1_count;                 /* app_sel_list structures */
  };

struct app_sel_list
  {
   char             asl_appname[APP_LEN + 1];
   char             asl_pad_1;
   unsigned short   asl_apptype;
   unsigned short   asl_reserved;
  };


extern API_FUNCTION
 NetUserDCDBInit (const char LSFAR *,           /* server    */
                  char LSFAR *,                 /* user      */
                  unsigned long);               /* reserved  */

/****************************************************************
 *                                                              *
 *              Function prototypes - Applications              *
 *                                                              *
 ****************************************************************/

extern API_FUNCTION
 NetAppAdd (const char LSFAR *,                 /* server                    */
            char LSFAR *,                       /* NULL = DCDB.A or -> user  */
            short,                              /* level (3)                 */
            char LSFAR *,                       /* buffer (send)             */
            unsigned short);                    /* buffer length             */

extern API_FUNCTION
 NetAppDel (const char LSFAR *,                 /* server                    */
            char LSFAR *,                       /* NULL = DCDB.A or -> user  */
            char LSFAR *,                       /* name of app to delete     */
            unsigned long);                     /* reserved                  */

extern API_FUNCTION
 NetAppGetInfo (const char LSFAR *,             /* server                    */
                char LSFAR *,                   /* NULL = DCDB.A or -> user  */
                char LSFAR *,                   /* app name                  */
                short,                          /* level (0, 1, 2, 3)        */
                char LSFAR *,                   /* buffer (receive)          */
                unsigned short,                 /* buflen                    */
                unsigned short LSFAR *);        /* bytes available           */

extern API_FUNCTION
 NetAppSetInfo (const char LSFAR *,             /* server                    */
                char LSFAR *,                   /* NULL = DCDB.A or -> user  */
                char LSFAR *,                   /* appname                   */
                short,                          /* level (1, 2, 3)           */
                char LSFAR *,                   /* buffer (send)             */
                unsigned short,                 /* buflen                    */
                unsigned short);                /* parmnum                   */

extern API_FUNCTION
 NetAppEnum (const char LSFAR *,                /* server                    */
             char LSFAR *,                      /* NULL = DCDB.A or -> user  */
             short,                             /* level (0, 1, 2, 3)        */
             unsigned short,                    /* type                      */
             char LSFAR *,                      /* buffer (receive)          */
             unsigned short,                    /* buflen                    */
             unsigned short LSFAR *,            /* entries returned          */
             unsigned short LSFAR *);           /* entries available         */

struct app_info_0 {
   char                 app0_name[APP_LEN + 1];
};

struct app_info_1 {
   char                 app1_name[APP_LEN + 1];
   char                 app1_pad_1;
   char LSFAR * LSPTR   app1_remark;
};

/*
 *  The level 2 structure allows one to enumerate, get or set information
 *  about an application's fixed data only.
 */

struct app_info_2 {
   char                 app2_name[APP_LEN + 1];
   char                 app2_pad_1;
   char LSFAR * LSPTR   app2_remark;
   char LSFAR * LSPTR   app2_command;
   char LSFAR * LSPTR   app2_command_parms;
   char                 app2_app_alias_or_drv[ALIAS_LEN + 1];
   char                 app2_pad_2;
   char                 app2_app_drive;
   char LSFAR * LSPTR   app2_app_path_to_dir;
   char                 app2_wrkdir_alias_or_drv[ALIAS_LEN + 1];
   char                 app2_pad_3;
   char                 app2_wrkdir_drive;
   char LSFAR * LSPTR   app2_wrkdir_path_to_dir;
   char                 app2_prompt;
   char                 app2_interface;
   char                 app2_apptype;
};

struct app_info_3 {
   char                 app3_name[APP_LEN + 1];
   char                 app3_pad_1;
   char LSFAR * LSPTR   app3_remark;
   char LSFAR * LSPTR   app3_command;
   char LSFAR * LSPTR   app3_command_parms;
   char                 app3_app_alias_or_drv[ALIAS_LEN + 1];
   char                 app3_pad_2;
   char                 app3_app_drive;
   char LSFAR * LSPTR   app3_app_path_to_dir;
   char                 app3_wrkdir_alias_or_drv[ALIAS_LEN + 1];
   char                 app3_pad_3;
   char                 app3_wrkdir_drive;
   char LSFAR * LSPTR   app3_wrkdir_path_to_dir;
   char                 app3_prompt;
   char                 app3_interface;
   char                 app3_apptype;
   unsigned short       app3_res_count;
};

/*
 * the following structure contains redirections required by the application
 */

struct app_res_list {
   char   arl_alias[ALIAS_LEN + 1];
   char   arl_pad_1;
   char   arl_device[DEVLEN + 1];
};

/****************************************************************
 *                                                              *
 *              Special values and constants - Applications     *
 *                                                              *
 ****************************************************************/

/*
 * the definitions below are used in various app_info_x.appx_flags elements
 */

/*
 * appx.apptype:  application types  (also masks for NetAppEnum)
 */

#define APP_DOS_PUBLIC   0x1
#define APP_OS2_PUBLIC   0x2
#define APP_OS2_PRIVATE  0x4
#define APP_ALL          0x7
#define APP_TYPE_UNKNOWN 0x40

/*
 * appx_flags.interface:  application interface - OS/2 apps only
 */

#define APP_PM           0x1
#define APP_PROT         0x2
#define APP_VIO          0x4

/*
 * values for application SetInfo
 */

#define APP_REMARK_PARMNUM     3
#define APP_CMDLINE_PARMNUM    4
#define APP_CMDPARMS_PARMNUM   5

#define APP1_NUM_ELEMENTS    3
#define APP2_NUM_ELEMENTS   16

/*
 * The following characters are NOT allowed in application names
 */
#define INVALID_APPNAME_CHARS   " .\"/\\[]:|<>+=;,?*"

/*
 * The following character is NOT allowed in a remark
 */
#define INVALID_REMARK_CHAR  "\\"


#if defined INCL_32
#pragma linkage (NetAliasAdd, far16 pascal)
#pragma linkage (NetAliasDel, far16 pascal)
#pragma linkage (NetAliasGetInfo, far16 pascal)
#pragma linkage (NetAliasSetInfo, far16 pascal)
#pragma linkage (NetAliasEnum, far16 pascal)
#pragma linkage (NetUserGetLogonAsn, far16 pascal)
#pragma linkage (NetUserSetLogonAsn, far16 pascal)
#pragma linkage (NetUserGetAppSel, far16 pascal)
#pragma linkage (NetUserSetAppSel, far16 pascal)
#pragma linkage (NetUserDCDBInit, far16 pascal)
#pragma linkage (NetAppAdd, far16 pascal)
#pragma linkage (NetAppDel, far16 pascal)
#pragma linkage (NetAppGetInfo, far16 pascal)
#pragma linkage (NetAppSetInfo, far16 pascal)
#pragma linkage (NetAppEnum, far16 pascal)
#pragma pack ()
#endif

#endif
