/********************************************************Copyright.IBM*****/
/*                                                                        */
/*                                                                        */
/*      Multi-Protocol Transport Services - select.h                      */
/*                                                                        */
/*      Licensed Materials - Property of IBM (R)                          */
/*      5622-069                                                          */
/*      (C) Copyright IBM Corp. 1993, All right reserved.                 */
/*      US Government Users Restricted Rights - Use, duplication,         */
/*      disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/*                                                                        */
/********************************************************Copyright.IBM*****/




#ifndef MPTNSELECT
#define MPTNSELECT

#define NBBY    8               /* number of bits in a byte */
#ifndef FD_SETSIZE
#define FD_SETSIZE      2048
#endif /* FD_SETSIZE */

typedef long    fd_mask;
#define NFDBITS (sizeof(fd_mask) * NBBY)        /* bits per mask */
#ifndef howmany
#define howmany(x, y)   (((x)+((y)-1))/(y))
#endif

typedef struct fd_set {
        fd_mask fds_bits[howmany(FD_SETSIZE, NFDBITS)];
} fd_set;


#define FD_SET(n, p)    ((p)->fds_bits[(n)/NFDBITS] |= (1L << ((n) % NFDBITS)))
#define FD_CLR(n, p)    ((p)->fds_bits[(n)/NFDBITS] &= ~(1L << ((n) % NFDBITS)))
#define FD_ISSET(n, p)  ((p)->fds_bits[(n)/NFDBITS] & (1L << ((n) % NFDBITS)))
#define FD_ZERO(p)      bzero((char *)(p), sizeof(*(p)))

#ifdef BSD_SELECT
#define select(a,b,c,d,e) bsdselect(a,b,c,d,e)

#ifdef SO32

/* BSDSELECT */
int _System bsdselect(int,
                        struct fd_set *,
                        struct fd_set *,
                        struct fd_set *,
                        struct timeval *);
#endif /* SO32 */
#else /* BSDSELECT */

/* BSDSELECT */
#ifdef SO32
int bsdselect(int,
                        struct fd_set *,
                        struct fd_set *,
                        struct fd_set *,
                        struct timeval *);
#endif /* SO32 */
#endif /* BSDSELECT */

#endif /* MPTNSELECT */
