/********************************************************Copyright.IBM*****/
/*                                                                        */
/*                                                                        */
/*      Multi-Protocol Transport Services                                 */
/*                                                                        */
/*      Licensed Materials - Property of IBM (R)                          */
/*      5622-069                                                          */
/*      (C) Copyright IBM Corp. 1993, All right reserved.                 */
/*      US Government Users Restricted Rights - Use, duplication,         */
/*      disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/*                                                                        */
/********************************************************Copyright.IBM*****/





/* IBM COPYRIGHT 1989                        */
struct MAILBOX {  /* mailbox used by users to call sockets */
  unsigned int sfunc;        /* function to call (given by user)    */
  unsigned int sock_pid;     /* NETINET pid       (given by NETINET */
  unsigned stacksel;         /* stack (selector) provided by user   */
  unsigned stackoff;         /* stack (offset) provided by user     */
} *mailbox;

/* possible values for sfunc */
#define  CALL_SOCKET           0
#define  CALL_BIND             1
#define  CALL_LISTEN           2
#define  CALL_ACCEPT           3
#define  CALL_CONNECT          4
#define  CALL_SENDTO           5
#define  CALL_SEND             6
#define  CALL_SENDMSG          7
#define  CALL_RECVFROM         8
#define  CALL_RECV             9
#define  CALL_RECVMSG         10
#define  CALL_SHUTDOWN        11
#define  CALL_SETSOCKOPT      12
#define  CALL_GETSOCKOPT      13
#define  CALL_GETSOCKNAME     14
#define  CALL_GETPEERNAME     15
#define  CALL_CLOSE           16
#define  CALL_IOCTL           17
#define  CALL_SELECT          18
#define  CALL_GETHOSTID       19
#define  CALL_GETVERSION      20
#define  CALL_EXIT            21
#define  CANCEL_CALL          1000
#define SHARED_SEGMENT_NAME "\\SHAREMEM\\MAILBOX"
#define SHARED_SEGMENT_SIZE sizeof(struct MAILBOX)
#define STACKSIZE (8192+4096)

char mailbox_sem_name[]="\\SEM\\NETINET\\MAIL";
char socket_sem_name[] ="\\SEM\\NETINET\\SOCK";
unsigned long socket_demux_sem, mailbox_sem;
