/********************************************************Copyright.IBM*****/
/*                                                                        */
/*                                                                        */
/*      Multi-Protocol Transport Services - ftpapi.h                      */
/*                                                                        */
/*      Licensed Materials - Property of IBM (R)                          */
/*      5622-069                                                          */
/*      (C) Copyright IBM Corp. 1993, All right reserved.                 */
/*      US Government Users Restricted Rights - Use, duplication,         */
/*      disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/*                                                                        */
/********************************************************Copyright.IBM*****/




#define T_ASCII      1
#define T_EBCDIC     2
#define T_BINARY     3

extern int ftperrno;
#define FTPSERVICE    1    /* ftp: ftp/tcp: unknown service */
#define FTPHOST       2    /* unknown host */
#define FTPSOCKET     3    /* unable to obtain socket */
#define FTPCONNECT    4    /* unable to connect to server */
#define FTPLOGIN      5    /* login failed */
#define FTPABORT      6    /* transfer aborted */
#define FTPLOCALFILE  7    /* problem openning local file */
#define FTPDATACONN   8    /* problem initializing data connection */
#define FTPCOMMAND    9    /* command failed */
#define FTPPROXYTHIRD 10   /* proxy server does not support third party transfers */
#define FTPNOPRIMARY  11   /* No primary connection for proxy transfer */

/* ping error codes */
#define PINGREPLY     -1   /* host does not reply */
#define PINGSOCKET    -3   /* unable to obtain socket */
#define PINGPROTO     -4   /* unknown protcol ICMP */
#define PINGSEND      -5   /* send failed */
#define PINGRECV      -6   /* recv failed */
#define PINGHOST      -7   /* unable to resolfe host given in ftpping() */
                           /* Added - Kristy Smith 06/91 */

int  ping(unsigned long, int) ;          /* correction - kks 04/01/91 */
void ftplogoff(void);                    /* correction - kks 04/01/91 */
int ftpget(char *, char *, char *, char *, char *, char *, char *, int);
int ftpput(char *, char *, char *, char *, char *, char *, int);
int ftpappend(char *, char *, char *, char *, char *, char *, int);
int ftpputunique(char *, char *, char *, char *, char *, char *, int);
int ftpcd(char *, char *, char *, char *, char *);
int ftpmkd(char *, char *, char *, char *, char *);
int ftprmd(char *, char *, char *, char *, char *);
int ftpdelete(char *, char *, char *, char *, char *);
int ftprename(char *, char *, char *, char *, char *, char *);
int ftpls(char *, char *, char *, char *, char *, char *);
int ftpdir(char *, char *, char *, char *, char *, char *);
int ftpproxy(char *, char *, char *, char *, char *, char *, char *, char *, char *, char *, int);
int ftpsite(char *, char *, char *, char *, char *);
int ftpquote(char *, char *, char *, char *, char *);
int ftppwd(char *, char *, char *, char *, char*, int);        /* Added - Kristy Smith 04/91 */
int ftpsys(char *, char *, char *, char *, char*, int);        /* Added - Kristy Smtih 04/91 */
int ftpping(char *, int, unsigned long *);                     /* Added - Kristy Smith 06/91 */
