/********************************************************Copyright.IBM*****/
/*                                                                        */
/*                                                                        */
/*      Multi-Protocol Transport Services                                 */
/*                                                                        */
/*      Licensed Materials - Property of IBM (R)                          */
/*      5622-069                                                          */
/*      (C) Copyright IBM Corp. 1993, All right reserved.                 */
/*      US Government Users Restricted Rights - Use, duplication,         */
/*      disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/*                                                                        */
/********************************************************Copyright.IBM*****/




#ifndef _DLCGBLV
#define _DLCGBLV
/*------------------------------------------------------------------------+
|  DLC status change message structure                                    |
+------------------------------------------------------------------------*/

typedef struct DLCStatusTable {
        word    stationid;
        word    reg_ax;
        byte    reasoncode[5];
        byte    accessprty;
        byte    remote_node[6];
        byte    remote_sap;
        byte    lana;
        }DLC_STAT_TBL;

#define MACplusLLC      (sizeof( struct mac_hdr ) + sizeof( struct llc_hdr))

typedef struct {
        byte   *next_buf_ptr;
        byte    data[1];
        } BUFFER;


union pt_add
   {
   unsigned long int address;
   struct {
      word offset;
      word segment;
      } part;
   };

union pt_types
   {
   struct dlc_open_sap_parms open_sap;
   struct dlc_connect_station_parms connect;
   struct dlc_open_station_parms open_station;
   struct dir_initialize_parms init;
   struct dir_status_parms status;
   struct receive_parms receive;
   struct transmit_parms transmit;
   struct read_parms read;
   struct dir_open_adapter_parms open;
   struct dir_open_direct_parms opend;
   struct dir_set_exception_parms_dlr exception;
   struct buffer_free_parms bufferfree;
   };

struct open_pt
   {
   struct dir_open_ad_parms  adpt;
   struct dir_open_dlc_parms dlcpt;
   };

struct ccb_pt
   {
   struct command_control_block_dlr ccb;
   union pt_types  pt;
   struct open_pt  opt;
   };


#define SEND    0               /* mode flag for SEND                 */
#define RECV    1               /* mode flag for RECEIVE              */
#define DISP    2               /* mode flag for DISPLAY              */
#define MYSAP   0xA4
#define BELL_CHAR       '\007'
#define READ_SAP 0x01           /* READ match options           */
#define ZEROADDRESS     ((unsigned char *)(0L))

/* Twelve is a magic number; sizeof( ASI overhead ); see tech ref */
#define BUFFER_SIZE             500                     /* Our packet chain buffers */
#define RAW_BUFFER_SIZE 1024       /* Our packet chain buffers */

/* ~15k bytes total */
#define DIR_POOL_LEN    256     /* Dir.Pool.Length (In paragraphs, ie. 16 bytes) */

#define ADAPTER_CHECK    0x0001
#define NETWORK_STATUS   0x0002
#define PC_ERROR         0x0004
#define SYSTEM_ACTION    0x0008

#define DIR_STATION    ((unsigned) 0) /* SAP for direct station               */
#define NULL_SAP ((u_char) 0)         /* null SAP for use in transmit command */

/* !!! These values are already byteswapped to net order !!!    Really */
#define ARTRN   0x0600                  /* 802.x hardware type                  0x0006 */
#define TRIP    0x0008                  /* IP type field as word                0x0800 */
#define TRARP   0x0608                  /* ARP type field as word               0x0806 */
#define TR_IP   TRIP                    /* IP type field as word                0x0800 */
#define TR_ARP  TRARP                   /* ARP type field as word               0x0806 */

#define ETHER_IP                1500            /* What ethernet uses */
#define AIX_IP                  1576            /* What AIX uses */
#define TOKEN_MTU       ( AIX_IP )

/* READ event_set definitions */
//#define CRIT_EXCEPTION_EVENT 0x30
#define CRIT_EXCEPTION_EVENT 0x10
#define RECEIVE_DATA_EVENT   0x04
#endif
