/************************************************************************\
*                                                                        *  
*         Microsoft C  Language Sample Gateway HLLAPI Module             *
*                                                                        *  
*       (C) Copyright Software Corporation of America, Inc. 1989.        *
*       All Rights Reserved.                                             *
*                                                                        *  
\************************************************************************/



/************************************************************************\
*                                                                        *  
*               Individual Session Definition Structure                  *
*                                                                        *  
\************************************************************************/

struct Session						/* Session Information Structure  */
{
	char	ShortName;				    /* Short Name for Session         */
	char	LongName[8];				/* Long Name for Session          */
	char	Type;						/* Session Type                   */
	int 	Size;						/* Session Presentation Space Size*/
};




/************************************************************************\
*                                                                        *  
*               Wait for List Definition Structure                       *
*                                                                        *  
\************************************************************************/

struct WaitItem						/* Wait For List Item Structure   */
{
	char far *pszString;			    /* Key String                     */
	int 	  Size;						/* Key String Size                */
	int 	  StartAt;					/* PS Search Start Position       */
	int 	  EndAt;					/* PS Search End Position         */
	int 	  FoundAt;					/* PS Located Position            */
};





/************************************************************************\
*                                                                        *  
*        Sample Subroutine prototypes                                    *
*                                                                        *  
\************************************************************************/

										/* HLLAPI 12 routines             */
extern int HapiConnect(char);							   		/* Function  1 */
extern int HapiDisconnect();							   		/* Function  2 */
extern int HapiSendKey(char *, int); 					   	/* Function  3 */
extern int HapiWait();								   			/* Function  4 */
extern int HapiCopyPS(char *);						   		/* Function  5 */
extern int HapiSearchPS(char *, int, int);			   	/* Function  6 */
extern int HapiGetPosition();							   		/* Function  7 */
extern int HapiCopyPSString(char *, int, int); 		   	/* Function  8 */
extern int HapiSetSessionPrms(char *, int);			   	/* Function  9 */
extern int HapiQuerySessions(struct Session *, int);		/* Function 10 */
extern int HapiReserve();								  			/* Function 11 */
extern int HapiRelease();								   		/* Function 12 */


										/* HLLAPI 99 routines             */
extern int HapiCopuOIA(char *);				 	       /* Function 13 */
extern int HapiQueryFieldAttr(int);			   	       /* Function 14 */
extern int HapiCopyStringPS(char *, int, int);  	       /* Function 15 */
extern int HapiPause(int);  	                   	       /* Function 18 */
extern int HapiResetSystem();                   	       /* Function 21 */
extern int HapiQuerySessStatus(char *);         	       /* Function 22 */
extern int HapiStartHostAsyncNote(char, char, PHSEM *); 	/* Function 23 */
extern int HapiQueryHostUpdate(char);						 	/* Function 24 */
extern int HapiStopHostNote(char);							 	/* Function 25 */
extern int HapiSearchField(char *, int, int);            /* Function 30 */
extern int HapiFindFieldPos(char *, int); 	           /* Function 31 */
extern int HapiFindFieldLen(char *, int); 	           /* Function 32 */
extern int HapiCopyStringField(char *, int, int);        /* Function 33 */
extern int HapiCopyFieldString(char *, int, int);        /* Function 34 */
extern int HapiSendFile(char *, int);	   		           /* Function 90 */
extern int HapiRecvFile(char *, int);	   		           /* Function 91 */
extern int HapiInvokeDosPgm(char *, int);		   		   /* Function 92 */
extern int HapiDosRedirect(char *, int);		   		   /* Function 93 */
extern int HapiConvert(char *, int, int);		   		   /* Function 99 */


										/* Gateway API Extension routines */
extern int GapiVerify(int); 	 	                       /* Function CK */
extern int GapiStartEmulation(char *, int); 	 	       /* Function 01 */
extern int GapiEndEmulation(); 	 	                   /* Function 02 */
extern int GapiUnloadAPI(); 		 	                   /* Function 03 */
extern int GapiUnloadDrivers();	 	                   /* Function 04 */
extern int GapiLinkConnect();	   	                       /* Function 05 */
extern int GapiLinkDisconnect();	 	                   /* Function 06 */
extern int GapiSessionCall(char *, int, int);            /* Function 07 */
extern int GapiSessionCallClear(int);                    /* Function 08 */
extern int GapiReadData(char *, int, int);               /* Function 10 */
extern int GapiWriteData(char *, int, int);              /* Function 11 */
extern int GapiWaitFor(char *, int, int);                /* Function 12 */
extern int GapiWaitForList(char *, int, int);            /* Function 13 */
extern int GapiRunScript(char *, int);                   /* Function 14 */
extern int GapiFileTransfer(char *, int, int);           /* Function 15 */

