# Copyright (c) 1993 by Sanjay Ghemawat
#
# Startup script for X-based ical

# Parse arguments (some argument parsing has already been done by startup.tcl)
set popup 0
while {[llength $argv] != 0} {
    set arg [lindex $argv 0]
    set argv [lrange $argv 1 end]

    case $arg in {
	"-popup" {set popup 1}
	default  {ical_usage}
    }
}

############################################################################
# Load calendar

calendar cal $ical(calendar)

############################################################################
# Window interaction

# Handle background errors
proc tkerror {message} {
    global ical errorInfo

    # Ignore color allocation errors
    if [string match "no more colors left in colormap;*" $message] {
	error_notify "" {Ical could not allocate the colors it needed.  Monochrome mode will be used from now on if necessary.}
	return
    }

    set message "Ical Version $ical(version)\n\n$message\n\nTrace:\n$errorInfo"
    bug_notify $ical(mailer) $ical(author) $message
}

# Remove default window
wm withdraw .

# Handle preferences
pref init

# Hooks
create-hook ical-startup
create-hook ical-exit
create-hook dayview-startup
create-hook dayview-close
create-hook item-create

if [file exists ~/.tk/ical/user.tcl] {
    if [catch {source ~/.tk/ical/user.tcl} msg] {
	error_notify "" "Error loading \"~/.tk/ical/user.tcl\"\n\n$msg"
    }
}

run-hook ical-startup

if {$popup} {
    # Create item listing
    set l [ItemListing]
    $l mainwindow
    $l dayrange [date today] [date today]
    if {$ical(geometry) != ""} {wm geometry [$l window] $ical(geometry)}
} else {
    # Various background threads
    io_thread
    start_alarmer
    start_midnight_thread

    # Create initial view
    set dv [DayView]
    if {$ical(iconic)} {wm iconify [$dv window]}
    if {$ical(geometry) != ""} {wm geometry [$dv window] $ical(geometry)}
}
